package drr.regulation.jfsa.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionSpread;
import drr.regulation.jfsa.rewrite.trade.PriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg1;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import drr.regulation.jfsa.rewrite.trade.StrikePriceAndNotation;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import iso20022.auth030.jfsa.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class JFSATransactionReportValidator implements Validator<JFSATransactionReport> {

	private List<ComparisonResult> getComparisonResults(JFSATransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("earlyTerminationDate", (Date) o.getEarlyTerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("entityResponsibleForReporting", (String) o.getEntityResponsibleForReporting() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierType", (Boolean) o.getCounterparty2IdentifierType() != null ? 1 : 0, 1, 1), 
				checkCardinality("direction1", (String) o.getDirection1() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction2Leg1", (String) o.getDirection2Leg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction2Leg2", (String) o.getDirection2Leg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("newSDRIdentifier", (String) o.getNewSDRIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapSDRIdentifier", (String) o.getOriginalSwapSDRIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 0, 1), 
				checkCardinality("centralCounterparty", (String) o.getCentralCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingMember", (String) o.getClearingMember() != null ? 1 : 0, 0, 1), 
				checkCardinality("platformIdentifier", (String) o.getPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmed", (String) o.getConfirmed() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalContractualSettlementDate", (Date) o.getFinalContractualSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationTimestamp", (ZonedDateTime) o.getConfirmationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingAccountOrigin", (String) o.getClearingAccountOrigin() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUTI", (String) o.getOriginalSwapUTI() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUTIProprietary", (String) o.getOriginalSwapUTIProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingReceiptTimestamp", (ZonedDateTime) o.getClearingReceiptTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("uti", (String) o.getUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("utiProprietary", (String) o.getUtiProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUti", (String) o.getPriorUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiProprietary", (String) o.getPriorUtiProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg1", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg2", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg1", (String) o.getFixedRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg2", (String) o.getFixedRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg1", (String) o.getFloatingRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg2", (String) o.getFloatingRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg1", (ZonedDateTime) o.getFixingDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg2", (ZonedDateTime) o.getFixingDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodLeg1", (String) o.getFloatingRateResetFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodOfLeg2", (String) o.getFloatingRateResetFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationAmount", (BigDecimal) o.getValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationCurrency", (ISOCurrencyCodeEnum) o.getValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationMethod", (ValuationType1Code) o.getValuationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationTimestamp", (ZonedDateTime) o.getValuationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("price", (PriceAndNotation) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceNotation", (String) o.getPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceUnitOfMeasure", (String) o.getPriceUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg1", (BigDecimal) o.getFixedRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg2", (BigDecimal) o.getFixedRateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1", (SpreadOfLeg1) o.getSpreadOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationOfLeg1", (String) o.getSpreadNotationOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg2", (SpreadOfLeg2) o.getSpreadOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationOfLeg2", (String) o.getSpreadNotationOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (StrikePriceAndNotation) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceNotation", (String) o.getStrikePriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumPaymentDate", (Date) o.getOptionPremiumPaymentDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("firstExerciseDate", (Date) o.getFirstExerciseDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRate", (BigDecimal) o.getExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg1", (BigDecimal) o.getNotionalLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg2", (BigDecimal) o.getNotionalLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callAmount", (BigDecimal) o.getCallAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("putAmount", (BigDecimal) o.getPutAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyOfLeg1", (ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyOfLeg2", (ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callCurrency", (ISOCurrencyCodeEnum) o.getCallCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("putCurrency", (ISOCurrencyCodeEnum) o.getPutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg1", (String) o.getQuantityUnitOfMeasureLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg2", (String) o.getQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg1", (BigDecimal) o.getTotalNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventIdentifier", (String) o.getEventIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("embeddedOptionType", (String) o.getEmbeddedOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("upi", (String) o.getUpi() != null ? 1 : 0, 0, 1), 
				checkCardinality("deliveryType", (String) o.getDeliveryType() != null ? 1 : 0, 0, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("underlyingIdentificationType", (String) o.getUnderlyingIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentification", (String) o.getUnderlyingIdentification() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIndexIndicator", (String) o.getUnderlyingIndexIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheUnderlyingIndex", (String) o.getNameOfTheUnderlyingIndex() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceEntity", (String) o.getReferenceEntity() != null ? 1 : 0, 0, 1), 
				checkCardinality("indicatorOfTheFloatingRateOfLeg1", (String) o.getIndicatorOfTheFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("indicatorOfTheFloatingRateOfLeg2", (String) o.getIndicatorOfTheFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg1", (String) o.getNameOfTheFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg2", (String) o.getNameOfTheFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg1TimePeriod", (String) o.getFloatingRateReferencePeriodOfLeg1TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2TimePeriod", (String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg1Multiplier", (Integer) o.getFloatingRateReferencePeriodOfLeg1Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2Multiplier", (Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("isCrypto", (Boolean) o.getIsCrypto() != null ? 1 : 0, 1, 1), 
				checkCardinality("maturityDateOfTheUnderlying", (Date) o.getMaturityDateOfTheUnderlying() != null ? 1 : 0, 0, 1), 
				checkCardinality("seniority", (String) o.getSeniority() != null ? 1 : 0, 0, 1), 
				checkCardinality("series", (Integer) o.getSeries() != null ? 1 : 0, 0, 1), 
				checkCardinality("version", (Integer) o.getVersion() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexAttachmentPoint", (BigDecimal) o.getCdSIndexAttachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexDetachmentPoint", (BigDecimal) o.getCdSIndexDetachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("customBasketCode", (String) o.getCustomBasketCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("contractType", (String) o.getContractType() != null ? 1 : 0, 1, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIdentifier", (String) o.getPackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPrice", (PackageTransactionPrice) o.getPackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceNotation", (String) o.getPackageTransactionPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpread", (PackageTransactionSpread) o.getPackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadNotation", (String) o.getPackageTransactionSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("delta", (BigDecimal) o.getDelta() != null ? 1 : 0, 0, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 0, 1), 
				checkCardinality("barrier", (BarrierAndNotation) o.getBarrier() != null ? 1 : 0, 0, 1), 
				checkCardinality("nonReportable", (JFSANonReportable) o.getNonReportable() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("JFSATransactionReport", ValidationResult.ValidationType.CARDINALITY, "JFSATransactionReport", path, "", res.getError());
				}
				return success("JFSATransactionReport", ValidationResult.ValidationType.CARDINALITY, "JFSATransactionReport", path, "");
			})
			.collect(toList());
	}

}
