package drr.regulation.jfsa.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.StrikePriceScheduleReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class StrikePriceScheduleReportTypeFormatValidator implements Validator<StrikePriceScheduleReport> {

	private List<ComparisonResult> getComparisonResults(StrikePriceScheduleReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("strikePriceInEffectOnAssociatedEffectiveDateMonetary", o.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("strikePriceInEffectOnAssociatedEffectiveDateDecimal", o.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal(), of(11), of(10), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceScheduleReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("StrikePriceScheduleReport", ValidationResult.ValidationType.TYPE_FORMAT, "StrikePriceScheduleReport", path, "", res.getError());
				}
				return success("StrikePriceScheduleReport", ValidationResult.ValidationType.TYPE_FORMAT, "StrikePriceScheduleReport", path, "");
			})
			.collect(toList());
	}

}
