package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0002a_01")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0002a_01.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0002a_01 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0002a_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and [\"OPTN\", \"SWPT\", \"SWAP\", \"CFDS\"] any = contractType then (if (barrier -> singleBarrierPriceMonetary exists and barrier -> singleBarrierPriceMonetary = 1) then barrier -> singleBarrierPriceCurrency exists)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0002a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("OPTN"), MapperS.of("SWPT"), MapperS.of("SWAP"), MapperS.of("CFDS")), MapperS.of(jFSATransactionReport).<String>map("getContractType", _jFSATransactionReport -> _jFSATransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
					if (exists(MapperS.of(jFSATransactionReport).<BarrierAndNotation>map("getBarrier", _jFSATransactionReport -> _jFSATransactionReport.getBarrier()).<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary())).andNullSafe(areEqual(MapperS.of(jFSATransactionReport).<BarrierAndNotation>map("getBarrier", _jFSATransactionReport -> _jFSATransactionReport.getBarrier()).<BigDecimal>map("getSingleBarrierPriceMonetary", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceMonetary()), MapperS.of(BigDecimal.valueOf(1)), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<BarrierAndNotation>map("getBarrier", _jFSATransactionReport -> _jFSATransactionReport.getBarrier()).<ISOCurrencyCodeEnum>map("getSingleBarrierPriceCurrency", barrierAndNotation -> barrierAndNotation.getSingleBarrierPriceCurrency()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0002a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
