package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("SpreadOfLeg2MonetaryOrDecimalOrBasis")
@ImplementedBy(SpreadOfLeg2MonetaryOrDecimalOrBasis.Default.class)
public interface SpreadOfLeg2MonetaryOrDecimalOrBasis extends Validator<SpreadOfLeg2> {
	
	String NAME = "SpreadOfLeg2MonetaryOrDecimalOrBasis";
	String DEFINITION = "optional choice spreadOfLeg2Monetary, spreadOfLeg2Decimal, spreadOfLeg2Basis";
	
	class Default implements SpreadOfLeg2MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 spreadOfLeg2) {
			ComparisonResult result = executeDataRule(spreadOfLeg2);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg2", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg2", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SpreadOfLeg2 spreadOfLeg2) {
			try {
				return choice(MapperS.of(spreadOfLeg2), Arrays.asList("spreadOfLeg2Monetary", "spreadOfLeg2Decimal", "spreadOfLeg2Basis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SpreadOfLeg2MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 spreadOfLeg2) {
			return Collections.emptyList();
		}
	}
}
