package drr.regulation.mas.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.mas.rewrite.margin.meta.MASMarginReportMeta;
import iso20022.auth108.mas.CollateralisationType3Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="MASMarginReport", builder=MASMarginReport.MASMarginReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="MASMarginReport", model="drr", builder=MASMarginReport.MASMarginReportBuilderImpl.class, version="5.57.0")
public interface MASMarginReport extends RosettaModelObject {

	MASMarginReportMeta metaData = new MASMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	String getCounterparty1();
	String getCounterparty2();
	Boolean getCounterparty2IdentifierType();
	String getReportingSpecifiedPerson();
	String getDataSubmitter();
	String getUniqueTransactionIdentifier();
	String getUniqueTransactionIdentifierProprietary();
	ZonedDateTime getReportingTimestamp();
	ZonedDateTime getCollateralTimestamp();
	Boolean getCollateralPortfolioIndicator();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	BigDecimal getInitialMarginPostedByCounterparty1PreHaircut();
	BigDecimal getInitialMarginPostedByCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency();
	BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut();
	BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency();
	BigDecimal getVariationMarginPostedByCounterparty1PreHaircut();
	BigDecimal getVariationMarginPostedByCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency();
	BigDecimal getVariationMarginCollectedByCounterparty1PreHaircut();
	BigDecimal getVariationMarginCollectedByCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency();
	BigDecimal getExcessCollateralPostedByCounterparty1();
	String getCurrencyOfExcessCollateralPosted();
	BigDecimal getExcessCollateralCollectedByCounterparty1();
	String getCurrencyOfExcessCollateralCollected();
	CollateralisationType3Code getCollateralisationCategory();
	MarginActionEnum getActionType();
	ZonedDateTime getEventDate();
	String getTechnicalRecordId();
	String getExecutionAgentOfTheCounterparty1();

	/*********************** Build Methods  ***********************/
	MASMarginReport build();
	
	MASMarginReport.MASMarginReportBuilder toBuilder();
	
	static MASMarginReport.MASMarginReportBuilder builder() {
		return new MASMarginReport.MASMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends MASMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends MASMarginReport> getType() {
		return MASMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
		processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginPostedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginCollectedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginPostedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginCollectedByCounterparty1Currency(), this);
		processor.processBasic(path.newSubPath("excessCollateralPostedByCounterparty1"), BigDecimal.class, getExcessCollateralPostedByCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfExcessCollateralPosted"), String.class, getCurrencyOfExcessCollateralPosted(), this);
		processor.processBasic(path.newSubPath("excessCollateralCollectedByCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfExcessCollateralCollected"), String.class, getCurrencyOfExcessCollateralCollected(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface MASMarginReportBuilder extends MASMarginReport, RosettaModelObjectBuilder {
		MASMarginReport.MASMarginReportBuilder setCounterparty1(String counterparty1);
		MASMarginReport.MASMarginReportBuilder setCounterparty2(String counterparty2);
		MASMarginReport.MASMarginReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		MASMarginReport.MASMarginReportBuilder setReportingSpecifiedPerson(String reportingSpecifiedPerson);
		MASMarginReport.MASMarginReportBuilder setDataSubmitter(String dataSubmitter);
		MASMarginReport.MASMarginReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		MASMarginReport.MASMarginReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		MASMarginReport.MASMarginReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		MASMarginReport.MASMarginReportBuilder setCollateralTimestamp(ZonedDateTime collateralTimestamp);
		MASMarginReport.MASMarginReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		MASMarginReport.MASMarginReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		MASMarginReport.MASMarginReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1PreHaircut(BigDecimal initialMarginPostedByCounterparty1PreHaircut);
		MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1PostHaircut(BigDecimal initialMarginPostedByCounterparty1PostHaircut);
		MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency);
		MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal initialMarginCollectedByCounterparty1PreHaircut);
		MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal initialMarginCollectedByCounterparty1PostHaircut);
		MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency);
		MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1PreHaircut(BigDecimal variationMarginPostedByCounterparty1PreHaircut);
		MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1PostHaircut(BigDecimal variationMarginPostedByCounterparty1PostHaircut);
		MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency);
		MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1PreHaircut(BigDecimal variationMarginCollectedByCounterparty1PreHaircut);
		MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1PostHaircut(BigDecimal variationMarginCollectedByCounterparty1PostHaircut);
		MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency);
		MASMarginReport.MASMarginReportBuilder setExcessCollateralPostedByCounterparty1(BigDecimal excessCollateralPostedByCounterparty1);
		MASMarginReport.MASMarginReportBuilder setCurrencyOfExcessCollateralPosted(String currencyOfExcessCollateralPosted);
		MASMarginReport.MASMarginReportBuilder setExcessCollateralCollectedByCounterparty1(BigDecimal excessCollateralCollectedByCounterparty1);
		MASMarginReport.MASMarginReportBuilder setCurrencyOfExcessCollateralCollected(String currencyOfExcessCollateralCollected);
		MASMarginReport.MASMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code collateralisationCategory);
		MASMarginReport.MASMarginReportBuilder setActionType(MarginActionEnum actionType);
		MASMarginReport.MASMarginReportBuilder setEventDate(ZonedDateTime eventDate);
		MASMarginReport.MASMarginReportBuilder setTechnicalRecordId(String technicalRecordId);
		MASMarginReport.MASMarginReportBuilder setExecutionAgentOfTheCounterparty1(String executionAgentOfTheCounterparty1);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
			processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginPostedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getInitialMarginCollectedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginPostedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, getVariationMarginCollectedByCounterparty1Currency(), this);
			processor.processBasic(path.newSubPath("excessCollateralPostedByCounterparty1"), BigDecimal.class, getExcessCollateralPostedByCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfExcessCollateralPosted"), String.class, getCurrencyOfExcessCollateralPosted(), this);
			processor.processBasic(path.newSubPath("excessCollateralCollectedByCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfExcessCollateralCollected"), String.class, getCurrencyOfExcessCollateralCollected(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
		}
		

		MASMarginReport.MASMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of MASMarginReport  ***********************/
	class MASMarginReportImpl implements MASMarginReport {
		private final String counterparty1;
		private final String counterparty2;
		private final Boolean counterparty2IdentifierType;
		private final String reportingSpecifiedPerson;
		private final String dataSubmitter;
		private final String uniqueTransactionIdentifier;
		private final String uniqueTransactionIdentifierProprietary;
		private final ZonedDateTime reportingTimestamp;
		private final ZonedDateTime collateralTimestamp;
		private final Boolean collateralPortfolioIndicator;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final BigDecimal initialMarginPostedByCounterparty1PreHaircut;
		private final BigDecimal initialMarginPostedByCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency;
		private final BigDecimal initialMarginCollectedByCounterparty1PreHaircut;
		private final BigDecimal initialMarginCollectedByCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency;
		private final BigDecimal variationMarginPostedByCounterparty1PreHaircut;
		private final BigDecimal variationMarginPostedByCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency;
		private final BigDecimal variationMarginCollectedByCounterparty1PreHaircut;
		private final BigDecimal variationMarginCollectedByCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency;
		private final BigDecimal excessCollateralPostedByCounterparty1;
		private final String currencyOfExcessCollateralPosted;
		private final BigDecimal excessCollateralCollectedByCounterparty1;
		private final String currencyOfExcessCollateralCollected;
		private final CollateralisationType3Code collateralisationCategory;
		private final MarginActionEnum actionType;
		private final ZonedDateTime eventDate;
		private final String technicalRecordId;
		private final String executionAgentOfTheCounterparty1;
		
		protected MASMarginReportImpl(MASMarginReport.MASMarginReportBuilder builder) {
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
			this.dataSubmitter = builder.getDataSubmitter();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.collateralTimestamp = builder.getCollateralTimestamp();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.initialMarginPostedByCounterparty1PreHaircut = builder.getInitialMarginPostedByCounterparty1PreHaircut();
			this.initialMarginPostedByCounterparty1PostHaircut = builder.getInitialMarginPostedByCounterparty1PostHaircut();
			this.initialMarginPostedByCounterparty1Currency = builder.getInitialMarginPostedByCounterparty1Currency();
			this.initialMarginCollectedByCounterparty1PreHaircut = builder.getInitialMarginCollectedByCounterparty1PreHaircut();
			this.initialMarginCollectedByCounterparty1PostHaircut = builder.getInitialMarginCollectedByCounterparty1PostHaircut();
			this.initialMarginCollectedByCounterparty1Currency = builder.getInitialMarginCollectedByCounterparty1Currency();
			this.variationMarginPostedByCounterparty1PreHaircut = builder.getVariationMarginPostedByCounterparty1PreHaircut();
			this.variationMarginPostedByCounterparty1PostHaircut = builder.getVariationMarginPostedByCounterparty1PostHaircut();
			this.variationMarginPostedByCounterparty1Currency = builder.getVariationMarginPostedByCounterparty1Currency();
			this.variationMarginCollectedByCounterparty1PreHaircut = builder.getVariationMarginCollectedByCounterparty1PreHaircut();
			this.variationMarginCollectedByCounterparty1PostHaircut = builder.getVariationMarginCollectedByCounterparty1PostHaircut();
			this.variationMarginCollectedByCounterparty1Currency = builder.getVariationMarginCollectedByCounterparty1Currency();
			this.excessCollateralPostedByCounterparty1 = builder.getExcessCollateralPostedByCounterparty1();
			this.currencyOfExcessCollateralPosted = builder.getCurrencyOfExcessCollateralPosted();
			this.excessCollateralCollectedByCounterparty1 = builder.getExcessCollateralCollectedByCounterparty1();
			this.currencyOfExcessCollateralCollected = builder.getCurrencyOfExcessCollateralCollected();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.actionType = builder.getActionType();
			this.eventDate = builder.getEventDate();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByCounterparty1PreHaircut() {
			return initialMarginPostedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByCounterparty1PostHaircut() {
			return initialMarginPostedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency() {
			return initialMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut() {
			return initialMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut() {
			return initialMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency() {
			return initialMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByCounterparty1PreHaircut() {
			return variationMarginPostedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByCounterparty1PostHaircut() {
			return variationMarginPostedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency() {
			return variationMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByCounterparty1PreHaircut() {
			return variationMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByCounterparty1PostHaircut() {
			return variationMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency() {
			return variationMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByCounterparty1")
		@RuneAttribute("excessCollateralPostedByCounterparty1")
		public BigDecimal getExcessCollateralPostedByCounterparty1() {
			return excessCollateralPostedByCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		public String getCurrencyOfExcessCollateralPosted() {
			return currencyOfExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByCounterparty1")
		@RuneAttribute("excessCollateralCollectedByCounterparty1")
		public BigDecimal getExcessCollateralCollectedByCounterparty1() {
			return excessCollateralCollectedByCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralCollected")
		@RuneAttribute("currencyOfExcessCollateralCollected")
		public String getCurrencyOfExcessCollateralCollected() {
			return currencyOfExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute(value="collateralisationCategory", isRequired=true)
		@RuneAttribute(value="collateralisationCategory", isRequired=true)
		public CollateralisationType3Code getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public ZonedDateTime getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@Override
		public MASMarginReport build() {
			return this;
		}
		
		@Override
		public MASMarginReport.MASMarginReportBuilder toBuilder() {
			MASMarginReport.MASMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(MASMarginReport.MASMarginReportBuilder builder) {
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
			ofNullable(getDataSubmitter()).ifPresent(builder::setDataSubmitter);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getInitialMarginPostedByCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginPostedByCounterparty1PreHaircut);
			ofNullable(getInitialMarginPostedByCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginPostedByCounterparty1PostHaircut);
			ofNullable(getInitialMarginPostedByCounterparty1Currency()).ifPresent(builder::setInitialMarginPostedByCounterparty1Currency);
			ofNullable(getInitialMarginCollectedByCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginCollectedByCounterparty1PreHaircut);
			ofNullable(getInitialMarginCollectedByCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginCollectedByCounterparty1PostHaircut);
			ofNullable(getInitialMarginCollectedByCounterparty1Currency()).ifPresent(builder::setInitialMarginCollectedByCounterparty1Currency);
			ofNullable(getVariationMarginPostedByCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginPostedByCounterparty1PreHaircut);
			ofNullable(getVariationMarginPostedByCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginPostedByCounterparty1PostHaircut);
			ofNullable(getVariationMarginPostedByCounterparty1Currency()).ifPresent(builder::setVariationMarginPostedByCounterparty1Currency);
			ofNullable(getVariationMarginCollectedByCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginCollectedByCounterparty1PreHaircut);
			ofNullable(getVariationMarginCollectedByCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginCollectedByCounterparty1PostHaircut);
			ofNullable(getVariationMarginCollectedByCounterparty1Currency()).ifPresent(builder::setVariationMarginCollectedByCounterparty1Currency);
			ofNullable(getExcessCollateralPostedByCounterparty1()).ifPresent(builder::setExcessCollateralPostedByCounterparty1);
			ofNullable(getCurrencyOfExcessCollateralPosted()).ifPresent(builder::setCurrencyOfExcessCollateralPosted);
			ofNullable(getExcessCollateralCollectedByCounterparty1()).ifPresent(builder::setExcessCollateralCollectedByCounterparty1);
			ofNullable(getCurrencyOfExcessCollateralCollected()).ifPresent(builder::setCurrencyOfExcessCollateralCollected);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1PreHaircut, _that.getInitialMarginPostedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1PostHaircut, _that.getInitialMarginPostedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1Currency, _that.getInitialMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PreHaircut, _that.getInitialMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PostHaircut, _that.getInitialMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1Currency, _that.getInitialMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1PreHaircut, _that.getVariationMarginPostedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1PostHaircut, _that.getVariationMarginPostedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1Currency, _that.getVariationMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1PreHaircut, _that.getVariationMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1PostHaircut, _that.getVariationMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1Currency, _that.getVariationMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(excessCollateralPostedByCounterparty1, _that.getExcessCollateralPostedByCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralPosted, _that.getCurrencyOfExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByCounterparty1, _that.getExcessCollateralCollectedByCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralCollected, _that.getCurrencyOfExcessCollateralCollected())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1PreHaircut != null ? initialMarginPostedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1PostHaircut != null ? initialMarginPostedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1Currency != null ? initialMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PreHaircut != null ? initialMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PostHaircut != null ? initialMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1Currency != null ? initialMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1PreHaircut != null ? variationMarginPostedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1PostHaircut != null ? variationMarginPostedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1Currency != null ? variationMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1PreHaircut != null ? variationMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1PostHaircut != null ? variationMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1Currency != null ? variationMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByCounterparty1 != null ? excessCollateralPostedByCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralPosted != null ? currencyOfExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByCounterparty1 != null ? excessCollateralCollectedByCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralCollected != null ? currencyOfExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASMarginReport {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginPostedByCounterparty1PreHaircut=" + this.initialMarginPostedByCounterparty1PreHaircut + ", " +
				"initialMarginPostedByCounterparty1PostHaircut=" + this.initialMarginPostedByCounterparty1PostHaircut + ", " +
				"initialMarginPostedByCounterparty1Currency=" + this.initialMarginPostedByCounterparty1Currency + ", " +
				"initialMarginCollectedByCounterparty1PreHaircut=" + this.initialMarginCollectedByCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByCounterparty1PostHaircut=" + this.initialMarginCollectedByCounterparty1PostHaircut + ", " +
				"initialMarginCollectedByCounterparty1Currency=" + this.initialMarginCollectedByCounterparty1Currency + ", " +
				"variationMarginPostedByCounterparty1PreHaircut=" + this.variationMarginPostedByCounterparty1PreHaircut + ", " +
				"variationMarginPostedByCounterparty1PostHaircut=" + this.variationMarginPostedByCounterparty1PostHaircut + ", " +
				"variationMarginPostedByCounterparty1Currency=" + this.variationMarginPostedByCounterparty1Currency + ", " +
				"variationMarginCollectedByCounterparty1PreHaircut=" + this.variationMarginCollectedByCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByCounterparty1PostHaircut=" + this.variationMarginCollectedByCounterparty1PostHaircut + ", " +
				"variationMarginCollectedByCounterparty1Currency=" + this.variationMarginCollectedByCounterparty1Currency + ", " +
				"excessCollateralPostedByCounterparty1=" + this.excessCollateralPostedByCounterparty1 + ", " +
				"currencyOfExcessCollateralPosted=" + this.currencyOfExcessCollateralPosted + ", " +
				"excessCollateralCollectedByCounterparty1=" + this.excessCollateralCollectedByCounterparty1 + ", " +
				"currencyOfExcessCollateralCollected=" + this.currencyOfExcessCollateralCollected + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"actionType=" + this.actionType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 +
			'}';
		}
	}

	/*********************** Builder Implementation of MASMarginReport  ***********************/
	class MASMarginReportBuilderImpl implements MASMarginReport.MASMarginReportBuilder {
	
		protected String counterparty1;
		protected String counterparty2;
		protected Boolean counterparty2IdentifierType;
		protected String reportingSpecifiedPerson;
		protected String dataSubmitter;
		protected String uniqueTransactionIdentifier;
		protected String uniqueTransactionIdentifierProprietary;
		protected ZonedDateTime reportingTimestamp;
		protected ZonedDateTime collateralTimestamp;
		protected Boolean collateralPortfolioIndicator;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected BigDecimal initialMarginPostedByCounterparty1PreHaircut;
		protected BigDecimal initialMarginPostedByCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum initialMarginPostedByCounterparty1Currency;
		protected BigDecimal initialMarginCollectedByCounterparty1PreHaircut;
		protected BigDecimal initialMarginCollectedByCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum initialMarginCollectedByCounterparty1Currency;
		protected BigDecimal variationMarginPostedByCounterparty1PreHaircut;
		protected BigDecimal variationMarginPostedByCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum variationMarginPostedByCounterparty1Currency;
		protected BigDecimal variationMarginCollectedByCounterparty1PreHaircut;
		protected BigDecimal variationMarginCollectedByCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum variationMarginCollectedByCounterparty1Currency;
		protected BigDecimal excessCollateralPostedByCounterparty1;
		protected String currencyOfExcessCollateralPosted;
		protected BigDecimal excessCollateralCollectedByCounterparty1;
		protected String currencyOfExcessCollateralCollected;
		protected CollateralisationType3Code collateralisationCategory;
		protected MarginActionEnum actionType;
		protected ZonedDateTime eventDate;
		protected String technicalRecordId;
		protected String executionAgentOfTheCounterparty1;
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByCounterparty1PreHaircut() {
			return initialMarginPostedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByCounterparty1PostHaircut() {
			return initialMarginPostedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginPostedByCounterparty1Currency() {
			return initialMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PreHaircut() {
			return initialMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByCounterparty1PostHaircut() {
			return initialMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getInitialMarginCollectedByCounterparty1Currency() {
			return initialMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByCounterparty1PreHaircut() {
			return variationMarginPostedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByCounterparty1PostHaircut() {
			return variationMarginPostedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginPostedByCounterparty1Currency() {
			return variationMarginPostedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByCounterparty1PreHaircut() {
			return variationMarginCollectedByCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByCounterparty1PostHaircut() {
			return variationMarginCollectedByCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		public ISOCurrencyCodeEnum getVariationMarginCollectedByCounterparty1Currency() {
			return variationMarginCollectedByCounterparty1Currency;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByCounterparty1")
		@RuneAttribute("excessCollateralPostedByCounterparty1")
		public BigDecimal getExcessCollateralPostedByCounterparty1() {
			return excessCollateralPostedByCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		public String getCurrencyOfExcessCollateralPosted() {
			return currencyOfExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByCounterparty1")
		@RuneAttribute("excessCollateralCollectedByCounterparty1")
		public BigDecimal getExcessCollateralCollectedByCounterparty1() {
			return excessCollateralCollectedByCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralCollected")
		@RuneAttribute("currencyOfExcessCollateralCollected")
		public String getCurrencyOfExcessCollateralCollected() {
			return currencyOfExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute(value="collateralisationCategory", isRequired=true)
		@RuneAttribute(value="collateralisationCategory", isRequired=true)
		public CollateralisationType3Code getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public ZonedDateTime getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public MASMarginReport.MASMarginReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
			this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
			return this;
		}
		
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setDataSubmitter(String _dataSubmitter) {
			this.dataSubmitter = _dataSubmitter == null ? null : _dataSubmitter;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public MASMarginReport.MASMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		@Override
		public MASMarginReport.MASMarginReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		@Override
		public MASMarginReport.MASMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
			this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public MASMarginReport.MASMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PreHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1PreHaircut(BigDecimal _initialMarginPostedByCounterparty1PreHaircut) {
			this.initialMarginPostedByCounterparty1PreHaircut = _initialMarginPostedByCounterparty1PreHaircut == null ? null : _initialMarginPostedByCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByCounterparty1PostHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1PostHaircut(BigDecimal _initialMarginPostedByCounterparty1PostHaircut) {
			this.initialMarginPostedByCounterparty1PostHaircut = _initialMarginPostedByCounterparty1PostHaircut == null ? null : _initialMarginPostedByCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByCounterparty1Currency")
		@RuneAttribute("initialMarginPostedByCounterparty1Currency")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
			this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PreHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
			this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByCounterparty1PostHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
			this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByCounterparty1Currency")
		@RuneAttribute("initialMarginCollectedByCounterparty1Currency")
		@Override
		public MASMarginReport.MASMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
			this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PreHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1PreHaircut(BigDecimal _variationMarginPostedByCounterparty1PreHaircut) {
			this.variationMarginPostedByCounterparty1PreHaircut = _variationMarginPostedByCounterparty1PreHaircut == null ? null : _variationMarginPostedByCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByCounterparty1PostHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1PostHaircut(BigDecimal _variationMarginPostedByCounterparty1PostHaircut) {
			this.variationMarginPostedByCounterparty1PostHaircut = _variationMarginPostedByCounterparty1PostHaircut == null ? null : _variationMarginPostedByCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByCounterparty1Currency")
		@RuneAttribute("variationMarginPostedByCounterparty1Currency")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
			this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PreHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByCounterparty1PreHaircut) {
			this.variationMarginCollectedByCounterparty1PreHaircut = _variationMarginCollectedByCounterparty1PreHaircut == null ? null : _variationMarginCollectedByCounterparty1PreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByCounterparty1PostHaircut")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByCounterparty1PostHaircut) {
			this.variationMarginCollectedByCounterparty1PostHaircut = _variationMarginCollectedByCounterparty1PostHaircut == null ? null : _variationMarginCollectedByCounterparty1PostHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByCounterparty1Currency")
		@RuneAttribute("variationMarginCollectedByCounterparty1Currency")
		@Override
		public MASMarginReport.MASMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
			this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
			return this;
		}
		
		@RosettaAttribute("excessCollateralPostedByCounterparty1")
		@RuneAttribute("excessCollateralPostedByCounterparty1")
		@Override
		public MASMarginReport.MASMarginReportBuilder setExcessCollateralPostedByCounterparty1(BigDecimal _excessCollateralPostedByCounterparty1) {
			this.excessCollateralPostedByCounterparty1 = _excessCollateralPostedByCounterparty1 == null ? null : _excessCollateralPostedByCounterparty1;
			return this;
		}
		
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		@Override
		public MASMarginReport.MASMarginReportBuilder setCurrencyOfExcessCollateralPosted(String _currencyOfExcessCollateralPosted) {
			this.currencyOfExcessCollateralPosted = _currencyOfExcessCollateralPosted == null ? null : _currencyOfExcessCollateralPosted;
			return this;
		}
		
		@RosettaAttribute("excessCollateralCollectedByCounterparty1")
		@RuneAttribute("excessCollateralCollectedByCounterparty1")
		@Override
		public MASMarginReport.MASMarginReportBuilder setExcessCollateralCollectedByCounterparty1(BigDecimal _excessCollateralCollectedByCounterparty1) {
			this.excessCollateralCollectedByCounterparty1 = _excessCollateralCollectedByCounterparty1 == null ? null : _excessCollateralCollectedByCounterparty1;
			return this;
		}
		
		@RosettaAttribute("currencyOfExcessCollateralCollected")
		@RuneAttribute("currencyOfExcessCollateralCollected")
		@Override
		public MASMarginReport.MASMarginReportBuilder setCurrencyOfExcessCollateralCollected(String _currencyOfExcessCollateralCollected) {
			this.currencyOfExcessCollateralCollected = _currencyOfExcessCollateralCollected == null ? null : _currencyOfExcessCollateralCollected;
			return this;
		}
		
		@RosettaAttribute(value="collateralisationCategory", isRequired=true)
		@RuneAttribute(value="collateralisationCategory", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setEventDate(ZonedDateTime _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		@Override
		public MASMarginReport.MASMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
		@Override
		public MASMarginReport.MASMarginReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
			this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
			return this;
		}
		
		@Override
		public MASMarginReport build() {
			return new MASMarginReport.MASMarginReportImpl(this);
		}
		
		@Override
		public MASMarginReport.MASMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASMarginReport.MASMarginReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getReportingSpecifiedPerson()!=null) return true;
			if (getDataSubmitter()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUniqueTransactionIdentifierProprietary()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getCollateralTimestamp()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getInitialMarginPostedByCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginPostedByCounterparty1PostHaircut()!=null) return true;
			if (getInitialMarginPostedByCounterparty1Currency()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1PostHaircut()!=null) return true;
			if (getInitialMarginCollectedByCounterparty1Currency()!=null) return true;
			if (getVariationMarginPostedByCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginPostedByCounterparty1PostHaircut()!=null) return true;
			if (getVariationMarginPostedByCounterparty1Currency()!=null) return true;
			if (getVariationMarginCollectedByCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginCollectedByCounterparty1PostHaircut()!=null) return true;
			if (getVariationMarginCollectedByCounterparty1Currency()!=null) return true;
			if (getExcessCollateralPostedByCounterparty1()!=null) return true;
			if (getCurrencyOfExcessCollateralPosted()!=null) return true;
			if (getExcessCollateralCollectedByCounterparty1()!=null) return true;
			if (getCurrencyOfExcessCollateralCollected()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getExecutionAgentOfTheCounterparty1()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASMarginReport.MASMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			MASMarginReport.MASMarginReportBuilder o = (MASMarginReport.MASMarginReportBuilder) other;
			
			
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getReportingSpecifiedPerson(), o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson);
			merger.mergeBasic(getDataSubmitter(), o.getDataSubmitter(), this::setDataSubmitter);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUniqueTransactionIdentifierProprietary(), o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getCollateralTimestamp(), o.getCollateralTimestamp(), this::setCollateralTimestamp);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getInitialMarginPostedByCounterparty1PreHaircut(), o.getInitialMarginPostedByCounterparty1PreHaircut(), this::setInitialMarginPostedByCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginPostedByCounterparty1PostHaircut(), o.getInitialMarginPostedByCounterparty1PostHaircut(), this::setInitialMarginPostedByCounterparty1PostHaircut);
			merger.mergeBasic(getInitialMarginPostedByCounterparty1Currency(), o.getInitialMarginPostedByCounterparty1Currency(), this::setInitialMarginPostedByCounterparty1Currency);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1PreHaircut(), o.getInitialMarginCollectedByCounterparty1PreHaircut(), this::setInitialMarginCollectedByCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1PostHaircut(), o.getInitialMarginCollectedByCounterparty1PostHaircut(), this::setInitialMarginCollectedByCounterparty1PostHaircut);
			merger.mergeBasic(getInitialMarginCollectedByCounterparty1Currency(), o.getInitialMarginCollectedByCounterparty1Currency(), this::setInitialMarginCollectedByCounterparty1Currency);
			merger.mergeBasic(getVariationMarginPostedByCounterparty1PreHaircut(), o.getVariationMarginPostedByCounterparty1PreHaircut(), this::setVariationMarginPostedByCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginPostedByCounterparty1PostHaircut(), o.getVariationMarginPostedByCounterparty1PostHaircut(), this::setVariationMarginPostedByCounterparty1PostHaircut);
			merger.mergeBasic(getVariationMarginPostedByCounterparty1Currency(), o.getVariationMarginPostedByCounterparty1Currency(), this::setVariationMarginPostedByCounterparty1Currency);
			merger.mergeBasic(getVariationMarginCollectedByCounterparty1PreHaircut(), o.getVariationMarginCollectedByCounterparty1PreHaircut(), this::setVariationMarginCollectedByCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginCollectedByCounterparty1PostHaircut(), o.getVariationMarginCollectedByCounterparty1PostHaircut(), this::setVariationMarginCollectedByCounterparty1PostHaircut);
			merger.mergeBasic(getVariationMarginCollectedByCounterparty1Currency(), o.getVariationMarginCollectedByCounterparty1Currency(), this::setVariationMarginCollectedByCounterparty1Currency);
			merger.mergeBasic(getExcessCollateralPostedByCounterparty1(), o.getExcessCollateralPostedByCounterparty1(), this::setExcessCollateralPostedByCounterparty1);
			merger.mergeBasic(getCurrencyOfExcessCollateralPosted(), o.getCurrencyOfExcessCollateralPosted(), this::setCurrencyOfExcessCollateralPosted);
			merger.mergeBasic(getExcessCollateralCollectedByCounterparty1(), o.getExcessCollateralCollectedByCounterparty1(), this::setExcessCollateralCollectedByCounterparty1);
			merger.mergeBasic(getCurrencyOfExcessCollateralCollected(), o.getCurrencyOfExcessCollateralCollected(), this::setCurrencyOfExcessCollateralCollected);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getExecutionAgentOfTheCounterparty1(), o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1PreHaircut, _that.getInitialMarginPostedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1PostHaircut, _that.getInitialMarginPostedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByCounterparty1Currency, _that.getInitialMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PreHaircut, _that.getInitialMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1PostHaircut, _that.getInitialMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByCounterparty1Currency, _that.getInitialMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1PreHaircut, _that.getVariationMarginPostedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1PostHaircut, _that.getVariationMarginPostedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByCounterparty1Currency, _that.getVariationMarginPostedByCounterparty1Currency())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1PreHaircut, _that.getVariationMarginCollectedByCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1PostHaircut, _that.getVariationMarginCollectedByCounterparty1PostHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByCounterparty1Currency, _that.getVariationMarginCollectedByCounterparty1Currency())) return false;
			if (!Objects.equals(excessCollateralPostedByCounterparty1, _that.getExcessCollateralPostedByCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralPosted, _that.getCurrencyOfExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByCounterparty1, _that.getExcessCollateralCollectedByCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralCollected, _that.getCurrencyOfExcessCollateralCollected())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1PreHaircut != null ? initialMarginPostedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1PostHaircut != null ? initialMarginPostedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByCounterparty1Currency != null ? initialMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PreHaircut != null ? initialMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1PostHaircut != null ? initialMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByCounterparty1Currency != null ? initialMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1PreHaircut != null ? variationMarginPostedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1PostHaircut != null ? variationMarginPostedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByCounterparty1Currency != null ? variationMarginPostedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1PreHaircut != null ? variationMarginCollectedByCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1PostHaircut != null ? variationMarginCollectedByCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByCounterparty1Currency != null ? variationMarginCollectedByCounterparty1Currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByCounterparty1 != null ? excessCollateralPostedByCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralPosted != null ? currencyOfExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByCounterparty1 != null ? excessCollateralCollectedByCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralCollected != null ? currencyOfExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASMarginReportBuilder {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginPostedByCounterparty1PreHaircut=" + this.initialMarginPostedByCounterparty1PreHaircut + ", " +
				"initialMarginPostedByCounterparty1PostHaircut=" + this.initialMarginPostedByCounterparty1PostHaircut + ", " +
				"initialMarginPostedByCounterparty1Currency=" + this.initialMarginPostedByCounterparty1Currency + ", " +
				"initialMarginCollectedByCounterparty1PreHaircut=" + this.initialMarginCollectedByCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByCounterparty1PostHaircut=" + this.initialMarginCollectedByCounterparty1PostHaircut + ", " +
				"initialMarginCollectedByCounterparty1Currency=" + this.initialMarginCollectedByCounterparty1Currency + ", " +
				"variationMarginPostedByCounterparty1PreHaircut=" + this.variationMarginPostedByCounterparty1PreHaircut + ", " +
				"variationMarginPostedByCounterparty1PostHaircut=" + this.variationMarginPostedByCounterparty1PostHaircut + ", " +
				"variationMarginPostedByCounterparty1Currency=" + this.variationMarginPostedByCounterparty1Currency + ", " +
				"variationMarginCollectedByCounterparty1PreHaircut=" + this.variationMarginCollectedByCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByCounterparty1PostHaircut=" + this.variationMarginCollectedByCounterparty1PostHaircut + ", " +
				"variationMarginCollectedByCounterparty1Currency=" + this.variationMarginCollectedByCounterparty1Currency + ", " +
				"excessCollateralPostedByCounterparty1=" + this.excessCollateralPostedByCounterparty1 + ", " +
				"currencyOfExcessCollateralPosted=" + this.currencyOfExcessCollateralPosted + ", " +
				"excessCollateralCollectedByCounterparty1=" + this.excessCollateralCollectedByCounterparty1 + ", " +
				"currencyOfExcessCollateralCollected=" + this.currencyOfExcessCollateralCollected + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"actionType=" + this.actionType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 +
			'}';
		}
	}
}
