package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.mas.rewrite.trade.meta.PriceAndNotationMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="PriceAndNotation", builder=PriceAndNotation.PriceAndNotationBuilderImpl.class, version="5.57.0")
@RuneDataType(value="PriceAndNotation", model="drr", builder=PriceAndNotation.PriceAndNotationBuilderImpl.class, version="5.57.0")
public interface PriceAndNotation extends RosettaModelObject {

	PriceAndNotationMeta metaData = new PriceAndNotationMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getPriceMonetary();
	BigDecimal getPriceDecimal();
	ISOCurrencyCodeEnum getPriceCurrency();
	PriceNotationEnum getPriceNotation();

	/*********************** Build Methods  ***********************/
	PriceAndNotation build();
	
	PriceAndNotation.PriceAndNotationBuilder toBuilder();
	
	static PriceAndNotation.PriceAndNotationBuilder builder() {
		return new PriceAndNotation.PriceAndNotationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PriceAndNotation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PriceAndNotation> getType() {
		return PriceAndNotation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
		processor.processBasic(path.newSubPath("priceDecimal"), BigDecimal.class, getPriceDecimal(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PriceAndNotationBuilder extends PriceAndNotation, RosettaModelObjectBuilder {
		PriceAndNotation.PriceAndNotationBuilder setPriceMonetary(BigDecimal priceMonetary);
		PriceAndNotation.PriceAndNotationBuilder setPriceDecimal(BigDecimal priceDecimal);
		PriceAndNotation.PriceAndNotationBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		PriceAndNotation.PriceAndNotationBuilder setPriceNotation(PriceNotationEnum priceNotation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
			processor.processBasic(path.newSubPath("priceDecimal"), BigDecimal.class, getPriceDecimal(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		}
		

		PriceAndNotation.PriceAndNotationBuilder prune();
	}

	/*********************** Immutable Implementation of PriceAndNotation  ***********************/
	class PriceAndNotationImpl implements PriceAndNotation {
		private final BigDecimal priceMonetary;
		private final BigDecimal priceDecimal;
		private final ISOCurrencyCodeEnum priceCurrency;
		private final PriceNotationEnum priceNotation;
		
		protected PriceAndNotationImpl(PriceAndNotation.PriceAndNotationBuilder builder) {
			this.priceMonetary = builder.getPriceMonetary();
			this.priceDecimal = builder.getPriceDecimal();
			this.priceCurrency = builder.getPriceCurrency();
			this.priceNotation = builder.getPriceNotation();
		}
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		public BigDecimal getPriceDecimal() {
			return priceDecimal;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public ISOCurrencyCodeEnum getPriceCurrency() {
			return priceCurrency;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public PriceNotationEnum getPriceNotation() {
			return priceNotation;
		}
		
		@Override
		public PriceAndNotation build() {
			return this;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder toBuilder() {
			PriceAndNotation.PriceAndNotationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PriceAndNotation.PriceAndNotationBuilder builder) {
			ofNullable(getPriceMonetary()).ifPresent(builder::setPriceMonetary);
			ofNullable(getPriceDecimal()).ifPresent(builder::setPriceDecimal);
			ofNullable(getPriceCurrency()).ifPresent(builder::setPriceCurrency);
			ofNullable(getPriceNotation()).ifPresent(builder::setPriceNotation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(priceDecimal, _that.getPriceDecimal())) return false;
			if (!Objects.equals(priceCurrency, _that.getPriceCurrency())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (priceDecimal != null ? priceDecimal.hashCode() : 0);
			_result = 31 * _result + (priceCurrency != null ? priceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceAndNotation {" +
				"priceMonetary=" + this.priceMonetary + ", " +
				"priceDecimal=" + this.priceDecimal + ", " +
				"priceCurrency=" + this.priceCurrency + ", " +
				"priceNotation=" + this.priceNotation +
			'}';
		}
	}

	/*********************** Builder Implementation of PriceAndNotation  ***********************/
	class PriceAndNotationBuilderImpl implements PriceAndNotation.PriceAndNotationBuilder {
	
		protected BigDecimal priceMonetary;
		protected BigDecimal priceDecimal;
		protected ISOCurrencyCodeEnum priceCurrency;
		protected PriceNotationEnum priceNotation;
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		public BigDecimal getPriceDecimal() {
			return priceDecimal;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public ISOCurrencyCodeEnum getPriceCurrency() {
			return priceCurrency;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public PriceNotationEnum getPriceNotation() {
			return priceNotation;
		}
		
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder setPriceMonetary(BigDecimal _priceMonetary) {
			this.priceMonetary = _priceMonetary == null ? null : _priceMonetary;
			return this;
		}
		
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder setPriceDecimal(BigDecimal _priceDecimal) {
			this.priceDecimal = _priceDecimal == null ? null : _priceDecimal;
			return this;
		}
		
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		public PriceAndNotation build() {
			return new PriceAndNotation.PriceAndNotationImpl(this);
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPriceMonetary()!=null) return true;
			if (getPriceDecimal()!=null) return true;
			if (getPriceCurrency()!=null) return true;
			if (getPriceNotation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceAndNotation.PriceAndNotationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PriceAndNotation.PriceAndNotationBuilder o = (PriceAndNotation.PriceAndNotationBuilder) other;
			
			
			merger.mergeBasic(getPriceMonetary(), o.getPriceMonetary(), this::setPriceMonetary);
			merger.mergeBasic(getPriceDecimal(), o.getPriceDecimal(), this::setPriceDecimal);
			merger.mergeBasic(getPriceCurrency(), o.getPriceCurrency(), this::setPriceCurrency);
			merger.mergeBasic(getPriceNotation(), o.getPriceNotation(), this::setPriceNotation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(priceDecimal, _that.getPriceDecimal())) return false;
			if (!Objects.equals(priceCurrency, _that.getPriceCurrency())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (priceDecimal != null ? priceDecimal.hashCode() : 0);
			_result = 31 * _result + (priceCurrency != null ? priceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceAndNotationBuilder {" +
				"priceMonetary=" + this.priceMonetary + ", " +
				"priceDecimal=" + this.priceDecimal + ", " +
				"priceCurrency=" + this.priceCurrency + ", " +
				"priceNotation=" + this.priceNotation +
			'}';
		}
	}
}
