package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;


@ImplementedBy(BasketConstituentIdentifiersRule.BasketConstituentIdentifiersRuleDefault.class)
public abstract class BasketConstituentIdentifiersRule implements ReportFunction<ProductIdentifier, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ProductIdentifier input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ProductIdentifier input);

	public static class BasketConstituentIdentifiersRuleDefault extends BasketConstituentIdentifiersRule {
		@Override
		protected String doEvaluate(ProductIdentifier input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ProductIdentifier input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input)
				.mapSingleToItem(item -> item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
