package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.labels.MASTradeLabelProvider;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.mas.rewrite.trade", body="MAS", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=MASTradeLabelProvider.class)
@ImplementedBy(MASTradeReportFunction.MASTradeReportFunctionDefault.class)
public abstract class MASTradeReportFunction implements ReportFunction<TransactionReportInstruction, MASTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected BookingLocationRule bookingLocationRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmationTimestampRule confirmationTimestampRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected ContractPriceScheduleRule contractPriceScheduleRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2NameDTCCRule counterparty2NameDTCCRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected DataSubmitterRule dataSubmitterRule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected DirectionOfLeg1Rule directionOfLeg1Rule;
	@Inject protected DirectionOfLeg2Rule directionOfLeg2Rule;
	@Inject protected DirectionRule directionRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventDateRule eventDateRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentOfCounterparty1DTCCRule executionAgentOfCounterparty1DTCCRule;
	@Inject protected ExecutionAgentOfCounterparty2DTCCRule executionAgentOfCounterparty2DTCCRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected FixedRateDayCountConventionOfLeg1Rule fixedRateDayCountConventionOfLeg1Rule;
	@Inject protected FixedRateDayCountConventionOfLeg2Rule fixedRateDayCountConventionOfLeg2Rule;
	@Inject protected FixedRateOfLeg1Rule fixedRateOfLeg1Rule;
	@Inject protected FixedRateOfLeg2Rule fixedRateOfLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierOfLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierOfLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierOfLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierOfLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodOfLeg1Rule fixedRatePaymentFrequencyPeriodOfLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodOfLeg2Rule fixedRatePaymentFrequencyPeriodOfLeg2Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg1Rule floatingRateDayCountConventionOfLeg1Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg2Rule floatingRateDayCountConventionOfLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodOfLeg1Rule floatingRatePaymentFrequencyPeriodOfLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodOfLeg2Rule floatingRatePaymentFrequencyPeriodOfLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierOfLeg1Rule floatingRateResetFrequencyPeriodMultiplierOfLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierOfLeg2Rule floatingRateResetFrequencyPeriodMultiplierOfLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodOfLeg1Rule floatingRateResetFrequencyPeriodOfLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodOfLeg2Rule floatingRateResetFrequencyPeriodOfLeg2Rule;
	@Inject protected GetStrikePriceNotationRule getStrikePriceNotationRule;
	@Inject protected IdentifierOfFloatingRateOfLeg1Rule identifierOfFloatingRateOfLeg1Rule;
	@Inject protected IdentifierOfFloatingRateOfLeg2Rule identifierOfFloatingRateOfLeg2Rule;
	@Inject protected InitialMarginCollateralPortfolioCodeDTCCRule initialMarginCollateralPortfolioCodeDTCCRule;
	@Inject protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
	@Inject protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
	@Inject protected NameOfTheUnderlyingIndexDTCCRule nameOfTheUnderlyingIndexDTCCRule;
	@Inject protected NotionalAmountOfLeg2Rule notionalAmountOfLeg2Rule;
	@Inject protected NotionalAmountOfTheContractOrLeg1Rule notionalAmountOfTheContractOrLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg1DTCCRule notionalAmountScheduleLeg1DTCCRule;
	@Inject protected NotionalAmountScheduleLeg2DTCCRule notionalAmountScheduleLeg2DTCCRule;
	@Inject protected NotionalCurrencyOfLeg2Rule notionalCurrencyOfLeg2Rule;
	@Inject protected NotionalCurrencyOfTheContractOrLeg1Rule notionalCurrencyOfTheContractOrLeg1Rule;
	@Inject protected NotionalQuantityOfLeg2Rule notionalQuantityOfLeg2Rule;
	@Inject protected NotionalQuantityOfTheContractOrLeg1Rule notionalQuantityOfTheContractOrLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceFormatDecimalRule priceFormatDecimalRule;
	@Inject protected PriceFormatMonetaryRule priceFormatMonetaryRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUTIProprietaryRule priorUTIProprietaryRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityFrequencyMultiplierOfLeg2Rule quantityFrequencyMultiplierOfLeg2Rule;
	@Inject protected QuantityFrequencyMultiplierOfTheContractOrLeg1Rule quantityFrequencyMultiplierOfTheContractOrLeg1Rule;
	@Inject protected QuantityFrequencyOfLeg2Rule quantityFrequencyOfLeg2Rule;
	@Inject protected QuantityFrequencyOfTheContractOrLeg1Rule quantityFrequencyOfTheContractOrLeg1Rule;
	@Inject protected QuantityUnitOfMeasureForTheContractOrLeg1Rule quantityUnitOfMeasureForTheContractOrLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SettlementCurrency1Rule settlementCurrency1Rule;
	@Inject protected SettlementCurrency2Rule settlementCurrency2Rule;
	@Inject protected SpreadCurrencyOfLeg1Rule spreadCurrencyOfLeg1Rule;
	@Inject protected SpreadCurrencyOfLeg2Rule spreadCurrencyOfLeg2Rule;
	@Inject protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;
	@Inject protected SpreadNotationOfLeg2Rule spreadNotationOfLeg2Rule;
	@Inject protected SpreadOfLeg1BasisRule spreadOfLeg1BasisRule;
	@Inject protected SpreadOfLeg1DecimalRule spreadOfLeg1DecimalRule;
	@Inject protected SpreadOfLeg1MonetaryRule spreadOfLeg1MonetaryRule;
	@Inject protected SpreadOfLeg2BasisRule spreadOfLeg2BasisRule;
	@Inject protected SpreadOfLeg2DecimalRule spreadOfLeg2DecimalRule;
	@Inject protected SpreadOfLeg2MonetaryRule spreadOfLeg2MonetaryRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceDecimalRule strikePriceDecimalRule;
	@Inject protected StrikePriceMonetaryRule strikePriceMonetaryRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SwapLinkIDRule swapLinkIDRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected TotalNotionalQuantityOfLeg2Rule totalNotionalQuantityOfLeg2Rule;
	@Inject protected TotalNotionalQuantityOfTheContractOrLeg1Rule totalNotionalQuantityOfTheContractOrLeg1Rule;
	@Inject protected TraderLocationRule traderLocationRule;
	@Inject protected TradingCapacityOfSpecifiedPersonRule tradingCapacityOfSpecifiedPersonRule;
	@Inject protected UnderlyingIdOtherDTCCRule underlyingIdOtherDTCCRule;
	@Inject protected UnderlyingIdOtherSourceDTCCRule underlyingIdOtherSourceDTCCRule;
	@Inject protected UnderlyingIdentificationTypeDTCCRule underlyingIdentificationTypeDTCCRule;
	@Inject protected UnderlyingRule underlyingRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VariationMarginCollateralPortfolioCodeDTCCRule variationMarginCollateralPortfolioCodeDTCCRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public MASTransactionReport evaluate(TransactionReportInstruction input) {
		MASTransactionReport.MASTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final MASTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(MASTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class MASTradeReportFunctionDefault extends MASTradeReportFunction {
		@Override
		protected MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			MASTransactionReport.MASTransactionReportBuilder output = MASTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected MASTransactionReport.MASTransactionReportBuilder assignOutput(MASTransactionReport.MASTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.setTradingCapacityOfSpecifiedPerson(tradingCapacityOfSpecifiedPersonRule.evaluate(input));
			
			output
				.setDirection(directionRule.evaluate(input));
			
			output
				.setDirectionOfLeg1(directionOfLeg1Rule.evaluate(input));
			
			output
				.setDirectionOfLeg2(directionOfLeg2Rule.evaluate(input));
			
			output
				.setReportingSpecifiedPerson(reportingSpecifiedPersonRule.evaluate(input));
			
			output
				.setDataSubmitter(dataSubmitterRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(uniqueTransactionIdentifierProprietaryRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setPriorUTIProprietary(priorUTIProprietaryRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setUnderlying(underlyingRule.evaluate(input));
			
			output
				.setUnderlyingIdentificationType(underlyingIdentificationTypeDTCCRule.evaluate(input));
			
			output
				.setUnderlyingIdOther(underlyingIdOtherDTCCRule.evaluate(input));
			
			output
				.setUnderlyingIdOtherSource(underlyingIdOtherSourceDTCCRule.evaluate(input));
			
			output
				.setNameOfTheUnderlyingIndex(nameOfTheUnderlyingIndexDTCCRule.evaluate(input));
			
			output
				.setFixedRateOfLeg1(fixedRateOfLeg1Rule.evaluate(input));
			
			output
				.setIdentifierOfFloatingRateOfLeg1(identifierOfFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.setNameOfTheFloatingRateOfLeg1(nameOfTheFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Monetary(spreadOfLeg1MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Decimal(spreadOfLeg1DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Basis(spreadOfLeg1BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadNotationOfLeg1(spreadNotationOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadCurrencyOfLeg1(spreadCurrencyOfLeg1Rule.evaluate(input));
			
			output
				.setFixedRateOfLeg2(fixedRateOfLeg2Rule.evaluate(input));
			
			output
				.setIdentifierOfFloatingRateOfLeg2(identifierOfFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.setNameOfTheFloatingRateOfLeg2(nameOfTheFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Monetary(spreadOfLeg2MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Decimal(spreadOfLeg2DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Basis(spreadOfLeg2BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadNotationOfLeg2(spreadNotationOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadCurrencyOfLeg2(spreadCurrencyOfLeg2Rule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setSwapLinkID(swapLinkIDRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.setSettlementCurrency1(settlementCurrency1Rule.evaluate(input));
			
			output
				.setSettlementCurrency2(settlementCurrency2Rule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setBookingLocation(bookingLocationRule.evaluate(input));
			
			output
				.setTraderLocation(traderLocationRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setConfirmationTimestamp(confirmationTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setNotionalAmountOfTheContractOrLeg1(notionalAmountOfTheContractOrLeg1Rule.evaluate(input));
			
			output
				.setNotionalCurrencyOfTheContractOrLeg1(notionalCurrencyOfTheContractOrLeg1Rule.evaluate(input));
			
			output
				.setNotionalAmountOfLeg2(notionalAmountOfLeg2Rule.evaluate(input));
			
			output
				.setNotionalCurrencyOfLeg2(notionalCurrencyOfLeg2Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityOfTheContractOrLeg1(totalNotionalQuantityOfTheContractOrLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureForTheContractOrLeg1(quantityUnitOfMeasureForTheContractOrLeg1Rule.evaluate(input));
			
			output
				.setNotionalQuantityOfTheContractOrLeg1(notionalQuantityOfTheContractOrLeg1Rule.evaluate(input));
			
			output
				.setQuantityFrequencyOfTheContractOrLeg1(quantityFrequencyOfTheContractOrLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = quantityFrequencyMultiplierOfTheContractOrLeg1Rule.evaluate(input);
			output
				.setQuantityFrequencyMultiplierOfTheContractOrLeg1((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			output
				.setTotalNotionalQuantityLeg2(totalNotionalQuantityOfLeg2Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setNotionalQuantityOfLeg2(notionalQuantityOfLeg2Rule.evaluate(input));
			
			output
				.setQuantityFrequencyOfLeg2(quantityFrequencyOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal1 = quantityFrequencyMultiplierOfLeg2Rule.evaluate(input);
			output
				.setQuantityFrequencyMultiplierOfLeg2((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceMonetary(priceFormatMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceDecimal(priceFormatDecimalRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setPriceSchedule(contractPriceScheduleRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceMonetary(strikePriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceDecimal(strikePriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceNotation(getStrikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionOfLeg1(fixedRateDayCountConventionOfLeg1Rule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionOfLeg2(fixedRateDayCountConventionOfLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionOfLeg1(floatingRateDayCountConventionOfLeg1Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionOfLeg2(floatingRateDayCountConventionOfLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateResetFrequencyPeriodOfLeg1(floatingRateResetFrequencyPeriodOfLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = floatingRateResetFrequencyPeriodMultiplierOfLeg1Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierOfLeg1((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			output
				.setFloatingRateResetFrequencyPeriodOfLeg2(floatingRateResetFrequencyPeriodOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal3 = floatingRateResetFrequencyPeriodMultiplierOfLeg2Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierOfLeg2((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			output
				.setFixedRatePaymentFrequencyPeriodOfLeg1(fixedRatePaymentFrequencyPeriodOfLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal4 = fixedRatePaymentFrequencyPeriodMultiplierOfLeg1Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			output
				.setFixedRatePaymentFrequencyPeriodOfLeg2(fixedRatePaymentFrequencyPeriodOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal5 = fixedRatePaymentFrequencyPeriodMultiplierOfLeg2Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			output
				.setFloatingRatePaymentFrequencyPeriodOfLeg1(floatingRatePaymentFrequencyPeriodOfLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal6 = floatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			output
				.setFloatingRatePaymentFrequencyPeriodOfLeg2(floatingRatePaymentFrequencyPeriodOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal7 = floatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2((bigDecimal7 == null ? null : bigDecimal7.intValueExact()));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventDate(eventDateRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameDTCCRule.evaluate(input));
			
			output
				.setExecutionAgentOfCounterparty1(executionAgentOfCounterparty1DTCCRule.evaluate(input));
			
			output
				.setExecutionAgentOfCounterparty2DTCC(executionAgentOfCounterparty2DTCCRule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg1DTCC(notionalAmountScheduleLeg1DTCCRule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg2DTCC(notionalAmountScheduleLeg2DTCCRule.evaluate(input));
			
			output
				.setNotionalQuantityScheduleLeg1DTCC(notionalQuantityScheduleLeg1Rule.evaluate(input));
			
			output
				.setNotionalQuantityScheduleLeg2DTCC(notionalQuantityScheduleLeg2Rule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
