package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg1EndDateRule.NotionalQuantityScheduleLeg1EndDateRuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1EndDateRule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleEndDateRule cDENotionalQuantityScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class NotionalQuantityScheduleLeg1EndDateRuleDefault extends NotionalQuantityScheduleLeg1EndDateRule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
