package drr.regulation.mas.rewrite.trade.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentAmountRule.OtherPaymentAmountRuleDefault.class)
public abstract class OtherPaymentAmountRule implements ReportFunction<TransferState, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentAmountRule cDEOtherPaymentAmountRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransferState input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransferState input);

	public static class OtherPaymentAmountRuleDefault extends OtherPaymentAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransferState input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(cDEOtherPaymentAmountRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
