package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEPriceScheduleAmountFormatDecimalRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule.PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRuleDefault.class)
public abstract class PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceScheduleAmountFormatDecimalRule cDEPriceScheduleAmountFormatDecimalRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRuleDefault extends PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEPriceScheduleAmountFormatDecimalRule.evaluate(input);
			
			return output;
		}
	}
}
