package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.datetime.Frequency;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityForwardObservablePriceQuantity;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FormatToMax3Number;
import drr.regulation.common.functions.FrequencyPeriodMultiplier;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(QuantityFrequencyMultiplierOfLeg2Rule.QuantityFrequencyMultiplierOfLeg2RuleDefault.class)
public abstract class QuantityFrequencyMultiplierOfLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityForwardObservablePriceQuantity commodityForwardObservablePriceQuantity;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FormatToMax3Number formatToMax3Number;
	@Inject protected FrequencyPeriodMultiplier frequencyPeriodMultiplier;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class QuantityFrequencyMultiplierOfLeg2RuleDefault extends QuantityFrequencyMultiplierOfLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Integer> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isCommoditySwap.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(frequencyPeriodMultiplier.evaluate(quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get()))))));
					}
					final Boolean boolean1 = isCommodityFixedPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(frequencyPeriodMultiplier.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
							.filterItemNullSafe(pq -> notExists(pq.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
							.filterItemNullSafe(q -> exists(q.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).get()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).get()));
					}
					final Boolean boolean2 = isCommodityFloatingPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(frequencyPeriodMultiplier.evaluate(quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityForwardObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()))));
					}
					return MapperS.<Integer>ofNull();
				});
			final Integer integer = thenArg2.get();
			output = MapperS.of(formatToMax3Number.evaluate((integer == null ? null : BigDecimal.valueOf(integer)))).get();
			
			return output;
		}
	}
}
