package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.GetNotationEnum;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDEStrikePriceNotationEnumRule;
import drr.standards.iosco.cde.reports.CDEStrikePriceNotationRule;
import drr.standards.iosco.cde.reports.CDEStrikePriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(StrikePriceDecimalRule.StrikePriceDecimalRuleDefault.class)
public abstract class StrikePriceDecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceNotationEnumRule cDEStrikePriceNotationEnumRule;
	@Inject protected CDEStrikePriceNotationRule cDEStrikePriceNotationRule;
	@Inject protected CDEStrikePriceRule cDEStrikePriceRule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetNotationEnum getNotationEnum;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected MultiplyPrice multiplyPrice;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceDecimalRuleDefault extends StrikePriceDecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(getNotationEnum.evaluate(cDEStrikePriceNotationRule.evaluate(item.get()))), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(getNotationEnum.evaluate(cDEStrikePriceNotationRule.evaluate(item.get()))), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(cDEStrikePriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVarianceSwap.evaluate(productForEvent.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVolatilitySwap.evaluate(productForEvent.evaluate(item.get()))))))).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(cDEStrikePriceRule.evaluate(item.get()), PriceNotationEnum.DECIMAL));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
