package drr.regulation.mas.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class SpreadOfLeg2TypeFormatValidator implements Validator<SpreadOfLeg2> {

	private List<ComparisonResult> getComparisonResults(SpreadOfLeg2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("spreadOfLeg2Monetary", o.getSpreadOfLeg2Monetary(), of(18), of(13), empty(), empty()), 
				checkNumber("spreadOfLeg2Decimal", o.getSpreadOfLeg2Decimal(), of(11), of(10), empty(), empty()), 
				checkNumber("spreadOfLeg2Basis", o.getSpreadOfLeg2Basis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadOfLeg2", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadOfLeg2", path, "", res.getError());
				}
				return success("SpreadOfLeg2", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadOfLeg2", path, "");
			})
			.collect(toList());
	}

}
