package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0081_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0081_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0081_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0081_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and [\"EQUI\", \"COMM\"] any = assetClass then if totalNotionalQuantityOfTheContractOrLeg1 exists and totalNotionalQuantityOfTheContractOrLeg1 <> 9999999999999999999999999 then quantityUnitOfMeasureForTheContractOrLeg1 exists";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0081_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("EQUI"), MapperS.of("COMM")), MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), CardinalityOperator.Any)).getOrDefault(false)) {
					final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
					if (exists(MapperS.of(mASTransactionReport).<BigDecimal>map("getTotalNotionalQuantityOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getTotalNotionalQuantityOfTheContractOrLeg1())).andNullSafe(notEqual(MapperS.of(mASTransactionReport).<BigDecimal>map("getTotalNotionalQuantityOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getTotalNotionalQuantityOfTheContractOrLeg1()), (bigInteger == null ? MapperS.<BigDecimal>ofNull() : MapperS.of(new BigDecimal(bigInteger))), CardinalityOperator.Any)).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<String>map("getQuantityUnitOfMeasureForTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityUnitOfMeasureForTheContractOrLeg1()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0081_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
