package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0118_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0118_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0118_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0118_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and floatingRateResetFrequencyPeriodOfLeg2 exists and [\"YEAR\", \"MNTH\", \"WEEK\", \"DAIL\", \"QURT\", \"EXPI\"] any = floatingRateResetFrequencyPeriodOfLeg2 then floatingRateResetFrequencyPeriodMultiplierOfLeg2 exists and floatingRateResetFrequencyPeriodMultiplierOfLeg2 > 0 else if floatingRateResetFrequencyPeriodOfLeg2 = \"ADHO\" then floatingRateResetFrequencyPeriodMultiplierOfLeg2 is absent";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0118_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(exists(MapperS.of(mASTransactionReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()))).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("YEAR"), MapperS.of("MNTH"), MapperS.of("WEEK"), MapperS.of("DAIL"), MapperS.of("QURT"), MapperS.of("EXPI")), MapperS.of(mASTransactionReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()), CardinalityOperator.Any)).getOrDefault(false)) {
					return exists(MapperS.of(mASTransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2())).andNullSafe(greaterThan(MapperS.of(mASTransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()), MapperS.of(0), CardinalityOperator.All));
				}
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()), MapperS.of("ADHO"), CardinalityOperator.All).getOrDefault(false)) {
					return notExists(MapperS.of(mASTransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0118_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
