package drr.regulation.mas.rewrite.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.valuation.MASValuationReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("MASValuationReportDTCC_MAS_BR_0002a_01")
@ImplementedBy(MASValuationReportDTCC_MAS_BR_0002a_01.Default.class)
public interface MASValuationReportDTCC_MAS_BR_0002a_01 extends Validator<MASValuationReport> {
	
	String NAME = "MASValuationReportDTCC_MAS_BR_0002a_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string, ActionTypeEnum -> PRTO to-string, ActionTypeEnum -> VALU to-string ] any = actionType then if executionAgentOfTheCounterparty1 = \"NOAP\" then executionAgentOfTheCounterparty2 exists";
	
	class Default implements MASValuationReportDTCC_MAS_BR_0002a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASValuationReport mASValuationReport) {
			ComparisonResult result = executeDataRule(mASValuationReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASValuationReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASValuationReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASValuationReport mASValuationReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASValuationReport).<String>map("getActionType", _mASValuationReport -> _mASValuationReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(mASValuationReport).<String>map("getExecutionAgentOfTheCounterparty1", _mASValuationReport -> _mASValuationReport.getExecutionAgentOfTheCounterparty1()), MapperS.of("NOAP"), CardinalityOperator.All).getOrDefault(false)) {
						return exists(MapperS.of(mASValuationReport).<String>map("getExecutionAgentOfTheCounterparty2", _mASValuationReport -> _mASValuationReport.getExecutionAgentOfTheCounterparty2()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASValuationReportDTCC_MAS_BR_0002a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASValuationReport mASValuationReport) {
			return Collections.emptyList();
		}
	}
}
