package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.Trader;
import javax.inject.Inject;


@ImplementedBy(TraderLocationRule.TraderLocationRuleDefault.class)
public abstract class TraderLocationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected TraderAddressForUTIRule traderAddressForUTIRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class TraderLocationRuleDefault extends TraderLocationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Trader> thenArg = MapperS.of(traderAddressForUTIRule.evaluate(input));
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> item.<Address>map("getCurrentLocation", trader -> trader.getCurrentLocation()).<FieldWithMetaString>map("getCountry", address -> address.getCountry())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
