package drr.standards.iosco.cde.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyLei;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.reports.CDECounterparty1Rule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEDirection2.CDEDirection2Default.class)
public abstract class CDEDirection2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECounterparty1Rule cDECounterparty1Rule;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected PartyLei partyLei;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param event 
	* @param payerReceiver 
	* @return direction 
	*/
	public String evaluate(TransactionReportInstruction event, PayerReceiver payerReceiver) {
		String direction = doEvaluate(event, payerReceiver);
		
		return direction;
	}

	protected abstract String doEvaluate(TransactionReportInstruction event, PayerReceiver payerReceiver);

	protected abstract MapperS<String> reportingParty(TransactionReportInstruction event, PayerReceiver payerReceiver);

	protected abstract MapperC<? extends Counterparty> counterparties(TransactionReportInstruction event, PayerReceiver payerReceiver);

	protected abstract MapperS<? extends Counterparty> payerParty(TransactionReportInstruction event, PayerReceiver payerReceiver);

	protected abstract MapperS<? extends Counterparty> receiverParty(TransactionReportInstruction event, PayerReceiver payerReceiver);

	public static class CDEDirection2Default extends CDEDirection2 {
		@Override
		protected String doEvaluate(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			String direction = null;
			return assignOutput(direction, event, payerReceiver);
		}
		
		protected String assignOutput(String direction, TransactionReportInstruction event, PayerReceiver payerReceiver) {
			if (areEqual(reportingParty(event, payerReceiver), MapperS.of(partyLei.evaluate(payerParty(event, payerReceiver).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti())), CardinalityOperator.All).getOrDefault(false)) {
				direction = "MAKE";
			} else if (areEqual(reportingParty(event, payerReceiver), MapperS.of(partyLei.evaluate(receiverParty(event, payerReceiver).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti())), CardinalityOperator.All).getOrDefault(false)) {
				direction = "TAKE";
			} else {
				direction = null;
			}
			
			return direction;
		}
		
		@Override
		protected MapperS<String> reportingParty(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			return MapperS.of(cDECounterparty1Rule.evaluate(event));
		}
		
		@Override
		protected MapperC<? extends Counterparty> counterparties(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			return MapperS.of(tradeForEvent.evaluate(event)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty());
		}
		
		@Override
		protected MapperS<? extends Counterparty> payerParty(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			return MapperS.of(extractCounterpartyByRole.evaluate(counterparties(event, payerReceiver).getMulti(), MapperS.of(payerReceiver).<CounterpartyRoleEnum>map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get()));
		}
		
		@Override
		protected MapperS<? extends Counterparty> receiverParty(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			return MapperS.of(extractCounterpartyByRole.evaluate(counterparties(event, payerReceiver).getMulti(), MapperS.of(payerReceiver).<CounterpartyRoleEnum>map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get()));
		}
	}
}
