package drr.standards.iosco.cde.functions;

import cdm.base.datetime.PeriodExtendedEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(MapCDEFrequencyPeriod.MapCDEFrequencyPeriodDefault.class)
public abstract class MapCDEFrequencyPeriod implements RosettaFunction {

	/**
	* @param period 
	* @return periodValue 
	*/
	public String evaluate(PeriodExtendedEnum period) {
		String periodValue = doEvaluate(period);
		
		return periodValue;
	}

	protected abstract String doEvaluate(PeriodExtendedEnum period);

	public static class MapCDEFrequencyPeriodDefault extends MapCDEFrequencyPeriod {
		@Override
		protected String doEvaluate(PeriodExtendedEnum period) {
			String periodValue = null;
			return assignOutput(periodValue, period);
		}
		
		protected String assignOutput(String periodValue, PeriodExtendedEnum period) {
			if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.D), CardinalityOperator.All).getOrDefault(false)) {
				periodValue = "DAIL";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.W), CardinalityOperator.All).getOrDefault(false)) {
				periodValue = "WEEK";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.M), CardinalityOperator.All).getOrDefault(false)) {
				periodValue = "MNTH";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.Y), CardinalityOperator.All).getOrDefault(false)) {
				periodValue = "YEAR";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.T), CardinalityOperator.All).getOrDefault(false)) {
				periodValue = "EXPI";
			} else {
				periodValue = null;
			}
			
			return periodValue;
		}
	}
}
