package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetActionType;
import drr.regulation.common.functions.IsActionTypePRTO;
import javax.inject.Inject;


@ImplementedBy(CDEActionTypeRule.CDEActionTypeRuleDefault.class)
public abstract class CDEActionTypeRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetActionType getActionType;
	@Inject protected IsActionTypePRTO isActionTypePRTO;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDEActionTypeRuleDefault extends CDEActionTypeRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean _boolean = isActionTypePRTO.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString);
					}
					return MapperS.of(getActionType.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
