package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.Tranche;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDECDSIndexDetachmentPointRule.CDECDSIndexDetachmentPointRuleDefault.class)
public abstract class CDECDSIndexDetachmentPointRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class CDECDSIndexDetachmentPointRuleDefault extends CDECDSIndexDetachmentPointRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<GeneralTerms> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()));
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					if (exists(item.<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<Tranche>map("getTranche", creditIndexReferenceInformation -> creditIndexReferenceInformation.getTranche())).getOrDefault(false)) {
						return item.<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<Tranche>map("getTranche", creditIndexReferenceInformation -> creditIndexReferenceInformation.getTranche()).<BigDecimal>map("getExhaustionPoint", tranche -> tranche.getExhaustionPoint());
					}
					if (exists(item.<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<Tranche>map("getTranche", basketReferenceInformation -> basketReferenceInformation.getTranche())).getOrDefault(false)) {
						return item.<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<Tranche>map("getTranche", basketReferenceInformation -> basketReferenceInformation.getTranche()).<BigDecimal>map("getExhaustionPoint", tranche -> tranche.getExhaustionPoint());
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
