/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JavaPrimitiveType
implements JavaType {
    private static Map<Class<?>, JavaPrimitiveType> typeMap = new HashMap();
    private static Map<JavaClass<?>, JavaPrimitiveType> wrapperTypeMap = new HashMap();
    public static JavaPrimitiveType INT = JavaPrimitiveType.create(Integer.TYPE, Integer.class, 2);
    public static JavaPrimitiveType BYTE = JavaPrimitiveType.create(Byte.TYPE, Byte.class, 0);
    public static JavaPrimitiveType SHORT = JavaPrimitiveType.create(Short.TYPE, Short.class, 1);
    public static JavaPrimitiveType LONG = JavaPrimitiveType.create(Long.TYPE, Long.class, 3);
    public static JavaPrimitiveType FLOAT = JavaPrimitiveType.create(Float.TYPE, Float.class, 4);
    public static JavaPrimitiveType DOUBLE = JavaPrimitiveType.create(Double.TYPE, Double.class, 5);
    public static JavaPrimitiveType BOOLEAN = JavaPrimitiveType.create(Boolean.TYPE, Boolean.class, -1);
    public static JavaPrimitiveType CHAR = JavaPrimitiveType.create(Character.TYPE, Character.class, -1);
    public static JavaPrimitiveType VOID = JavaPrimitiveType.create(Void.TYPE, Void.class, -1);
    private final Class<?> type;
    private final Class<?> wrapperType;
    private final int numericHierarchy;

    private JavaPrimitiveType(Class<?> type, Class<?> wrapperType, int numericHierarchy) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(wrapperType);
        this.type = type;
        this.wrapperType = wrapperType;
        this.numericHierarchy = numericHierarchy;
    }

    private static JavaPrimitiveType create(Class<?> type, Class<?> wrapperType, int numericHierarchy) {
        JavaPrimitiveType t = new JavaPrimitiveType(type, wrapperType, numericHierarchy);
        typeMap.put(type, t);
        wrapperTypeMap.put(JavaClass.from(wrapperType), t);
        return t;
    }

    public static JavaPrimitiveType from(Class<?> type) {
        return typeMap.get(type);
    }

    public static JavaPrimitiveType fromWrapper(Class<?> wrapperType) {
        return JavaPrimitiveType.fromWrapper(JavaClass.from(wrapperType));
    }

    public static JavaPrimitiveType fromWrapper(JavaClass<?> wrapperType) {
        return wrapperTypeMap.get(wrapperType);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getWrapperType() {
        return this.wrapperType;
    }

    @Override
    public JavaClass<?> toReferenceType() {
        return JavaClass.from(this.wrapperType);
    }

    @Override
    public String getSimpleName() {
        return this.type.getSimpleName();
    }

    public String toString() {
        return this.type.getSimpleName();
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaPrimitiveType other = (JavaPrimitiveType)object;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public void accept(JavaTypeVisitor visitor) {
        visitor.visitType(this);
    }

    @Override
    public boolean isSubtypeOf(JavaType other) {
        if (this.equals(other)) {
            return true;
        }
        if (other instanceof JavaPrimitiveType) {
            JavaPrimitiveType otherPrim = (JavaPrimitiveType)other;
            if (this.equals(CHAR)) {
                return JavaPrimitiveType.INT.numericHierarchy <= otherPrim.numericHierarchy;
            }
            if (this.numericHierarchy >= 0 && otherPrim.numericHierarchy >= 0) {
                return this.numericHierarchy <= otherPrim.numericHierarchy;
            }
        }
        return false;
    }
}

