/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class MultiCurrencyAmount
implements FxConvertible<CurrencyAmount>,
ImmutableBean,
Serializable {
    private static final MultiCurrencyAmount EMPTY = new MultiCurrencyAmount((ImmutableSortedSet<CurrencyAmount>)ImmutableSortedSet.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableSortedSet<CurrencyAmount> amounts;
    private static final long serialVersionUID = 1L;

    public static MultiCurrencyAmount empty() {
        return EMPTY;
    }

    public static MultiCurrencyAmount of(Currency currency, double amount) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return new MultiCurrencyAmount((ImmutableSortedSet<CurrencyAmount>)ImmutableSortedSet.of((Comparable)CurrencyAmount.of(currency, amount)));
    }

    public static MultiCurrencyAmount of(CurrencyAmount ... amounts) {
        ArgChecker.notNull((Object)amounts, (String)"amounts");
        if (amounts.length == 0) {
            return EMPTY;
        }
        return MultiCurrencyAmount.of(Arrays.asList(amounts));
    }

    public static MultiCurrencyAmount of(Iterable<CurrencyAmount> amounts) {
        ArgChecker.noNulls(amounts, (String)"amounts");
        HashMap<Currency, CurrencyAmount> map = new HashMap<Currency, CurrencyAmount>();
        for (CurrencyAmount amount : amounts) {
            if (map.put(amount.getCurrency(), amount) == null) continue;
            throw new IllegalArgumentException("Currency is duplicated: " + amount.getCurrency());
        }
        return new MultiCurrencyAmount((ImmutableSortedSet<CurrencyAmount>)ImmutableSortedSet.copyOf(map.values()));
    }

    public static MultiCurrencyAmount of(Map<Currency, Double> map) {
        ArgChecker.noNulls(map, (String)"map");
        return MapStream.of(map).map(CurrencyAmount::of).collect(MultiCurrencyAmount.collectorInternal());
    }

    public static MultiCurrencyAmount total(Iterable<CurrencyAmount> amounts) {
        ArgChecker.notNull(amounts, (String)"amounts");
        return Guavate.stream(amounts).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    public static Collector<CurrencyAmount, ?, MultiCurrencyAmount> toMultiCurrencyAmount() {
        return Collector.of(HashMap::new, (A map, T ca) -> map.merge(((CurrencyAmount)ArgChecker.notNull((Object)ca, (String)"amount")).getCurrency(), ca, CurrencyAmount::plus), (map1, map2) -> {
            map2.values().forEach(ca2 -> map1.merge(ca2.getCurrency(), ca2, CurrencyAmount::plus));
            return map1;
        }, (A map) -> new MultiCurrencyAmount((ImmutableSortedSet<CurrencyAmount>)ImmutableSortedSet.copyOf(map.values())), Collector.Characteristics.UNORDERED);
    }

    private static Collector<CurrencyAmount, ?, MultiCurrencyAmount> collectorInternal() {
        return Collectors.collectingAndThen(Guavate.toImmutableSortedSet(), MultiCurrencyAmount::new);
    }

    private MultiCurrencyAmount(ImmutableSortedSet<CurrencyAmount> amounts) {
        this.amounts = amounts;
    }

    private void validate() {
        long currencyCount = this.amounts.stream().map(ArgChecker::notNullItem).map(CurrencyAmount::getCurrency).distinct().count();
        if (currencyCount < (long)this.amounts.size()) {
            throw new IllegalArgumentException("Duplicate currency not allowed: " + this.amounts);
        }
    }

    public ImmutableSet<Currency> getCurrencies() {
        return (ImmutableSet)this.amounts.stream().map(CurrencyAmount::getCurrency).collect(Guavate.toImmutableSet());
    }

    public int size() {
        return this.amounts.size();
    }

    public boolean contains(Currency currency) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return this.amounts.stream().anyMatch(ca -> ca.getCurrency().equals(currency));
    }

    public CurrencyAmount getAmount(Currency currency) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return this.amounts.stream().filter(ca -> ca.getCurrency().equals(currency)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown currency " + currency));
    }

    public CurrencyAmount getAmountOrZero(Currency currency) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        return this.amounts.stream().filter(ca -> ca.getCurrency().equals(currency)).findFirst().orElseGet(() -> CurrencyAmount.zero(currency));
    }

    public MultiCurrencyAmount plus(Currency currency, double amountToAdd) {
        return this.plus(CurrencyAmount.of(currency, amountToAdd));
    }

    public MultiCurrencyAmount plus(CurrencyAmount amountToAdd) {
        ArgChecker.notNull((Object)amountToAdd, (String)"amountToAdd");
        return Stream.concat(this.amounts.stream(), Stream.of(amountToAdd)).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    public MultiCurrencyAmount plus(MultiCurrencyAmount amountToAdd) {
        ArgChecker.notNull((Object)amountToAdd, (String)"amountToAdd");
        return Stream.concat(this.amounts.stream(), amountToAdd.stream()).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    public MultiCurrencyAmount minus(Currency currency, double amountToAdd) {
        return this.plus(CurrencyAmount.of(currency, -amountToAdd));
    }

    public MultiCurrencyAmount minus(CurrencyAmount amountToSubtract) {
        ArgChecker.notNull((Object)amountToSubtract, (String)"amountToSubtract");
        return this.plus(amountToSubtract.negated());
    }

    public MultiCurrencyAmount minus(MultiCurrencyAmount amountToSubtract) {
        ArgChecker.notNull((Object)amountToSubtract, (String)"amountToSubtract");
        return this.plus(amountToSubtract.negated());
    }

    public MultiCurrencyAmount multipliedBy(double factor) {
        return this.mapAmounts(a -> a * factor);
    }

    public MultiCurrencyAmount negated() {
        return this.mapAmounts(a -> a == 0.0 ? 0.0 : -a);
    }

    public Stream<CurrencyAmount> stream() {
        return this.amounts.stream();
    }

    public MultiCurrencyAmount mapAmounts(DoubleUnaryOperator mapper) {
        ArgChecker.notNull((Object)mapper, (String)"mapper");
        return this.amounts.stream().map(ca -> ca.mapAmount(mapper)).collect(MultiCurrencyAmount.collectorInternal());
    }

    public MultiCurrencyAmount mapCurrencyAmounts(UnaryOperator<CurrencyAmount> operator) {
        ArgChecker.notNull(operator, (String)"operator");
        return this.amounts.stream().map(ca -> (CurrencyAmount)operator.apply((CurrencyAmount)ca)).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    @Override
    public CurrencyAmount convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.amounts.size() == 1) {
            return ((CurrencyAmount)this.amounts.first()).convertedTo(resultCurrency, rateProvider);
        }
        double total = 0.0;
        for (CurrencyAmount amount : this.amounts) {
            total += rateProvider.convert(amount.getAmount(), amount.getCurrency(), resultCurrency);
        }
        return CurrencyAmount.of(resultCurrency, total);
    }

    public ImmutableSortedMap<Currency, Double> toMap() {
        return (ImmutableSortedMap)this.amounts.stream().collect(Guavate.toImmutableSortedMap(CurrencyAmount::getCurrency, CurrencyAmount::getAmount));
    }

    public String toString() {
        return this.amounts.toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private MultiCurrencyAmount(SortedSet<CurrencyAmount> amounts) {
        JodaBeanUtils.notNull(amounts, (String)"amounts");
        this.amounts = ImmutableSortedSet.copyOfSorted(amounts);
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableSortedSet<CurrencyAmount> getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MultiCurrencyAmount other = (MultiCurrencyAmount)obj;
            return JodaBeanUtils.equal(this.amounts, other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.amounts);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MultiCurrencyAmount> {
        private SortedSet<CurrencyAmount> amounts = ImmutableSortedSet.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    this.amounts = (SortedSet)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MultiCurrencyAmount build() {
            return new MultiCurrencyAmount(this.amounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("MultiCurrencyAmount.Builder{");
            buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableSortedSet<CurrencyAmount>> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", MultiCurrencyAmount.class, ImmutableSortedSet.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MultiCurrencyAmount> builder() {
            return new Builder();
        }

        public Class<? extends MultiCurrencyAmount> beanType() {
            return MultiCurrencyAmount.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableSortedSet<CurrencyAmount>> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return ((MultiCurrencyAmount)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

