/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.FloatingRateType;
import com.opengamma.strata.basics.index.ImmutableFloatingRateName;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.named.NamedLookup;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

final class FloatingRateNameIniLookup
implements NamedLookup<FloatingRateName> {
    private static final Logger log = Logger.getLogger(FloatingRateNameIniLookup.class.getName());
    public static final FloatingRateNameIniLookup INSTANCE = new FloatingRateNameIniLookup();
    private static final String FLOATING_RATE_NAME_INI = "FloatingRateNameData.ini";

    private FloatingRateNameIniLookup() {
    }

    public Map<String, FloatingRateName> lookupAll() {
        return Loader.INSTANCE.names;
    }

    FloatingRateName defaultIborIndex(Currency currency) {
        FloatingRateName frname = (FloatingRateName)Loader.INSTANCE.iborDefaults.get((Object)currency);
        if (frname == null) {
            throw new IllegalArgumentException("No default Ibor index for currency " + currency);
        }
        return frname;
    }

    FloatingRateName defaultOvernightIndex(Currency currency) {
        FloatingRateName frname = (FloatingRateName)Loader.INSTANCE.overnightDefaults.get((Object)currency);
        if (frname == null) {
            throw new IllegalArgumentException("No default Overnight index for currency " + currency);
        }
        return frname;
    }

    static class Loader {
        private static final Loader INSTANCE = new Loader();
        private final ImmutableMap<String, FloatingRateName> names;
        private final ImmutableMap<Currency, FloatingRateName> iborDefaults;
        private final ImmutableMap<Currency, FloatingRateName> overnightDefaults;

        Loader() {
            ImmutableMap<String, FloatingRateName> names = ImmutableMap.of();
            ImmutableMap<Currency, FloatingRateName> iborDefaults = ImmutableMap.of();
            ImmutableMap<Currency, FloatingRateName> overnightDefaults = ImmutableMap.of();
            try {
                IniFile ini = ResourceConfig.combinedIniFile((String)FloatingRateNameIniLookup.FLOATING_RATE_NAME_INI);
                names = Loader.parseIndices(ini);
                iborDefaults = Loader.parseIborDefaults(ini, names);
                overnightDefaults = Loader.parseOvernightDefaults(ini, names);
            }
            catch (RuntimeException ex) {
                log.severe(Throwables.getStackTraceAsString((Throwable)ex));
            }
            this.names = names;
            this.iborDefaults = iborDefaults;
            this.overnightDefaults = overnightDefaults;
        }

        private static ImmutableMap<String, FloatingRateName> parseIndices(IniFile ini) {
            HashMap<String, ImmutableFloatingRateName> map = new HashMap<String, ImmutableFloatingRateName>();
            Loader.parseSection(ini.section("ibor"), "-", FloatingRateType.IBOR, map);
            Loader.parseFixingDateOffset(ini.section("iborFixingDateOffset"), map);
            Loader.parseSection(ini.section("overnightCompounded"), "", FloatingRateType.OVERNIGHT_COMPOUNDED, map);
            Loader.parseSection(ini.section("overnightAveraged"), "", FloatingRateType.OVERNIGHT_AVERAGED, map);
            Loader.parseSection(ini.section("price"), "", FloatingRateType.PRICE, map);
            return ImmutableMap.copyOf(map);
        }

        private static void parseSection(PropertySet section, String indexNameSuffix, FloatingRateType type, HashMap<String, ImmutableFloatingRateName> mutableMap) {
            for (String key : section.keys()) {
                ImmutableFloatingRateName name = ImmutableFloatingRateName.of(key, section.value(key) + indexNameSuffix, type);
                mutableMap.put(key, name);
                mutableMap.putIfAbsent(key.toUpperCase(Locale.ENGLISH), name);
            }
        }

        private static void parseFixingDateOffset(PropertySet section, HashMap<String, ImmutableFloatingRateName> mutableMap) {
            for (String key : section.keys()) {
                Integer days = Integer.parseInt(section.value(key));
                ImmutableFloatingRateName name = mutableMap.get(key.toUpperCase(Locale.ENGLISH));
                ImmutableFloatingRateName updated = name.toBuilder().fixingDateOffsetDays(days).build();
                mutableMap.put(key.toUpperCase(Locale.ENGLISH), updated);
            }
        }

        private static ImmutableMap<Currency, FloatingRateName> parseIborDefaults(IniFile ini, ImmutableMap<String, FloatingRateName> names) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            PropertySet section = ini.section("currencyDefaultIbor");
            for (String key : section.keys()) {
                FloatingRateName frname = (FloatingRateName)names.get((Object)section.value(key));
                if (frname == null) {
                    throw new IllegalArgumentException("Invalid default Ibor index for currency " + key);
                }
                map.put((Object)Currency.of(key), (Object)frname);
            }
            return map.build();
        }

        private static ImmutableMap<Currency, FloatingRateName> parseOvernightDefaults(IniFile ini, ImmutableMap<String, FloatingRateName> names) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            PropertySet section = ini.section("currencyDefaultOvernight");
            for (String key : section.keys()) {
                FloatingRateName frname = (FloatingRateName)names.get((Object)section.value(key));
                if (frname == null) {
                    throw new IllegalArgumentException("Invalid default Overnight index for currency " + key);
                }
                map.put((Object)Currency.of(key), (Object)frname);
            }
            return map.build();
        }
    }
}

