/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.lei.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.lei.LeiData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LeiDataCardinalityVerification")
@ImplementedBy(value=Default.class)
public interface LeiDataCardinalityVerification
extends Validator<LeiData> {
    public static final String NAME = "LeiDataCardinalityVerification";
    public static final String DEFINITION = "if leiValidation is absent or leiValidation = True then lei exists and entityCategory exists and entityStatus exists and registrationStatus exists and registrationDate exists and published exists";

    public static class NoOp
    implements LeiDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LeiData leiData) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LeiDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LeiData leiData) {
            ComparisonResult result = this.executeDataRule(leiData);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LeiDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LeiData", (RosettaPath)path, (String)LeiDataCardinalityVerification.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LeiDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LeiData", (RosettaPath)path, (String)LeiDataCardinalityVerification.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LeiData leiData) {
            try {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)leiData).map("getLeiValidation", _leiData -> _leiData.getLeiValidation())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)leiData).map("getLeiValidation", _leiData -> _leiData.getLeiValidation()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getLei", _leiData -> _leiData.getLei())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getEntityCategory", _leiData -> _leiData.getEntityCategory()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getEntityStatus", _leiData -> _leiData.getEntityStatus()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getRegistrationStatus", _leiData -> _leiData.getRegistrationStatus()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getRegistrationDate", _leiData -> _leiData.getRegistrationDate()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)leiData).map("getPublished", _leiData -> _leiData.getPublished())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

