/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.upi.functions;

import cdm.base.staticdata.asset.common.DebtSeniorityEnum;
import cdm.product.asset.ReferenceInformation;
import cdm.product.template.EconomicTerms;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iso.upi.AnnaDsbDebtSeniorityEnum;
import drr.standards.iso.upi.AnnaDsbUseCaseEnum;
import javax.inject.Inject;

@ImplementedBy(value=DebtSeniorityDefault.class)
public abstract class DebtSeniority
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public AnnaDsbDebtSeniorityEnum evaluate(Product product, AnnaDsbUseCaseEnum useCase) {
        AnnaDsbDebtSeniorityEnum result = this.doEvaluate(product, useCase);
        return result;
    }

    protected abstract AnnaDsbDebtSeniorityEnum doEvaluate(Product var1, AnnaDsbUseCaseEnum var2);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Product var1, AnnaDsbUseCaseEnum var2);

    protected abstract MapperS<? extends ReferenceInformation> referenceInformation(Product var1, AnnaDsbUseCaseEnum var2);

    protected abstract MapperC<DebtSeniorityEnum> debtSeniority(Product var1, AnnaDsbUseCaseEnum var2);

    public static class DebtSeniorityDefault
    extends DebtSeniority {
        @Override
        protected AnnaDsbDebtSeniorityEnum doEvaluate(Product product, AnnaDsbUseCaseEnum useCase) {
            AnnaDsbDebtSeniorityEnum result = null;
            return this.assignOutput(result, product, useCase);
        }

        protected AnnaDsbDebtSeniorityEnum assignOutput(AnnaDsbDebtSeniorityEnum result, Product product, AnnaDsbUseCaseEnum useCase) {
            result = ExpressionOperatorsNullSafe.areEqual(this.debtSeniority(product, useCase), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SENIOR), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDebtSeniorityEnum.SNDB : (ExpressionOperatorsNullSafe.areEqual(this.debtSeniority(product, useCase), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SUBORDINATED), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDebtSeniorityEnum.SBOD : (ExpressionOperatorsNullSafe.areEqual(this.debtSeniority(product, useCase), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SECURED), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDebtSeniorityEnum.MZZD : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)useCase)), (Mapper)MapperS.of((Object)((Object)AnnaDsbUseCaseEnum.NON_STANDARD)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)useCase)), (Mapper)MapperS.of((Object)((Object)AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDebtSeniorityEnum.SNDB : AnnaDsbDebtSeniorityEnum.SNDB)));
            return result;
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Product product, AnnaDsbUseCaseEnum useCase) {
            return MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
        }

        @Override
        protected MapperS<? extends ReferenceInformation> referenceInformation(Product product, AnnaDsbUseCaseEnum useCase) {
            Boolean boolean0 = this.isCreditDefaultSwap.evaluate(product);
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
            }
            Boolean boolean1 = this.isCreditSwaption.evaluate(product);
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperC<DebtSeniorityEnum> debtSeniority(Product product, AnnaDsbUseCaseEnum useCase) {
            if (ExpressionOperatorsNullSafe.exists(this.referenceInformation(product, useCase)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.referenceInformation(product, useCase).mapC("getReferenceObligation", _referenceInformation -> _referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getDebtType", security -> security.getDebtType()).mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
            }
            Boolean _boolean = this.isTotalReturnSwapDebtUnderlier.evaluate(product);
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).map("getDebtType", security -> security.getDebtType()).mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
            }
            return MapperC.ofNull();
        }
    }
}

