/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__2;
import iso20022.auth030.asic.NotionalAmount5__1;
import iso20022.auth030.asic.NotionalAmount6__1;
import iso20022.auth030.asic.NotionalAmountLegs5__1;
import iso20022.auth030.asic.Schedule11__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNtnlAmtDefault.class)
public abstract class GetNtnlAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public NotionalAmountLegs5__1 evaluate(ASICTransactionReport drrReport) {
        NotionalAmountLegs5__1 ntnlAmt;
        NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmtBuilder = this.doEvaluate(drrReport);
        if (ntnlAmtBuilder == null) {
            ntnlAmt = null;
        } else {
            ntnlAmt = ntnlAmtBuilder.build();
            this.objectValidator.validate(NotionalAmountLegs5__1.class, (RosettaModelObject)ntnlAmt);
        }
        return ntnlAmt;
    }

    protected abstract NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(ASICTransactionReport var1);

    public static class GetNtnlAmtDefault
    extends GetNtnlAmt {
        @Override
        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(ASICTransactionReport drrReport) {
            NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt = NotionalAmountLegs5__1.builder();
            return this.assignOutput(ntnlAmt, drrReport);
        }

        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder assignOutput(NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt, ASICTransactionReport drrReport) {
            Boolean ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getNotionalLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg1()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = false;
            }
            Boolean ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getNotionalLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg2()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = false;
            }
            ntnlAmt = (NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder)this.toBuilder((RosettaModelObject)NotionalAmountLegs5__1.builder().setFrstLeg(NotionalAmount5__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getNotionalLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg1()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build()).setSchdlPrd(MapperS.of((Object)drrReport).mapC("getNotionalAmountScheduleLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalAmountScheduleLeg1()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule11__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getEffectiveDate()).get()).setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).build());
            }).getMulti()).build()).setScndLeg(NotionalAmount6__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getNotionalLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalLeg2()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult1).build()).setSchdlPrd(MapperS.of((Object)drrReport).mapC("getNotionalAmountScheduleLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalAmountScheduleLeg2()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule11__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getEffectiveDate()).get()).setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getNotionalCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).build());
            }).getMulti()).build()).build());
            return Optional.ofNullable(ntnlAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

