/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.mas.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.mas.AmountAndDirection106__2;
import iso20022.auth030.mas.NotionalAmount5__1;
import iso20022.auth030.mas.NotionalAmount6__1;
import iso20022.auth030.mas.NotionalAmountLegs5__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNtnlAmtDefault.class)
public abstract class GetNtnlAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public NotionalAmountLegs5__1 evaluate(MASTransactionReport drrReport) {
        NotionalAmountLegs5__1 ntnlAmt;
        NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmtBuilder = this.doEvaluate(drrReport);
        if (ntnlAmtBuilder == null) {
            ntnlAmt = null;
        } else {
            ntnlAmt = ntnlAmtBuilder.build();
            this.objectValidator.validate(NotionalAmountLegs5__1.class, (RosettaModelObject)ntnlAmt);
        }
        return ntnlAmt;
    }

    protected abstract NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(MASTransactionReport var1);

    public static class GetNtnlAmtDefault
    extends GetNtnlAmt {
        @Override
        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(MASTransactionReport drrReport) {
            NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt = NotionalAmountLegs5__1.builder();
            return this.assignOutput(ntnlAmt, drrReport);
        }

        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder assignOutput(NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt, MASTransactionReport drrReport) {
            Boolean ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getNotionalAmountOfTheContractOrLeg1", mASTransactionReport -> mASTransactionReport.getNotionalAmountOfTheContractOrLeg1()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = false;
            }
            Boolean ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getNotionalAmountOfLeg2", mASTransactionReport -> mASTransactionReport.getNotionalAmountOfLeg2()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = false;
            }
            ntnlAmt = (NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder)this.toBuilder((RosettaModelObject)NotionalAmountLegs5__1.builder().setFrstLeg(NotionalAmount5__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getNotionalAmountOfTheContractOrLeg1", mASTransactionReport -> mASTransactionReport.getNotionalAmountOfTheContractOrLeg1()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyOfTheContractOrLeg1", mASTransactionReport -> mASTransactionReport.getNotionalCurrencyOfTheContractOrLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build()).build()).setScndLeg(NotionalAmount6__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getNotionalAmountOfLeg2", mASTransactionReport -> mASTransactionReport.getNotionalAmountOfLeg2()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getNotionalCurrencyOfLeg2", mASTransactionReport -> mASTransactionReport.getNotionalCurrencyOfLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult1).build()).build()).build());
            return Optional.ofNullable(ntnlAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

