/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import drr.regulation.asic.rewrite.trade.Basket;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.asic.rewrite.trade.OtherPaymentReport;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.regulation.asic.rewrite.trade.PackageTransactionSpread;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.asic.rewrite.trade.meta.ASICTransactionReportMeta;
import iso20022.auth030.asic.InterestComputationMethod4Code;
import iso20022.auth030.asic.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ASICTransactionReport", builder=ASICTransactionReportBuilderImpl.class, version="5.58.0")
@RuneDataType(value="ASICTransactionReport", model="drr", builder=ASICTransactionReportBuilderImpl.class, version="5.58.0")
public interface ASICTransactionReport
extends RosettaModelObject {
    public static final ASICTransactionReportMeta metaData = new ASICTransactionReportMeta();

    public String getUniqueTransactionIdentifier();

    public String getUtiProprietaryID();

    public String getSecondaryTransactionIdentifier();

    public String getUniqueProductIdentifier();

    public String getAssetClass();

    public String getContractType();

    public String getReportingEntity();

    public String getCounterparty1();

    public String getCounterparty2();

    public String getCounterparty2Name();

    public Boolean getCounterparty2IdentifierTypeIndicator();

    public ISOCountryCodeEnum getCountryOfTheCounterParty2();

    public String getBeneficiary1();

    public Boolean getBeneficiary1IdentifierTypeIndicator();

    public String getBroker();

    public String getExecutionAgentOfCounterparty1();

    public String getDirection();

    public String getDirection2OfLeg1();

    public String getDirection2OfLeg2();

    public Date getEffectiveDate();

    public Date getExpirationDate();

    public ZonedDateTime getExecutionTimestamp();

    public ZonedDateTime getEventTimestamp();

    public ZonedDateTime getClearingTimestamp();

    public String getCleared();

    public String getCentralCounterparty();

    public String getClearingMember();

    public String getPlatformIdentifier();

    public BigDecimal getNotionalLeg1();

    public BigDecimal getNotionalLeg2();

    public BigDecimal getTotalNotionalQuantityLeg1();

    public BigDecimal getTotalNotionalQuantityLeg2();

    public BigDecimal getNotionalQuantityLeg1();

    public BigDecimal getNotionalQuantityLeg2();

    public BigDecimal getCallAmount();

    public BigDecimal getPutAmount();

    public ISOCurrencyCodeEnum getNotionalCurrencyLeg1();

    public ISOCurrencyCodeEnum getNotionalCurrencyLeg2();

    public String getQuantityUnitOfMeasureLeg1();

    public String getQuantityUnitOfMeasureLeg2();

    public ISOCurrencyCodeEnum getCallCurrency();

    public ISOCurrencyCodeEnum getPutCurrency();

    public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();

    public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();

    public PriceAndNotation getPrice();

    public String getPriceUnitOfMeasure();

    public BigDecimal getFixedRateLeg1();

    public BigDecimal getFixedRateLeg2();

    public String getSpreadNotationLeg1();

    public SpreadLeg1 getSpreadLeg1();

    public String getSpreadNotationLeg2();

    public SpreadLeg2 getSpreadLeg2();

    public ISOCurrencyCodeEnum getSpreadCurrencyLeg1();

    public ISOCurrencyCodeEnum getSpreadCurrencyLeg2();

    public StrikePriceAndNotation getStrikePrice();

    public BarrierAndNotation getBarrier();

    public BigDecimal getOptionPremiumAmount();

    public ISOCurrencyCodeEnum getOptionPremiumCurrency();

    public Date getOptionPremiumPaymentDate();

    public BigDecimal getExchangeRate();

    public String getExchangeRateBasis();

    public InterestComputationMethod4Code getDayCountConventionLeg1();

    public InterestComputationMethod4Code getDayCountConventionLeg2();

    public String getPaymentFrequencyPeriodLeg1();

    public String getPaymentFrequencyPeriodLeg2();

    public Integer getPaymentFrequencyPeriodMultiplierLeg1();

    public Integer getPaymentFrequencyPeriodMultiplierLeg2();

    public ISOCurrencyCodeEnum getSettlementCurrencyLeg1();

    public ISOCurrencyCodeEnum getSettlementCurrencyLeg2();

    public List<? extends OtherPaymentReport> getOtherPayment();

    public ASICCustomBasket getCustomBasketCode();

    public Basket getBasket();

    public String getUnderlyingIdentification();

    public String getUnderlyingIdentificationType();

    public String getUnderlyingIdOther();

    public ProductIdTypeEnum getUnderlyingIdOtherSource();

    public Date getMaturityDateOfTheUnderlying();

    public String getIndicatorOfTheFloatingRateLeg2();

    public String getFloatingRateReferencePeriodOfLeg2TimePeriod();

    public Integer getFloatingRateReferencePeriodOfLeg2Multiplier();

    public BigDecimal getCdSIndexAttachmentPoint();

    public BigDecimal getCdSIndexDetachmentPoint();

    public BigDecimal getIndexFactor();

    public String getPackageIdentifier();

    public PackageTransactionPrice getPackageTransactionPrice();

    public PackageTransactionSpread getPackageTransactionSpread();

    public String getPriorUTI();

    public String getPriorUtiProprietary();

    public String getEventIdentifier();

    public String getActionType();

    public String getEventType();

    public ZonedDateTime getReportingTimestamp();

    public String getReportSubmittingEntityID();

    public String getNewDerivativeTradeRepository();

    public ZonedDateTime getValuationTimestamp();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public BigDecimal getDelta();

    public Date getNextFloatingReferenceResetDateLeg1();

    public Date getNextFloatingReferenceResetDateLeg2();

    public String getSmallScaleBuySideEntityIndicator();

    public String getTechnicalRecordId();

    public Boolean getCollateralPortfolioIndicator();

    public String getCollateralPortfolioCodeInitialMargin();

    public String getCollateralPortfolioCodeVariationMargin();

    public String getExecutionAgentOfCounterparty2DTCC();

    public ASICNonReportable getNonReportable();

    public ASICTransactionReport build();

    public ASICTransactionReportBuilder toBuilder();

    public static ASICTransactionReportBuilder builder() {
        return new ASICTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICTransactionReport> getType() {
        return ASICTransactionReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, (Object)this.getUtiProprietaryID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterParty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("broker"), String.class, (Object)this.getBroker(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction"), String.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2OfLeg1"), String.class, (Object)this.getDirection2OfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2OfLeg2"), String.class, (Object)this.getDirection2OfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, (Object)this.getNotionalLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, (Object)this.getNotionalLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, (Object)this.getNotionalQuantityLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, (Object)this.getNotionalQuantityLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, this.getNotionalAmountScheduleLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, this.getNotionalAmountScheduleLeg2(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, (Object)this.getFixedRateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, (Object)this.getFixedRateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, (Object)this.getSpreadNotationLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadLeg1"), processor, SpreadLeg1.class, this.getSpreadLeg1(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, (Object)this.getSpreadNotationLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadLeg2"), processor, SpreadLeg2.class, this.getSpreadLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrencyLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrencyLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, this.getStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountConventionLeg1"), InterestComputationMethod4Code.class, (Object)this.getDayCountConventionLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountConventionLeg2"), InterestComputationMethod4Code.class, (Object)this.getDayCountConventionLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, (Object)this.getPaymentFrequencyPeriodLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, (Object)this.getPaymentFrequencyPeriodLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getPaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getPaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("customBasketCode"), processor, ASICCustomBasket.class, this.getCustomBasketCode(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basket"), processor, Basket.class, this.getBasket(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateLeg2"), String.class, (Object)this.getIndicatorOfTheFloatingRateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, (Object)this.getPriorUtiProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newDerivativeTradeRepository"), String.class, (Object)this.getNewDerivativeTradeRepository(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCodeInitialMargin"), String.class, (Object)this.getCollateralPortfolioCodeInitialMargin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCodeVariationMargin"), String.class, (Object)this.getCollateralPortfolioCodeVariationMargin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, (Object)this.getExecutionAgentOfCounterparty2DTCC(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, ASICNonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
    }

    public static class ASICTransactionReportBuilderImpl
    implements ASICTransactionReportBuilder {
        protected String uniqueTransactionIdentifier;
        protected String utiProprietaryID;
        protected String secondaryTransactionIdentifier;
        protected String uniqueProductIdentifier;
        protected String assetClass;
        protected String contractType;
        protected String reportingEntity;
        protected String counterparty1;
        protected String counterparty2;
        protected String counterparty2Name;
        protected Boolean counterparty2IdentifierTypeIndicator;
        protected ISOCountryCodeEnum countryOfTheCounterParty2;
        protected String beneficiary1;
        protected Boolean beneficiary1IdentifierTypeIndicator;
        protected String broker;
        protected String executionAgentOfCounterparty1;
        protected String direction;
        protected String direction2OfLeg1;
        protected String direction2OfLeg2;
        protected Date effectiveDate;
        protected Date expirationDate;
        protected ZonedDateTime executionTimestamp;
        protected ZonedDateTime eventTimestamp;
        protected ZonedDateTime clearingTimestamp;
        protected String cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected String platformIdentifier;
        protected BigDecimal notionalLeg1;
        protected BigDecimal notionalLeg2;
        protected BigDecimal totalNotionalQuantityLeg1;
        protected BigDecimal totalNotionalQuantityLeg2;
        protected BigDecimal notionalQuantityLeg1;
        protected BigDecimal notionalQuantityLeg2;
        protected BigDecimal callAmount;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum notionalCurrencyLeg1;
        protected ISOCurrencyCodeEnum notionalCurrencyLeg2;
        protected String quantityUnitOfMeasureLeg1;
        protected String quantityUnitOfMeasureLeg2;
        protected ISOCurrencyCodeEnum callCurrency;
        protected ISOCurrencyCodeEnum putCurrency;
        protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
        protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
        protected PriceAndNotation.PriceAndNotationBuilder price;
        protected String priceUnitOfMeasure;
        protected BigDecimal fixedRateLeg1;
        protected BigDecimal fixedRateLeg2;
        protected String spreadNotationLeg1;
        protected SpreadLeg1.SpreadLeg1Builder spreadLeg1;
        protected String spreadNotationLeg2;
        protected SpreadLeg2.SpreadLeg2Builder spreadLeg2;
        protected ISOCurrencyCodeEnum spreadCurrencyLeg1;
        protected ISOCurrencyCodeEnum spreadCurrencyLeg2;
        protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
        protected BarrierAndNotation.BarrierAndNotationBuilder barrier;
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected Date optionPremiumPaymentDate;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected InterestComputationMethod4Code dayCountConventionLeg1;
        protected InterestComputationMethod4Code dayCountConventionLeg2;
        protected String paymentFrequencyPeriodLeg1;
        protected String paymentFrequencyPeriodLeg2;
        protected Integer paymentFrequencyPeriodMultiplierLeg1;
        protected Integer paymentFrequencyPeriodMultiplierLeg2;
        protected ISOCurrencyCodeEnum settlementCurrencyLeg1;
        protected ISOCurrencyCodeEnum settlementCurrencyLeg2;
        protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
        protected ASICCustomBasket.ASICCustomBasketBuilder customBasketCode;
        protected Basket.BasketBuilder basket;
        protected String underlyingIdentification;
        protected String underlyingIdentificationType;
        protected String underlyingIdOther;
        protected ProductIdTypeEnum underlyingIdOtherSource;
        protected Date maturityDateOfTheUnderlying;
        protected String indicatorOfTheFloatingRateLeg2;
        protected String floatingRateReferencePeriodOfLeg2TimePeriod;
        protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
        protected BigDecimal cdSIndexAttachmentPoint;
        protected BigDecimal cdSIndexDetachmentPoint;
        protected BigDecimal indexFactor;
        protected String packageIdentifier;
        protected PackageTransactionPrice.PackageTransactionPriceBuilder packageTransactionPrice;
        protected PackageTransactionSpread.PackageTransactionSpreadBuilder packageTransactionSpread;
        protected String priorUTI;
        protected String priorUtiProprietary;
        protected String eventIdentifier;
        protected String actionType;
        protected String eventType;
        protected ZonedDateTime reportingTimestamp;
        protected String reportSubmittingEntityID;
        protected String newDerivativeTradeRepository;
        protected ZonedDateTime valuationTimestamp;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected BigDecimal delta;
        protected Date nextFloatingReferenceResetDateLeg1;
        protected Date nextFloatingReferenceResetDateLeg2;
        protected String smallScaleBuySideEntityIndicator;
        protected String technicalRecordId;
        protected Boolean collateralPortfolioIndicator;
        protected String collateralPortfolioCodeInitialMargin;
        protected String collateralPortfolioCodeVariationMargin;
        protected String executionAgentOfCounterparty2DTCC;
        protected ASICNonReportable.ASICNonReportableBuilder nonReportable;

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public String getUtiProprietaryID() {
            return this.utiProprietaryID;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public String getSecondaryTransactionIdentifier() {
            return this.secondaryTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="reportingEntity")
        @RuneAttribute(value="reportingEntity")
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterParty2")
        @RuneAttribute(value="countryOfTheCounterParty2")
        public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
            return this.countryOfTheCounterParty2;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="broker")
        @RuneAttribute(value="broker")
        public String getBroker() {
            return this.broker;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public String getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg1")
        @RuneAttribute(value="direction2OfLeg1")
        public String getDirection2OfLeg1() {
            return this.direction2OfLeg1;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg2")
        @RuneAttribute(value="direction2OfLeg2")
        public String getDirection2OfLeg2() {
            return this.direction2OfLeg2;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ZonedDateTime getClearingTimestamp() {
            return this.clearingTimestamp;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public BigDecimal getNotionalLeg1() {
            return this.notionalLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public BigDecimal getNotionalLeg2() {
            return this.notionalLeg2;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public BigDecimal getTotalNotionalQuantityLeg1() {
            return this.totalNotionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg1")
        @RuneAttribute(value="notionalQuantityLeg1")
        public BigDecimal getNotionalQuantityLeg1() {
            return this.notionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg2")
        @RuneAttribute(value="notionalQuantityLeg2")
        public BigDecimal getNotionalQuantityLeg2() {
            return this.notionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg1")
        @RuneAttribute(value="notionalCurrencyLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
            return this.notionalCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg2")
        @RuneAttribute(value="notionalCurrencyLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
            return this.notionalCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public String getQuantityUnitOfMeasureLeg1() {
            return this.quantityUnitOfMeasureLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
            return this.notionalAmountScheduleLeg1;
        }

        @Override
        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
            if (this.notionalAmountScheduleLeg1 == null) {
                this.notionalAmountScheduleLeg1 = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg1, index, () -> {
                NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
                return newNotionalAmountScheduleLeg1;
            });
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
            return this.notionalAmountScheduleLeg2;
        }

        @Override
        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
            if (this.notionalAmountScheduleLeg2 == null) {
                this.notionalAmountScheduleLeg2 = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg2, index, () -> {
                NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
                return newNotionalAmountScheduleLeg2;
            });
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation.PriceAndNotationBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
            PriceAndNotation.PriceAndNotationBuilder result = this.price != null ? this.price : (this.price = PriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public BigDecimal getFixedRateLeg1() {
            return this.fixedRateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public BigDecimal getFixedRateLeg2() {
            return this.fixedRateLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg1")
        @RuneAttribute(value="spreadNotationLeg1")
        public String getSpreadNotationLeg1() {
            return this.spreadNotationLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadLeg1")
        @RuneAttribute(value="spreadLeg1")
        public SpreadLeg1.SpreadLeg1Builder getSpreadLeg1() {
            return this.spreadLeg1;
        }

        @Override
        public SpreadLeg1.SpreadLeg1Builder getOrCreateSpreadLeg1() {
            SpreadLeg1.SpreadLeg1Builder result = this.spreadLeg1 != null ? this.spreadLeg1 : (this.spreadLeg1 = SpreadLeg1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg2")
        @RuneAttribute(value="spreadNotationLeg2")
        public String getSpreadNotationLeg2() {
            return this.spreadNotationLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadLeg2")
        @RuneAttribute(value="spreadLeg2")
        public SpreadLeg2.SpreadLeg2Builder getSpreadLeg2() {
            return this.spreadLeg2;
        }

        @Override
        public SpreadLeg2.SpreadLeg2Builder getOrCreateSpreadLeg2() {
            SpreadLeg2.SpreadLeg2Builder result = this.spreadLeg2 != null ? this.spreadLeg2 : (this.spreadLeg2 = SpreadLeg2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg1")
        @RuneAttribute(value="spreadCurrencyLeg1")
        public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
            return this.spreadCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg2")
        @RuneAttribute(value="spreadCurrencyLeg2")
        public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
            return this.spreadCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
            StrikePriceAndNotation.StrikePriceAndNotationBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = StrikePriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public BarrierAndNotation.BarrierAndNotationBuilder getBarrier() {
            return this.barrier;
        }

        @Override
        public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier() {
            BarrierAndNotation.BarrierAndNotationBuilder result = this.barrier != null ? this.barrier : (this.barrier = BarrierAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg1")
        @RuneAttribute(value="dayCountConventionLeg1")
        public InterestComputationMethod4Code getDayCountConventionLeg1() {
            return this.dayCountConventionLeg1;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg2")
        @RuneAttribute(value="dayCountConventionLeg2")
        public InterestComputationMethod4Code getDayCountConventionLeg2() {
            return this.dayCountConventionLeg2;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodLeg1")
        public String getPaymentFrequencyPeriodLeg1() {
            return this.paymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodLeg2")
        public String getPaymentFrequencyPeriodLeg2() {
            return this.paymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        public Integer getPaymentFrequencyPeriodMultiplierLeg1() {
            return this.paymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        public Integer getPaymentFrequencyPeriodMultiplierLeg2() {
            return this.paymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
            return this.settlementCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
            return this.settlementCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
            }
            return (OtherPaymentReport.OtherPaymentReportBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public ASICCustomBasket.ASICCustomBasketBuilder getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        public ASICCustomBasket.ASICCustomBasketBuilder getOrCreateCustomBasketCode() {
            ASICCustomBasket.ASICCustomBasketBuilder result = this.customBasketCode != null ? this.customBasketCode : (this.customBasketCode = ASICCustomBasket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public Basket.BasketBuilder getBasket() {
            return this.basket;
        }

        @Override
        public Basket.BasketBuilder getOrCreateBasket() {
            Basket.BasketBuilder result = this.basket != null ? this.basket : (this.basket = Basket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public String getUnderlyingIdentification() {
            return this.underlyingIdentification;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ProductIdTypeEnum getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateLeg2")
        public String getIndicatorOfTheFloatingRateLeg2() {
            return this.indicatorOfTheFloatingRateLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg2TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
            return this.floatingRateReferencePeriodOfLeg2Multiplier;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice() {
            PackageTransactionPrice.PackageTransactionPriceBuilder result = this.packageTransactionPrice != null ? this.packageTransactionPrice : (this.packageTransactionPrice = PackageTransactionPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread() {
            PackageTransactionSpread.PackageTransactionSpreadBuilder result = this.packageTransactionSpread != null ? this.packageTransactionSpread : (this.packageTransactionSpread = PackageTransactionSpread.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public String getPriorUtiProprietary() {
            return this.priorUtiProprietary;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="newDerivativeTradeRepository")
        @RuneAttribute(value="newDerivativeTradeRepository")
        public String getNewDerivativeTradeRepository() {
            return this.newDerivativeTradeRepository;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeInitialMargin")
        @RuneAttribute(value="collateralPortfolioCodeInitialMargin")
        public String getCollateralPortfolioCodeInitialMargin() {
            return this.collateralPortfolioCodeInitialMargin;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVariationMargin")
        @RuneAttribute(value="collateralPortfolioCodeVariationMargin")
        public String getCollateralPortfolioCodeVariationMargin() {
            return this.collateralPortfolioCodeVariationMargin;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public String getExecutionAgentOfCounterparty2DTCC() {
            return this.executionAgentOfCounterparty2DTCC;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public ASICNonReportable.ASICNonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public ASICNonReportable.ASICNonReportableBuilder getOrCreateNonReportable() {
            ASICNonReportable.ASICNonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = ASICNonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public ASICTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public ASICTransactionReportBuilder setUtiProprietaryID(String _utiProprietaryID) {
            this.utiProprietaryID = _utiProprietaryID == null ? null : _utiProprietaryID;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public ASICTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public ASICTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public ASICTransactionReportBuilder setAssetClass(String _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public ASICTransactionReportBuilder setContractType(String _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingEntity")
        @RuneAttribute(value="reportingEntity")
        public ASICTransactionReportBuilder setReportingEntity(String _reportingEntity) {
            this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ASICTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public ASICTransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public ASICTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public ASICTransactionReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
            this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterParty2")
        @RuneAttribute(value="countryOfTheCounterParty2")
        public ASICTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
            this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public ASICTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public ASICTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="broker")
        @RuneAttribute(value="broker")
        public ASICTransactionReportBuilder setBroker(String _broker) {
            this.broker = _broker == null ? null : _broker;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public ASICTransactionReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
            this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public ASICTransactionReportBuilder setDirection(String _direction) {
            this.direction = _direction == null ? null : _direction;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg1")
        @RuneAttribute(value="direction2OfLeg1")
        public ASICTransactionReportBuilder setDirection2OfLeg1(String _direction2OfLeg1) {
            this.direction2OfLeg1 = _direction2OfLeg1 == null ? null : _direction2OfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg2")
        @RuneAttribute(value="direction2OfLeg2")
        public ASICTransactionReportBuilder setDirection2OfLeg2(String _direction2OfLeg2) {
            this.direction2OfLeg2 = _direction2OfLeg2 == null ? null : _direction2OfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ASICTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ASICTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ASICTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ASICTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ASICTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ASICTransactionReportBuilder setCleared(String _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public ASICTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public ASICTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public ASICTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public ASICTransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
            this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public ASICTransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
            this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public ASICTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
            this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public ASICTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
            this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg1")
        @RuneAttribute(value="notionalQuantityLeg1")
        public ASICTransactionReportBuilder setNotionalQuantityLeg1(BigDecimal _notionalQuantityLeg1) {
            this.notionalQuantityLeg1 = _notionalQuantityLeg1 == null ? null : _notionalQuantityLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg2")
        @RuneAttribute(value="notionalQuantityLeg2")
        public ASICTransactionReportBuilder setNotionalQuantityLeg2(BigDecimal _notionalQuantityLeg2) {
            this.notionalQuantityLeg2 = _notionalQuantityLeg2 == null ? null : _notionalQuantityLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public ASICTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public ASICTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg1")
        @RuneAttribute(value="notionalCurrencyLeg1")
        public ASICTransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum _notionalCurrencyLeg1) {
            this.notionalCurrencyLeg1 = _notionalCurrencyLeg1 == null ? null : _notionalCurrencyLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg2")
        @RuneAttribute(value="notionalCurrencyLeg2")
        public ASICTransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum _notionalCurrencyLeg2) {
            this.notionalCurrencyLeg2 = _notionalCurrencyLeg2 == null ? null : _notionalCurrencyLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
            this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
            this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ASICTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ASICTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
            if (_notionalAmountScheduleLeg1 != null) {
                this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
            }
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
            if (notionalAmountScheduleLeg1s != null) {
                for (NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1Report : notionalAmountScheduleLeg1s) {
                    this.notionalAmountScheduleLeg1.add(notionalAmountScheduleLeg1Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public ASICTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
            this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s == null ? new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>() : (List)notionalAmountScheduleLeg1s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
            if (_notionalAmountScheduleLeg2 != null) {
                this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
            }
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
            if (notionalAmountScheduleLeg2s != null) {
                for (NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2Report : notionalAmountScheduleLeg2s) {
                    this.notionalAmountScheduleLeg2.add(notionalAmountScheduleLeg2Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public ASICTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
            this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s == null ? new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>() : (List)notionalAmountScheduleLeg2s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public ASICTransactionReportBuilder setPrice(PriceAndNotation _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public ASICTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public ASICTransactionReportBuilder setFixedRateLeg1(BigDecimal _fixedRateLeg1) {
            this.fixedRateLeg1 = _fixedRateLeg1 == null ? null : _fixedRateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public ASICTransactionReportBuilder setFixedRateLeg2(BigDecimal _fixedRateLeg2) {
            this.fixedRateLeg2 = _fixedRateLeg2 == null ? null : _fixedRateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg1")
        @RuneAttribute(value="spreadNotationLeg1")
        public ASICTransactionReportBuilder setSpreadNotationLeg1(String _spreadNotationLeg1) {
            this.spreadNotationLeg1 = _spreadNotationLeg1 == null ? null : _spreadNotationLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadLeg1")
        @RuneAttribute(value="spreadLeg1")
        public ASICTransactionReportBuilder setSpreadLeg1(SpreadLeg1 _spreadLeg1) {
            this.spreadLeg1 = _spreadLeg1 == null ? null : _spreadLeg1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg2")
        @RuneAttribute(value="spreadNotationLeg2")
        public ASICTransactionReportBuilder setSpreadNotationLeg2(String _spreadNotationLeg2) {
            this.spreadNotationLeg2 = _spreadNotationLeg2 == null ? null : _spreadNotationLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadLeg2")
        @RuneAttribute(value="spreadLeg2")
        public ASICTransactionReportBuilder setSpreadLeg2(SpreadLeg2 _spreadLeg2) {
            this.spreadLeg2 = _spreadLeg2 == null ? null : _spreadLeg2.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg1")
        @RuneAttribute(value="spreadCurrencyLeg1")
        public ASICTransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum _spreadCurrencyLeg1) {
            this.spreadCurrencyLeg1 = _spreadCurrencyLeg1 == null ? null : _spreadCurrencyLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg2")
        @RuneAttribute(value="spreadCurrencyLeg2")
        public ASICTransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum _spreadCurrencyLeg2) {
            this.spreadCurrencyLeg2 = _spreadCurrencyLeg2 == null ? null : _spreadCurrencyLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public ASICTransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public ASICTransactionReportBuilder setBarrier(BarrierAndNotation _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public ASICTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ASICTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public ASICTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public ASICTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public ASICTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg1")
        @RuneAttribute(value="dayCountConventionLeg1")
        public ASICTransactionReportBuilder setDayCountConventionLeg1(InterestComputationMethod4Code _dayCountConventionLeg1) {
            this.dayCountConventionLeg1 = _dayCountConventionLeg1 == null ? null : _dayCountConventionLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg2")
        @RuneAttribute(value="dayCountConventionLeg2")
        public ASICTransactionReportBuilder setDayCountConventionLeg2(InterestComputationMethod4Code _dayCountConventionLeg2) {
            this.dayCountConventionLeg2 = _dayCountConventionLeg2 == null ? null : _dayCountConventionLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodLeg1")
        public ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg1(String _paymentFrequencyPeriodLeg1) {
            this.paymentFrequencyPeriodLeg1 = _paymentFrequencyPeriodLeg1 == null ? null : _paymentFrequencyPeriodLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodLeg2")
        public ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg2(String _paymentFrequencyPeriodLeg2) {
            this.paymentFrequencyPeriodLeg2 = _paymentFrequencyPeriodLeg2 == null ? null : _paymentFrequencyPeriodLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        public ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg1(Integer _paymentFrequencyPeriodMultiplierLeg1) {
            this.paymentFrequencyPeriodMultiplierLeg1 = _paymentFrequencyPeriodMultiplierLeg1 == null ? null : _paymentFrequencyPeriodMultiplierLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        public ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg2(Integer _paymentFrequencyPeriodMultiplierLeg2) {
            this.paymentFrequencyPeriodMultiplierLeg2 = _paymentFrequencyPeriodMultiplierLeg2 == null ? null : _paymentFrequencyPeriodMultiplierLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public ASICTransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum _settlementCurrencyLeg1) {
            this.settlementCurrencyLeg1 = _settlementCurrencyLeg1 == null ? null : _settlementCurrencyLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public ASICTransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum _settlementCurrencyLeg2) {
            this.settlementCurrencyLeg2 = _settlementCurrencyLeg2 == null ? null : _settlementCurrencyLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public ASICTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            if (otherPayments != null) {
                for (OtherPaymentReport otherPaymentReport : otherPayments) {
                    this.otherPayment.add(otherPaymentReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public ASICTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public ASICTransactionReportBuilder setCustomBasketCode(ASICCustomBasket _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public ASICTransactionReportBuilder setBasket(Basket _basket) {
            this.basket = _basket == null ? null : _basket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public ASICTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public ASICTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public ASICTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ASICTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public ASICTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateLeg2")
        public ASICTransactionReportBuilder setIndicatorOfTheFloatingRateLeg2(String _indicatorOfTheFloatingRateLeg2) {
            this.indicatorOfTheFloatingRateLeg2 = _indicatorOfTheFloatingRateLeg2 == null ? null : _indicatorOfTheFloatingRateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
            this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
            this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public ASICTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public ASICTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public ASICTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public ASICTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public ASICTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public ASICTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public ASICTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public ASICTransactionReportBuilder setPriorUtiProprietary(String _priorUtiProprietary) {
            this.priorUtiProprietary = _priorUtiProprietary == null ? null : _priorUtiProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ASICTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ASICTransactionReportBuilder setActionType(String _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public ASICTransactionReportBuilder setEventType(String _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ASICTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ASICTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="newDerivativeTradeRepository")
        @RuneAttribute(value="newDerivativeTradeRepository")
        public ASICTransactionReportBuilder setNewDerivativeTradeRepository(String _newDerivativeTradeRepository) {
            this.newDerivativeTradeRepository = _newDerivativeTradeRepository == null ? null : _newDerivativeTradeRepository;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ASICTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public ASICTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ASICTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ASICTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ASICTransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public ASICTransactionReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
            this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public ASICTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public ASICTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeInitialMargin")
        @RuneAttribute(value="collateralPortfolioCodeInitialMargin")
        public ASICTransactionReportBuilder setCollateralPortfolioCodeInitialMargin(String _collateralPortfolioCodeInitialMargin) {
            this.collateralPortfolioCodeInitialMargin = _collateralPortfolioCodeInitialMargin == null ? null : _collateralPortfolioCodeInitialMargin;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVariationMargin")
        @RuneAttribute(value="collateralPortfolioCodeVariationMargin")
        public ASICTransactionReportBuilder setCollateralPortfolioCodeVariationMargin(String _collateralPortfolioCodeVariationMargin) {
            this.collateralPortfolioCodeVariationMargin = _collateralPortfolioCodeVariationMargin == null ? null : _collateralPortfolioCodeVariationMargin;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public ASICTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String _executionAgentOfCounterparty2DTCC) {
            this.executionAgentOfCounterparty2DTCC = _executionAgentOfCounterparty2DTCC == null ? null : _executionAgentOfCounterparty2DTCC;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public ASICTransactionReportBuilder setNonReportable(ASICNonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        public ASICTransactionReport build() {
            return new ASICTransactionReportImpl(this);
        }

        @Override
        public ASICTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICTransactionReportBuilder prune() {
            this.notionalAmountScheduleLeg1 = this.notionalAmountScheduleLeg1.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalAmountScheduleLeg2 = this.notionalAmountScheduleLeg2.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            if (this.spreadLeg1 != null && !this.spreadLeg1.prune().hasData()) {
                this.spreadLeg1 = null;
            }
            if (this.spreadLeg2 != null && !this.spreadLeg2.prune().hasData()) {
                this.spreadLeg2 = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            if (this.barrier != null && !this.barrier.prune().hasData()) {
                this.barrier = null;
            }
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.customBasketCode != null && !this.customBasketCode.prune().hasData()) {
                this.customBasketCode = null;
            }
            if (this.basket != null && !this.basket.prune().hasData()) {
                this.basket = null;
            }
            if (this.packageTransactionPrice != null && !this.packageTransactionPrice.prune().hasData()) {
                this.packageTransactionPrice = null;
            }
            if (this.packageTransactionSpread != null && !this.packageTransactionSpread.prune().hasData()) {
                this.packageTransactionSpread = null;
            }
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUtiProprietaryID() != null) {
                return true;
            }
            if (this.getSecondaryTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getReportingEntity() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getCountryOfTheCounterParty2() != null) {
                return true;
            }
            if (this.getBeneficiary1() != null) {
                return true;
            }
            if (this.getBeneficiary1IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getBroker() != null) {
                return true;
            }
            if (this.getExecutionAgentOfCounterparty1() != null) {
                return true;
            }
            if (this.getDirection() != null) {
                return true;
            }
            if (this.getDirection2OfLeg1() != null) {
                return true;
            }
            if (this.getDirection2OfLeg2() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getClearingTimestamp() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getPlatformIdentifier() != null) {
                return true;
            }
            if (this.getNotionalLeg1() != null) {
                return true;
            }
            if (this.getNotionalLeg2() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantityLeg1() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantityLeg2() != null) {
                return true;
            }
            if (this.getNotionalQuantityLeg1() != null) {
                return true;
            }
            if (this.getNotionalQuantityLeg2() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getNotionalCurrencyLeg1() != null) {
                return true;
            }
            if (this.getNotionalCurrencyLeg2() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureLeg1() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureLeg2() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg1() != null && this.getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg2() != null && this.getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getFixedRateLeg1() != null) {
                return true;
            }
            if (this.getFixedRateLeg2() != null) {
                return true;
            }
            if (this.getSpreadNotationLeg1() != null) {
                return true;
            }
            if (this.getSpreadLeg1() != null && this.getSpreadLeg1().hasData()) {
                return true;
            }
            if (this.getSpreadNotationLeg2() != null) {
                return true;
            }
            if (this.getSpreadLeg2() != null && this.getSpreadLeg2().hasData()) {
                return true;
            }
            if (this.getSpreadCurrencyLeg1() != null) {
                return true;
            }
            if (this.getSpreadCurrencyLeg2() != null) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().hasData()) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getOptionPremiumPaymentDate() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getDayCountConventionLeg1() != null) {
                return true;
            }
            if (this.getDayCountConventionLeg2() != null) {
                return true;
            }
            if (this.getPaymentFrequencyPeriodLeg1() != null) {
                return true;
            }
            if (this.getPaymentFrequencyPeriodLeg2() != null) {
                return true;
            }
            if (this.getPaymentFrequencyPeriodMultiplierLeg1() != null) {
                return true;
            }
            if (this.getPaymentFrequencyPeriodMultiplierLeg2() != null) {
                return true;
            }
            if (this.getSettlementCurrencyLeg1() != null) {
                return true;
            }
            if (this.getSettlementCurrencyLeg2() != null) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCustomBasketCode() != null && this.getCustomBasketCode().hasData()) {
                return true;
            }
            if (this.getBasket() != null && this.getBasket().hasData()) {
                return true;
            }
            if (this.getUnderlyingIdentification() != null) {
                return true;
            }
            if (this.getUnderlyingIdentificationType() != null) {
                return true;
            }
            if (this.getUnderlyingIdOther() != null) {
                return true;
            }
            if (this.getUnderlyingIdOtherSource() != null) {
                return true;
            }
            if (this.getMaturityDateOfTheUnderlying() != null) {
                return true;
            }
            if (this.getIndicatorOfTheFloatingRateLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg2TimePeriod() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg2Multiplier() != null) {
                return true;
            }
            if (this.getCdSIndexAttachmentPoint() != null) {
                return true;
            }
            if (this.getCdSIndexDetachmentPoint() != null) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getPackageTransactionPrice() != null && this.getPackageTransactionPrice().hasData()) {
                return true;
            }
            if (this.getPackageTransactionSpread() != null && this.getPackageTransactionSpread().hasData()) {
                return true;
            }
            if (this.getPriorUTI() != null) {
                return true;
            }
            if (this.getPriorUtiProprietary() != null) {
                return true;
            }
            if (this.getEventIdentifier() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getNewDerivativeTradeRepository() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getSmallScaleBuySideEntityIndicator() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getCollateralPortfolioCodeInitialMargin() != null) {
                return true;
            }
            if (this.getCollateralPortfolioCodeVariationMargin() != null) {
                return true;
            }
            if (this.getExecutionAgentOfCounterparty2DTCC() != null) {
                return true;
            }
            return this.getNonReportable() != null && this.getNonReportable().hasData();
        }

        public ASICTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ASICTransactionReportBuilder o = (ASICTransactionReportBuilder)other;
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadLeg1(), (RosettaModelObjectBuilder)o.getSpreadLeg1(), this::setSpreadLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadLeg2(), (RosettaModelObjectBuilder)o.getSpreadLeg2(), this::setSpreadLeg2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrier(), (RosettaModelObjectBuilder)o.getBarrier(), this::setBarrier);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCustomBasketCode(), (RosettaModelObjectBuilder)o.getCustomBasketCode(), this::setCustomBasketCode);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasket(), (RosettaModelObjectBuilder)o.getBasket(), this::setBasket);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionPrice(), (RosettaModelObjectBuilder)o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionSpread(), (RosettaModelObjectBuilder)o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiProprietaryID(), (Object)o.getUtiProprietaryID(), this::setUtiProprietaryID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecondaryTransactionIdentifier(), (Object)o.getSecondaryTransactionIdentifier(), this::setSecondaryTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifier(), (Object)o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingEntity(), (Object)o.getReportingEntity(), this::setReportingEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierTypeIndicator(), (Object)o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCountryOfTheCounterParty2(), (Object)o.getCountryOfTheCounterParty2(), this::setCountryOfTheCounterParty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1(), (Object)o.getBeneficiary1(), this::setBeneficiary1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1IdentifierTypeIndicator(), (Object)o.getBeneficiary1IdentifierTypeIndicator(), this::setBeneficiary1IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBroker(), (Object)o.getBroker(), this::setBroker, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty1(), (Object)o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2OfLeg1(), (Object)o.getDirection2OfLeg1(), this::setDirection2OfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2OfLeg2(), (Object)o.getDirection2OfLeg2(), this::setDirection2OfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingTimestamp(), (Object)o.getClearingTimestamp(), this::setClearingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPlatformIdentifier(), (Object)o.getPlatformIdentifier(), this::setPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalLeg1(), (Object)o.getNotionalLeg1(), this::setNotionalLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalLeg2(), (Object)o.getNotionalLeg2(), this::setNotionalLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityLeg1(), (Object)o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityLeg2(), (Object)o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalQuantityLeg1(), (Object)o.getNotionalQuantityLeg1(), this::setNotionalQuantityLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalQuantityLeg2(), (Object)o.getNotionalQuantityLeg2(), this::setNotionalQuantityLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyLeg1(), (Object)o.getNotionalCurrencyLeg1(), this::setNotionalCurrencyLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyLeg2(), (Object)o.getNotionalCurrencyLeg2(), this::setNotionalCurrencyLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureLeg1(), (Object)o.getQuantityUnitOfMeasureLeg1(), this::setQuantityUnitOfMeasureLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureLeg2(), (Object)o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateLeg1(), (Object)o.getFixedRateLeg1(), this::setFixedRateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateLeg2(), (Object)o.getFixedRateLeg2(), this::setFixedRateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotationLeg1(), (Object)o.getSpreadNotationLeg1(), this::setSpreadNotationLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotationLeg2(), (Object)o.getSpreadNotationLeg2(), this::setSpreadNotationLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadCurrencyLeg1(), (Object)o.getSpreadCurrencyLeg1(), this::setSpreadCurrencyLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadCurrencyLeg2(), (Object)o.getSpreadCurrencyLeg2(), this::setSpreadCurrencyLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumPaymentDate(), (Object)o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountConventionLeg1(), (Object)o.getDayCountConventionLeg1(), this::setDayCountConventionLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountConventionLeg2(), (Object)o.getDayCountConventionLeg2(), this::setDayCountConventionLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentFrequencyPeriodLeg1(), (Object)o.getPaymentFrequencyPeriodLeg1(), this::setPaymentFrequencyPeriodLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentFrequencyPeriodLeg2(), (Object)o.getPaymentFrequencyPeriodLeg2(), this::setPaymentFrequencyPeriodLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentFrequencyPeriodMultiplierLeg1(), (Object)o.getPaymentFrequencyPeriodMultiplierLeg1(), this::setPaymentFrequencyPeriodMultiplierLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentFrequencyPeriodMultiplierLeg2(), (Object)o.getPaymentFrequencyPeriodMultiplierLeg2(), this::setPaymentFrequencyPeriodMultiplierLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrencyLeg1(), (Object)o.getSettlementCurrencyLeg1(), this::setSettlementCurrencyLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrencyLeg2(), (Object)o.getSettlementCurrencyLeg2(), this::setSettlementCurrencyLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentification(), (Object)o.getUnderlyingIdentification(), this::setUnderlyingIdentification, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentificationType(), (Object)o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOther(), (Object)o.getUnderlyingIdOther(), this::setUnderlyingIdOther, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOtherSource(), (Object)o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDateOfTheUnderlying(), (Object)o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndicatorOfTheFloatingRateLeg2(), (Object)o.getIndicatorOfTheFloatingRateLeg2(), this::setIndicatorOfTheFloatingRateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (Object)o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (Object)o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexAttachmentPoint(), (Object)o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexDetachmentPoint(), (Object)o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTI(), (Object)o.getPriorUTI(), this::setPriorUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUtiProprietary(), (Object)o.getPriorUtiProprietary(), this::setPriorUtiProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventIdentifier(), (Object)o.getEventIdentifier(), this::setEventIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNewDerivativeTradeRepository(), (Object)o.getNewDerivativeTradeRepository(), this::setNewDerivativeTradeRepository, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg1(), (Object)o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg2(), (Object)o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideEntityIndicator(), (Object)o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioCodeInitialMargin(), (Object)o.getCollateralPortfolioCodeInitialMargin(), this::setCollateralPortfolioCodeInitialMargin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioCodeVariationMargin(), (Object)o.getCollateralPortfolioCodeVariationMargin(), this::setCollateralPortfolioCodeVariationMargin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty2DTCC(), (Object)o.getExecutionAgentOfCounterparty2DTCC(), this::setExecutionAgentOfCounterparty2DTCC, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICTransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietaryID, _that.getUtiProprietaryID())) {
                return false;
            }
            if (!Objects.equals(this.secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.broker, _that.getBroker())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.direction, _that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.direction2OfLeg1, _that.getDirection2OfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.direction2OfLeg2, _that.getDirection2OfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.clearingTimestamp, _that.getClearingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg1, _that.getNotionalLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg2, _that.getNotionalLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg1, _that.getFixedRateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg2, _that.getFixedRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationLeg1, _that.getSpreadNotationLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadLeg1, _that.getSpreadLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationLeg2, _that.getSpreadNotationLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadLeg2, _that.getSpreadLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.dayCountConventionLeg1, _that.getDayCountConventionLeg1())) {
                return false;
            }
            if (!Objects.equals(this.dayCountConventionLeg2, _that.getDayCountConventionLeg2())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodLeg1, _that.getPaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodLeg2, _that.getPaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodMultiplierLeg1, _that.getPaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodMultiplierLeg2, _that.getPaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentification, _that.getUnderlyingIdentification())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateLeg2, _that.getIndicatorOfTheFloatingRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.priorUtiProprietary, _that.getPriorUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.newDerivativeTradeRepository, _that.getNewDerivativeTradeRepository())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeInitialMargin, _that.getCollateralPortfolioCodeInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeVariationMargin, _that.getCollateralPortfolioCodeVariationMargin())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietaryID != null ? this.utiProprietaryID.hashCode() : 0);
            _result = 31 * _result + (this.secondaryTransactionIdentifier != null ? this.secondaryTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.countryOfTheCounterParty2 != null ? this.countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.broker != null ? this.broker.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? this.direction.hashCode() : 0);
            _result = 31 * _result + (this.direction2OfLeg1 != null ? this.direction2OfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.direction2OfLeg2 != null ? this.direction2OfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.clearingTimestamp != null ? this.clearingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg1 != null ? this.notionalLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg2 != null ? this.notionalLeg2.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg1 != null ? this.totalNotionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityLeg1 != null ? this.notionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityLeg2 != null ? this.notionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyLeg1 != null ? this.notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyLeg2 != null ? this.notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg1 != null ? this.quantityUnitOfMeasureLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1 != null ? this.notionalAmountScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2 != null ? this.notionalAmountScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg1 != null ? this.fixedRateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg2 != null ? this.fixedRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationLeg1 != null ? this.spreadNotationLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadLeg1 != null ? this.spreadLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationLeg2 != null ? this.spreadNotationLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadLeg2 != null ? this.spreadLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrencyLeg1 != null ? this.spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrencyLeg2 != null ? this.spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.dayCountConventionLeg1 != null ? this.dayCountConventionLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountConventionLeg2 != null ? this.dayCountConventionLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodLeg1 != null ? this.paymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodLeg2 != null ? this.paymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodMultiplierLeg1 != null ? this.paymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodMultiplierLeg2 != null ? this.paymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg1 != null ? this.settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg2 != null ? this.settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentification != null ? this.underlyingIdentification.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateLeg2 != null ? this.indicatorOfTheFloatingRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2TimePeriod != null ? this.floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2Multiplier != null ? this.floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.priorUtiProprietary != null ? this.priorUtiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.newDerivativeTradeRepository != null ? this.newDerivativeTradeRepository.hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeInitialMargin != null ? this.collateralPortfolioCodeInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeVariationMargin != null ? this.collateralPortfolioCodeVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty2DTCC != null ? this.executionAgentOfCounterparty2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICTransactionReportBuilder {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", utiProprietaryID=" + this.utiProprietaryID + ", secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", assetClass=" + this.assetClass + ", contractType=" + this.contractType + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", countryOfTheCounterParty2=" + String.valueOf(this.countryOfTheCounterParty2) + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", broker=" + this.broker + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", direction=" + this.direction + ", direction2OfLeg1=" + this.direction2OfLeg1 + ", direction2OfLeg2=" + this.direction2OfLeg2 + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", clearingTimestamp=" + String.valueOf(this.clearingTimestamp) + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", platformIdentifier=" + this.platformIdentifier + ", notionalLeg1=" + String.valueOf(this.notionalLeg1) + ", notionalLeg2=" + String.valueOf(this.notionalLeg2) + ", totalNotionalQuantityLeg1=" + String.valueOf(this.totalNotionalQuantityLeg1) + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", notionalQuantityLeg1=" + String.valueOf(this.notionalQuantityLeg1) + ", notionalQuantityLeg2=" + String.valueOf(this.notionalQuantityLeg2) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalCurrencyLeg1=" + String.valueOf(this.notionalCurrencyLeg1) + ", notionalCurrencyLeg2=" + String.valueOf(this.notionalCurrencyLeg2) + ", quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", notionalAmountScheduleLeg1=" + String.valueOf(this.notionalAmountScheduleLeg1) + ", notionalAmountScheduleLeg2=" + String.valueOf(this.notionalAmountScheduleLeg2) + ", price=" + String.valueOf(this.price) + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", fixedRateLeg1=" + String.valueOf(this.fixedRateLeg1) + ", fixedRateLeg2=" + String.valueOf(this.fixedRateLeg2) + ", spreadNotationLeg1=" + this.spreadNotationLeg1 + ", spreadLeg1=" + String.valueOf(this.spreadLeg1) + ", spreadNotationLeg2=" + this.spreadNotationLeg2 + ", spreadLeg2=" + String.valueOf(this.spreadLeg2) + ", spreadCurrencyLeg1=" + String.valueOf(this.spreadCurrencyLeg1) + ", spreadCurrencyLeg2=" + String.valueOf(this.spreadCurrencyLeg2) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", barrier=" + String.valueOf(this.barrier) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", dayCountConventionLeg1=" + String.valueOf(this.dayCountConventionLeg1) + ", dayCountConventionLeg2=" + String.valueOf(this.dayCountConventionLeg2) + ", paymentFrequencyPeriodLeg1=" + this.paymentFrequencyPeriodLeg1 + ", paymentFrequencyPeriodLeg2=" + this.paymentFrequencyPeriodLeg2 + ", paymentFrequencyPeriodMultiplierLeg1=" + this.paymentFrequencyPeriodMultiplierLeg1 + ", paymentFrequencyPeriodMultiplierLeg2=" + this.paymentFrequencyPeriodMultiplierLeg2 + ", settlementCurrencyLeg1=" + String.valueOf(this.settlementCurrencyLeg1) + ", settlementCurrencyLeg2=" + String.valueOf(this.settlementCurrencyLeg2) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", customBasketCode=" + String.valueOf(this.customBasketCode) + ", basket=" + String.valueOf(this.basket) + ", underlyingIdentification=" + this.underlyingIdentification + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + String.valueOf(this.underlyingIdOtherSource) + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", indicatorOfTheFloatingRateLeg2=" + this.indicatorOfTheFloatingRateLeg2 + ", floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", indexFactor=" + String.valueOf(this.indexFactor) + ", packageIdentifier=" + this.packageIdentifier + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", priorUTI=" + this.priorUTI + ", priorUtiProprietary=" + this.priorUtiProprietary + ", eventIdentifier=" + this.eventIdentifier + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", newDerivativeTradeRepository=" + this.newDerivativeTradeRepository + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", nextFloatingReferenceResetDateLeg1=" + (String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", technicalRecordId=" + this.technicalRecordId + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", collateralPortfolioCodeInitialMargin=" + this.collateralPortfolioCodeInitialMargin + ", collateralPortfolioCodeVariationMargin=" + this.collateralPortfolioCodeVariationMargin + ", executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", nonReportable=" + String.valueOf(this.nonReportable) + "}");
        }
    }

    public static interface ASICTransactionReportBuilder
    extends ASICTransactionReport,
    RosettaModelObjectBuilder {
        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int var1);

        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();

        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int var1);

        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();

        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getPrice();

        public SpreadLeg1.SpreadLeg1Builder getOrCreateSpreadLeg1();

        @Override
        public SpreadLeg1.SpreadLeg1Builder getSpreadLeg1();

        public SpreadLeg2.SpreadLeg2Builder getOrCreateSpreadLeg2();

        @Override
        public SpreadLeg2.SpreadLeg2Builder getSpreadLeg2();

        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();

        public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier();

        @Override
        public BarrierAndNotation.BarrierAndNotationBuilder getBarrier();

        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int var1);

        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();

        public ASICCustomBasket.ASICCustomBasketBuilder getOrCreateCustomBasketCode();

        @Override
        public ASICCustomBasket.ASICCustomBasketBuilder getCustomBasketCode();

        public Basket.BasketBuilder getOrCreateBasket();

        @Override
        public Basket.BasketBuilder getBasket();

        public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice();

        @Override
        public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice();

        public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread();

        @Override
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread();

        public ASICNonReportable.ASICNonReportableBuilder getOrCreateNonReportable();

        @Override
        public ASICNonReportable.ASICNonReportableBuilder getNonReportable();

        public ASICTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        public ASICTransactionReportBuilder setUtiProprietaryID(String var1);

        public ASICTransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        public ASICTransactionReportBuilder setUniqueProductIdentifier(String var1);

        public ASICTransactionReportBuilder setAssetClass(String var1);

        public ASICTransactionReportBuilder setContractType(String var1);

        public ASICTransactionReportBuilder setReportingEntity(String var1);

        public ASICTransactionReportBuilder setCounterparty1(String var1);

        public ASICTransactionReportBuilder setCounterparty2(String var1);

        public ASICTransactionReportBuilder setCounterparty2Name(String var1);

        public ASICTransactionReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean var1);

        public ASICTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum var1);

        public ASICTransactionReportBuilder setBeneficiary1(String var1);

        public ASICTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        public ASICTransactionReportBuilder setBroker(String var1);

        public ASICTransactionReportBuilder setExecutionAgentOfCounterparty1(String var1);

        public ASICTransactionReportBuilder setDirection(String var1);

        public ASICTransactionReportBuilder setDirection2OfLeg1(String var1);

        public ASICTransactionReportBuilder setDirection2OfLeg2(String var1);

        public ASICTransactionReportBuilder setEffectiveDate(Date var1);

        public ASICTransactionReportBuilder setExpirationDate(Date var1);

        public ASICTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        public ASICTransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        public ASICTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        public ASICTransactionReportBuilder setCleared(String var1);

        public ASICTransactionReportBuilder setCentralCounterparty(String var1);

        public ASICTransactionReportBuilder setClearingMember(String var1);

        public ASICTransactionReportBuilder setPlatformIdentifier(String var1);

        public ASICTransactionReportBuilder setNotionalLeg1(BigDecimal var1);

        public ASICTransactionReportBuilder setNotionalLeg2(BigDecimal var1);

        public ASICTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal var1);

        public ASICTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal var1);

        public ASICTransactionReportBuilder setNotionalQuantityLeg1(BigDecimal var1);

        public ASICTransactionReportBuilder setNotionalQuantityLeg2(BigDecimal var1);

        public ASICTransactionReportBuilder setCallAmount(BigDecimal var1);

        public ASICTransactionReportBuilder setPutAmount(BigDecimal var1);

        public ASICTransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String var1);

        public ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String var1);

        public ASICTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report var1);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report var1, int var2);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public ASICTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report var1);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report var1, int var2);

        public ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public ASICTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public ASICTransactionReportBuilder setPrice(PriceAndNotation var1);

        public ASICTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        public ASICTransactionReportBuilder setFixedRateLeg1(BigDecimal var1);

        public ASICTransactionReportBuilder setFixedRateLeg2(BigDecimal var1);

        public ASICTransactionReportBuilder setSpreadNotationLeg1(String var1);

        public ASICTransactionReportBuilder setSpreadLeg1(SpreadLeg1 var1);

        public ASICTransactionReportBuilder setSpreadNotationLeg2(String var1);

        public ASICTransactionReportBuilder setSpreadLeg2(SpreadLeg2 var1);

        public ASICTransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setStrikePrice(StrikePriceAndNotation var1);

        public ASICTransactionReportBuilder setBarrier(BarrierAndNotation var1);

        public ASICTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        public ASICTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        public ASICTransactionReportBuilder setExchangeRate(BigDecimal var1);

        public ASICTransactionReportBuilder setExchangeRateBasis(String var1);

        public ASICTransactionReportBuilder setDayCountConventionLeg1(InterestComputationMethod4Code var1);

        public ASICTransactionReportBuilder setDayCountConventionLeg2(InterestComputationMethod4Code var1);

        public ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg1(String var1);

        public ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg2(String var1);

        public ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg1(Integer var1);

        public ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg2(Integer var1);

        public ASICTransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport var1);

        public ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport var1, int var2);

        public ASICTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> var1);

        public ASICTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> var1);

        public ASICTransactionReportBuilder setCustomBasketCode(ASICCustomBasket var1);

        public ASICTransactionReportBuilder setBasket(Basket var1);

        public ASICTransactionReportBuilder setUnderlyingIdentification(String var1);

        public ASICTransactionReportBuilder setUnderlyingIdentificationType(String var1);

        public ASICTransactionReportBuilder setUnderlyingIdOther(String var1);

        public ASICTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        public ASICTransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        public ASICTransactionReportBuilder setIndicatorOfTheFloatingRateLeg2(String var1);

        public ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String var1);

        public ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer var1);

        public ASICTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        public ASICTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        public ASICTransactionReportBuilder setIndexFactor(BigDecimal var1);

        public ASICTransactionReportBuilder setPackageIdentifier(String var1);

        public ASICTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice var1);

        public ASICTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread var1);

        public ASICTransactionReportBuilder setPriorUTI(String var1);

        public ASICTransactionReportBuilder setPriorUtiProprietary(String var1);

        public ASICTransactionReportBuilder setEventIdentifier(String var1);

        public ASICTransactionReportBuilder setActionType(String var1);

        public ASICTransactionReportBuilder setEventType(String var1);

        public ASICTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public ASICTransactionReportBuilder setReportSubmittingEntityID(String var1);

        public ASICTransactionReportBuilder setNewDerivativeTradeRepository(String var1);

        public ASICTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public ASICTransactionReportBuilder setValuationAmount(BigDecimal var1);

        public ASICTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public ASICTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        public ASICTransactionReportBuilder setDelta(BigDecimal var1);

        public ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        public ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        public ASICTransactionReportBuilder setSmallScaleBuySideEntityIndicator(String var1);

        public ASICTransactionReportBuilder setTechnicalRecordId(String var1);

        public ASICTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        public ASICTransactionReportBuilder setCollateralPortfolioCodeInitialMargin(String var1);

        public ASICTransactionReportBuilder setCollateralPortfolioCodeVariationMargin(String var1);

        public ASICTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String var1);

        public ASICTransactionReportBuilder setNonReportable(ASICNonReportable var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, (Object)this.getUtiProprietaryID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterParty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("broker"), String.class, (Object)this.getBroker(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction"), String.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2OfLeg1"), String.class, (Object)this.getDirection2OfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2OfLeg2"), String.class, (Object)this.getDirection2OfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, (Object)this.getNotionalLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, (Object)this.getNotionalLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, (Object)this.getNotionalQuantityLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, (Object)this.getNotionalQuantityLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, this.getNotionalAmountScheduleLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, this.getNotionalAmountScheduleLeg2(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, (Object)this.getFixedRateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, (Object)this.getFixedRateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, (Object)this.getSpreadNotationLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadLeg1"), processor, SpreadLeg1.SpreadLeg1Builder.class, this.getSpreadLeg1(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, (Object)this.getSpreadNotationLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadLeg2"), processor, SpreadLeg2.SpreadLeg2Builder.class, this.getSpreadLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrencyLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrencyLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.BarrierAndNotationBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountConventionLeg1"), InterestComputationMethod4Code.class, (Object)this.getDayCountConventionLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountConventionLeg2"), InterestComputationMethod4Code.class, (Object)this.getDayCountConventionLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, (Object)this.getPaymentFrequencyPeriodLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, (Object)this.getPaymentFrequencyPeriodLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getPaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getPaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("customBasketCode"), processor, ASICCustomBasket.ASICCustomBasketBuilder.class, this.getCustomBasketCode(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basket"), processor, Basket.BasketBuilder.class, this.getBasket(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateLeg2"), String.class, (Object)this.getIndicatorOfTheFloatingRateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.PackageTransactionPriceBuilder.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.PackageTransactionSpreadBuilder.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, (Object)this.getPriorUtiProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newDerivativeTradeRepository"), String.class, (Object)this.getNewDerivativeTradeRepository(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCodeInitialMargin"), String.class, (Object)this.getCollateralPortfolioCodeInitialMargin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCodeVariationMargin"), String.class, (Object)this.getCollateralPortfolioCodeVariationMargin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, (Object)this.getExecutionAgentOfCounterparty2DTCC(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, ASICNonReportable.ASICNonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
        }

        public ASICTransactionReportBuilder prune();
    }

    public static class ASICTransactionReportImpl
    implements ASICTransactionReport {
        private final String uniqueTransactionIdentifier;
        private final String utiProprietaryID;
        private final String secondaryTransactionIdentifier;
        private final String uniqueProductIdentifier;
        private final String assetClass;
        private final String contractType;
        private final String reportingEntity;
        private final String counterparty1;
        private final String counterparty2;
        private final String counterparty2Name;
        private final Boolean counterparty2IdentifierTypeIndicator;
        private final ISOCountryCodeEnum countryOfTheCounterParty2;
        private final String beneficiary1;
        private final Boolean beneficiary1IdentifierTypeIndicator;
        private final String broker;
        private final String executionAgentOfCounterparty1;
        private final String direction;
        private final String direction2OfLeg1;
        private final String direction2OfLeg2;
        private final Date effectiveDate;
        private final Date expirationDate;
        private final ZonedDateTime executionTimestamp;
        private final ZonedDateTime eventTimestamp;
        private final ZonedDateTime clearingTimestamp;
        private final String cleared;
        private final String centralCounterparty;
        private final String clearingMember;
        private final String platformIdentifier;
        private final BigDecimal notionalLeg1;
        private final BigDecimal notionalLeg2;
        private final BigDecimal totalNotionalQuantityLeg1;
        private final BigDecimal totalNotionalQuantityLeg2;
        private final BigDecimal notionalQuantityLeg1;
        private final BigDecimal notionalQuantityLeg2;
        private final BigDecimal callAmount;
        private final BigDecimal putAmount;
        private final ISOCurrencyCodeEnum notionalCurrencyLeg1;
        private final ISOCurrencyCodeEnum notionalCurrencyLeg2;
        private final String quantityUnitOfMeasureLeg1;
        private final String quantityUnitOfMeasureLeg2;
        private final ISOCurrencyCodeEnum callCurrency;
        private final ISOCurrencyCodeEnum putCurrency;
        private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
        private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
        private final PriceAndNotation price;
        private final String priceUnitOfMeasure;
        private final BigDecimal fixedRateLeg1;
        private final BigDecimal fixedRateLeg2;
        private final String spreadNotationLeg1;
        private final SpreadLeg1 spreadLeg1;
        private final String spreadNotationLeg2;
        private final SpreadLeg2 spreadLeg2;
        private final ISOCurrencyCodeEnum spreadCurrencyLeg1;
        private final ISOCurrencyCodeEnum spreadCurrencyLeg2;
        private final StrikePriceAndNotation strikePrice;
        private final BarrierAndNotation barrier;
        private final BigDecimal optionPremiumAmount;
        private final ISOCurrencyCodeEnum optionPremiumCurrency;
        private final Date optionPremiumPaymentDate;
        private final BigDecimal exchangeRate;
        private final String exchangeRateBasis;
        private final InterestComputationMethod4Code dayCountConventionLeg1;
        private final InterestComputationMethod4Code dayCountConventionLeg2;
        private final String paymentFrequencyPeriodLeg1;
        private final String paymentFrequencyPeriodLeg2;
        private final Integer paymentFrequencyPeriodMultiplierLeg1;
        private final Integer paymentFrequencyPeriodMultiplierLeg2;
        private final ISOCurrencyCodeEnum settlementCurrencyLeg1;
        private final ISOCurrencyCodeEnum settlementCurrencyLeg2;
        private final List<? extends OtherPaymentReport> otherPayment;
        private final ASICCustomBasket customBasketCode;
        private final Basket basket;
        private final String underlyingIdentification;
        private final String underlyingIdentificationType;
        private final String underlyingIdOther;
        private final ProductIdTypeEnum underlyingIdOtherSource;
        private final Date maturityDateOfTheUnderlying;
        private final String indicatorOfTheFloatingRateLeg2;
        private final String floatingRateReferencePeriodOfLeg2TimePeriod;
        private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
        private final BigDecimal cdSIndexAttachmentPoint;
        private final BigDecimal cdSIndexDetachmentPoint;
        private final BigDecimal indexFactor;
        private final String packageIdentifier;
        private final PackageTransactionPrice packageTransactionPrice;
        private final PackageTransactionSpread packageTransactionSpread;
        private final String priorUTI;
        private final String priorUtiProprietary;
        private final String eventIdentifier;
        private final String actionType;
        private final String eventType;
        private final ZonedDateTime reportingTimestamp;
        private final String reportSubmittingEntityID;
        private final String newDerivativeTradeRepository;
        private final ZonedDateTime valuationTimestamp;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final BigDecimal delta;
        private final Date nextFloatingReferenceResetDateLeg1;
        private final Date nextFloatingReferenceResetDateLeg2;
        private final String smallScaleBuySideEntityIndicator;
        private final String technicalRecordId;
        private final Boolean collateralPortfolioIndicator;
        private final String collateralPortfolioCodeInitialMargin;
        private final String collateralPortfolioCodeVariationMargin;
        private final String executionAgentOfCounterparty2DTCC;
        private final ASICNonReportable nonReportable;

        protected ASICTransactionReportImpl(ASICTransactionReportBuilder builder) {
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.utiProprietaryID = builder.getUtiProprietaryID();
            this.secondaryTransactionIdentifier = builder.getSecondaryTransactionIdentifier();
            this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
            this.assetClass = builder.getAssetClass();
            this.contractType = builder.getContractType();
            this.reportingEntity = builder.getReportingEntity();
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2Name = builder.getCounterparty2Name();
            this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
            this.countryOfTheCounterParty2 = builder.getCountryOfTheCounterParty2();
            this.beneficiary1 = builder.getBeneficiary1();
            this.beneficiary1IdentifierTypeIndicator = builder.getBeneficiary1IdentifierTypeIndicator();
            this.broker = builder.getBroker();
            this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
            this.direction = builder.getDirection();
            this.direction2OfLeg1 = builder.getDirection2OfLeg1();
            this.direction2OfLeg2 = builder.getDirection2OfLeg2();
            this.effectiveDate = builder.getEffectiveDate();
            this.expirationDate = builder.getExpirationDate();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.eventTimestamp = builder.getEventTimestamp();
            this.clearingTimestamp = builder.getClearingTimestamp();
            this.cleared = builder.getCleared();
            this.centralCounterparty = builder.getCentralCounterparty();
            this.clearingMember = builder.getClearingMember();
            this.platformIdentifier = builder.getPlatformIdentifier();
            this.notionalLeg1 = builder.getNotionalLeg1();
            this.notionalLeg2 = builder.getNotionalLeg2();
            this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
            this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
            this.notionalQuantityLeg1 = builder.getNotionalQuantityLeg1();
            this.notionalQuantityLeg2 = builder.getNotionalQuantityLeg2();
            this.callAmount = builder.getCallAmount();
            this.putAmount = builder.getPutAmount();
            this.notionalCurrencyLeg1 = builder.getNotionalCurrencyLeg1();
            this.notionalCurrencyLeg2 = builder.getNotionalCurrencyLeg2();
            this.quantityUnitOfMeasureLeg1 = builder.getQuantityUnitOfMeasureLeg1();
            this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
            this.callCurrency = builder.getCallCurrency();
            this.putCurrency = builder.getPutCurrency();
            this.notionalAmountScheduleLeg1 = Optional.ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalAmountScheduleLeg2 = Optional.ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
            this.fixedRateLeg1 = builder.getFixedRateLeg1();
            this.fixedRateLeg2 = builder.getFixedRateLeg2();
            this.spreadNotationLeg1 = builder.getSpreadNotationLeg1();
            this.spreadLeg1 = Optional.ofNullable(builder.getSpreadLeg1()).map(f -> f.build()).orElse(null);
            this.spreadNotationLeg2 = builder.getSpreadNotationLeg2();
            this.spreadLeg2 = Optional.ofNullable(builder.getSpreadLeg2()).map(f -> f.build()).orElse(null);
            this.spreadCurrencyLeg1 = builder.getSpreadCurrencyLeg1();
            this.spreadCurrencyLeg2 = builder.getSpreadCurrencyLeg2();
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).map(f -> f.build()).orElse(null);
            this.optionPremiumAmount = builder.getOptionPremiumAmount();
            this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
            this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
            this.exchangeRate = builder.getExchangeRate();
            this.exchangeRateBasis = builder.getExchangeRateBasis();
            this.dayCountConventionLeg1 = builder.getDayCountConventionLeg1();
            this.dayCountConventionLeg2 = builder.getDayCountConventionLeg2();
            this.paymentFrequencyPeriodLeg1 = builder.getPaymentFrequencyPeriodLeg1();
            this.paymentFrequencyPeriodLeg2 = builder.getPaymentFrequencyPeriodLeg2();
            this.paymentFrequencyPeriodMultiplierLeg1 = builder.getPaymentFrequencyPeriodMultiplierLeg1();
            this.paymentFrequencyPeriodMultiplierLeg2 = builder.getPaymentFrequencyPeriodMultiplierLeg2();
            this.settlementCurrencyLeg1 = builder.getSettlementCurrencyLeg1();
            this.settlementCurrencyLeg2 = builder.getSettlementCurrencyLeg2();
            this.otherPayment = Optional.ofNullable(builder.getOtherPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.customBasketCode = Optional.ofNullable(builder.getCustomBasketCode()).map(f -> f.build()).orElse(null);
            this.basket = Optional.ofNullable(builder.getBasket()).map(f -> f.build()).orElse(null);
            this.underlyingIdentification = builder.getUnderlyingIdentification();
            this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
            this.underlyingIdOther = builder.getUnderlyingIdOther();
            this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
            this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
            this.indicatorOfTheFloatingRateLeg2 = builder.getIndicatorOfTheFloatingRateLeg2();
            this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
            this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
            this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
            this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
            this.indexFactor = builder.getIndexFactor();
            this.packageIdentifier = builder.getPackageIdentifier();
            this.packageTransactionPrice = Optional.ofNullable(builder.getPackageTransactionPrice()).map(f -> f.build()).orElse(null);
            this.packageTransactionSpread = Optional.ofNullable(builder.getPackageTransactionSpread()).map(f -> f.build()).orElse(null);
            this.priorUTI = builder.getPriorUTI();
            this.priorUtiProprietary = builder.getPriorUtiProprietary();
            this.eventIdentifier = builder.getEventIdentifier();
            this.actionType = builder.getActionType();
            this.eventType = builder.getEventType();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.newDerivativeTradeRepository = builder.getNewDerivativeTradeRepository();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.delta = builder.getDelta();
            this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
            this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
            this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.collateralPortfolioCodeInitialMargin = builder.getCollateralPortfolioCodeInitialMargin();
            this.collateralPortfolioCodeVariationMargin = builder.getCollateralPortfolioCodeVariationMargin();
            this.executionAgentOfCounterparty2DTCC = builder.getExecutionAgentOfCounterparty2DTCC();
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public String getUtiProprietaryID() {
            return this.utiProprietaryID;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public String getSecondaryTransactionIdentifier() {
            return this.secondaryTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="reportingEntity")
        @RuneAttribute(value="reportingEntity")
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterParty2")
        @RuneAttribute(value="countryOfTheCounterParty2")
        public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
            return this.countryOfTheCounterParty2;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="broker")
        @RuneAttribute(value="broker")
        public String getBroker() {
            return this.broker;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1")
        @RuneAttribute(value="executionAgentOfCounterparty1")
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public String getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg1")
        @RuneAttribute(value="direction2OfLeg1")
        public String getDirection2OfLeg1() {
            return this.direction2OfLeg1;
        }

        @Override
        @RosettaAttribute(value="direction2OfLeg2")
        @RuneAttribute(value="direction2OfLeg2")
        public String getDirection2OfLeg2() {
            return this.direction2OfLeg2;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ZonedDateTime getClearingTimestamp() {
            return this.clearingTimestamp;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public BigDecimal getNotionalLeg1() {
            return this.notionalLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public BigDecimal getNotionalLeg2() {
            return this.notionalLeg2;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public BigDecimal getTotalNotionalQuantityLeg1() {
            return this.totalNotionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg1")
        @RuneAttribute(value="notionalQuantityLeg1")
        public BigDecimal getNotionalQuantityLeg1() {
            return this.notionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityLeg2")
        @RuneAttribute(value="notionalQuantityLeg2")
        public BigDecimal getNotionalQuantityLeg2() {
            return this.notionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg1")
        @RuneAttribute(value="notionalCurrencyLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
            return this.notionalCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyLeg2")
        @RuneAttribute(value="notionalCurrencyLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
            return this.notionalCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public String getQuantityUnitOfMeasureLeg1() {
            return this.quantityUnitOfMeasureLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
            return this.notionalAmountScheduleLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
            return this.notionalAmountScheduleLeg2;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public BigDecimal getFixedRateLeg1() {
            return this.fixedRateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public BigDecimal getFixedRateLeg2() {
            return this.fixedRateLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg1")
        @RuneAttribute(value="spreadNotationLeg1")
        public String getSpreadNotationLeg1() {
            return this.spreadNotationLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadLeg1")
        @RuneAttribute(value="spreadLeg1")
        public SpreadLeg1 getSpreadLeg1() {
            return this.spreadLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadNotationLeg2")
        @RuneAttribute(value="spreadNotationLeg2")
        public String getSpreadNotationLeg2() {
            return this.spreadNotationLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadLeg2")
        @RuneAttribute(value="spreadLeg2")
        public SpreadLeg2 getSpreadLeg2() {
            return this.spreadLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg1")
        @RuneAttribute(value="spreadCurrencyLeg1")
        public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
            return this.spreadCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadCurrencyLeg2")
        @RuneAttribute(value="spreadCurrencyLeg2")
        public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
            return this.spreadCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public BarrierAndNotation getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg1")
        @RuneAttribute(value="dayCountConventionLeg1")
        public InterestComputationMethod4Code getDayCountConventionLeg1() {
            return this.dayCountConventionLeg1;
        }

        @Override
        @RosettaAttribute(value="dayCountConventionLeg2")
        @RuneAttribute(value="dayCountConventionLeg2")
        public InterestComputationMethod4Code getDayCountConventionLeg2() {
            return this.dayCountConventionLeg2;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodLeg1")
        public String getPaymentFrequencyPeriodLeg1() {
            return this.paymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodLeg2")
        public String getPaymentFrequencyPeriodLeg2() {
            return this.paymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg1")
        public Integer getPaymentFrequencyPeriodMultiplierLeg1() {
            return this.paymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="paymentFrequencyPeriodMultiplierLeg2")
        public Integer getPaymentFrequencyPeriodMultiplierLeg2() {
            return this.paymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
            return this.settlementCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
            return this.settlementCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public ASICCustomBasket getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public Basket getBasket() {
            return this.basket;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public String getUnderlyingIdentification() {
            return this.underlyingIdentification;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ProductIdTypeEnum getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateLeg2")
        public String getIndicatorOfTheFloatingRateLeg2() {
            return this.indicatorOfTheFloatingRateLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg2TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
            return this.floatingRateReferencePeriodOfLeg2Multiplier;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PackageTransactionPrice getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PackageTransactionSpread getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public String getPriorUtiProprietary() {
            return this.priorUtiProprietary;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="newDerivativeTradeRepository")
        @RuneAttribute(value="newDerivativeTradeRepository")
        public String getNewDerivativeTradeRepository() {
            return this.newDerivativeTradeRepository;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeInitialMargin")
        @RuneAttribute(value="collateralPortfolioCodeInitialMargin")
        public String getCollateralPortfolioCodeInitialMargin() {
            return this.collateralPortfolioCodeInitialMargin;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVariationMargin")
        @RuneAttribute(value="collateralPortfolioCodeVariationMargin")
        public String getCollateralPortfolioCodeVariationMargin() {
            return this.collateralPortfolioCodeVariationMargin;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty2DTCC")
        @RuneAttribute(value="executionAgentOfCounterparty2DTCC")
        public String getExecutionAgentOfCounterparty2DTCC() {
            return this.executionAgentOfCounterparty2DTCC;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public ASICNonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public ASICTransactionReport build() {
            return this;
        }

        @Override
        public ASICTransactionReportBuilder toBuilder() {
            ASICTransactionReportBuilder builder = ASICTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICTransactionReportBuilder builder) {
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUtiProprietaryID()).ifPresent(builder::setUtiProprietaryID);
            Optional.ofNullable(this.getSecondaryTransactionIdentifier()).ifPresent(builder::setSecondaryTransactionIdentifier);
            Optional.ofNullable(this.getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractType);
            Optional.ofNullable(this.getReportingEntity()).ifPresent(builder::setReportingEntity);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
            Optional.ofNullable(this.getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
            Optional.ofNullable(this.getCountryOfTheCounterParty2()).ifPresent(builder::setCountryOfTheCounterParty2);
            Optional.ofNullable(this.getBeneficiary1()).ifPresent(builder::setBeneficiary1);
            Optional.ofNullable(this.getBeneficiary1IdentifierTypeIndicator()).ifPresent(builder::setBeneficiary1IdentifierTypeIndicator);
            Optional.ofNullable(this.getBroker()).ifPresent(builder::setBroker);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getDirection2OfLeg1()).ifPresent(builder::setDirection2OfLeg1);
            Optional.ofNullable(this.getDirection2OfLeg2()).ifPresent(builder::setDirection2OfLeg2);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
            Optional.ofNullable(this.getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
            Optional.ofNullable(this.getClearingMember()).ifPresent(builder::setClearingMember);
            Optional.ofNullable(this.getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
            Optional.ofNullable(this.getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
            Optional.ofNullable(this.getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
            Optional.ofNullable(this.getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
            Optional.ofNullable(this.getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
            Optional.ofNullable(this.getNotionalQuantityLeg1()).ifPresent(builder::setNotionalQuantityLeg1);
            Optional.ofNullable(this.getNotionalQuantityLeg2()).ifPresent(builder::setNotionalQuantityLeg2);
            Optional.ofNullable(this.getCallAmount()).ifPresent(builder::setCallAmount);
            Optional.ofNullable(this.getPutAmount()).ifPresent(builder::setPutAmount);
            Optional.ofNullable(this.getNotionalCurrencyLeg1()).ifPresent(builder::setNotionalCurrencyLeg1);
            Optional.ofNullable(this.getNotionalCurrencyLeg2()).ifPresent(builder::setNotionalCurrencyLeg2);
            Optional.ofNullable(this.getQuantityUnitOfMeasureLeg1()).ifPresent(builder::setQuantityUnitOfMeasureLeg1);
            Optional.ofNullable(this.getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
            Optional.ofNullable(this.getCallCurrency()).ifPresent(builder::setCallCurrency);
            Optional.ofNullable(this.getPutCurrency()).ifPresent(builder::setPutCurrency);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
            Optional.ofNullable(this.getFixedRateLeg1()).ifPresent(builder::setFixedRateLeg1);
            Optional.ofNullable(this.getFixedRateLeg2()).ifPresent(builder::setFixedRateLeg2);
            Optional.ofNullable(this.getSpreadNotationLeg1()).ifPresent(builder::setSpreadNotationLeg1);
            Optional.ofNullable(this.getSpreadLeg1()).ifPresent(builder::setSpreadLeg1);
            Optional.ofNullable(this.getSpreadNotationLeg2()).ifPresent(builder::setSpreadNotationLeg2);
            Optional.ofNullable(this.getSpreadLeg2()).ifPresent(builder::setSpreadLeg2);
            Optional.ofNullable(this.getSpreadCurrencyLeg1()).ifPresent(builder::setSpreadCurrencyLeg1);
            Optional.ofNullable(this.getSpreadCurrencyLeg2()).ifPresent(builder::setSpreadCurrencyLeg2);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
            Optional.ofNullable(this.getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
            Optional.ofNullable(this.getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
            Optional.ofNullable(this.getDayCountConventionLeg1()).ifPresent(builder::setDayCountConventionLeg1);
            Optional.ofNullable(this.getDayCountConventionLeg2()).ifPresent(builder::setDayCountConventionLeg2);
            Optional.ofNullable(this.getPaymentFrequencyPeriodLeg1()).ifPresent(builder::setPaymentFrequencyPeriodLeg1);
            Optional.ofNullable(this.getPaymentFrequencyPeriodLeg2()).ifPresent(builder::setPaymentFrequencyPeriodLeg2);
            Optional.ofNullable(this.getPaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg1);
            Optional.ofNullable(this.getPaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg2);
            Optional.ofNullable(this.getSettlementCurrencyLeg1()).ifPresent(builder::setSettlementCurrencyLeg1);
            Optional.ofNullable(this.getSettlementCurrencyLeg2()).ifPresent(builder::setSettlementCurrencyLeg2);
            Optional.ofNullable(this.getOtherPayment()).ifPresent(builder::setOtherPayment);
            Optional.ofNullable(this.getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
            Optional.ofNullable(this.getBasket()).ifPresent(builder::setBasket);
            Optional.ofNullable(this.getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
            Optional.ofNullable(this.getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
            Optional.ofNullable(this.getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
            Optional.ofNullable(this.getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
            Optional.ofNullable(this.getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
            Optional.ofNullable(this.getIndicatorOfTheFloatingRateLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateLeg2);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
            Optional.ofNullable(this.getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
            Optional.ofNullable(this.getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
            Optional.ofNullable(this.getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
            Optional.ofNullable(this.getPriorUTI()).ifPresent(builder::setPriorUTI);
            Optional.ofNullable(this.getPriorUtiProprietary()).ifPresent(builder::setPriorUtiProprietary);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getNewDerivativeTradeRepository()).ifPresent(builder::setNewDerivativeTradeRepository);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getCollateralPortfolioCodeInitialMargin()).ifPresent(builder::setCollateralPortfolioCodeInitialMargin);
            Optional.ofNullable(this.getCollateralPortfolioCodeVariationMargin()).ifPresent(builder::setCollateralPortfolioCodeVariationMargin);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty2DTCC()).ifPresent(builder::setExecutionAgentOfCounterparty2DTCC);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICTransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietaryID, _that.getUtiProprietaryID())) {
                return false;
            }
            if (!Objects.equals(this.secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.broker, _that.getBroker())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.direction, _that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.direction2OfLeg1, _that.getDirection2OfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.direction2OfLeg2, _that.getDirection2OfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.clearingTimestamp, _that.getClearingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg1, _that.getNotionalLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg2, _that.getNotionalLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg1, _that.getFixedRateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg2, _that.getFixedRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationLeg1, _that.getSpreadNotationLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadLeg1, _that.getSpreadLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationLeg2, _that.getSpreadNotationLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadLeg2, _that.getSpreadLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.dayCountConventionLeg1, _that.getDayCountConventionLeg1())) {
                return false;
            }
            if (!Objects.equals(this.dayCountConventionLeg2, _that.getDayCountConventionLeg2())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodLeg1, _that.getPaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodLeg2, _that.getPaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodMultiplierLeg1, _that.getPaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequencyPeriodMultiplierLeg2, _that.getPaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentification, _that.getUnderlyingIdentification())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateLeg2, _that.getIndicatorOfTheFloatingRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.priorUtiProprietary, _that.getPriorUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.newDerivativeTradeRepository, _that.getNewDerivativeTradeRepository())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeInitialMargin, _that.getCollateralPortfolioCodeInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeVariationMargin, _that.getCollateralPortfolioCodeVariationMargin())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietaryID != null ? this.utiProprietaryID.hashCode() : 0);
            _result = 31 * _result + (this.secondaryTransactionIdentifier != null ? this.secondaryTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.countryOfTheCounterParty2 != null ? this.countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.broker != null ? this.broker.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? this.direction.hashCode() : 0);
            _result = 31 * _result + (this.direction2OfLeg1 != null ? this.direction2OfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.direction2OfLeg2 != null ? this.direction2OfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.clearingTimestamp != null ? this.clearingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg1 != null ? this.notionalLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg2 != null ? this.notionalLeg2.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg1 != null ? this.totalNotionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityLeg1 != null ? this.notionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityLeg2 != null ? this.notionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyLeg1 != null ? this.notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyLeg2 != null ? this.notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg1 != null ? this.quantityUnitOfMeasureLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1 != null ? this.notionalAmountScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2 != null ? this.notionalAmountScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg1 != null ? this.fixedRateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg2 != null ? this.fixedRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationLeg1 != null ? this.spreadNotationLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadLeg1 != null ? this.spreadLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationLeg2 != null ? this.spreadNotationLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadLeg2 != null ? this.spreadLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrencyLeg1 != null ? this.spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrencyLeg2 != null ? this.spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.dayCountConventionLeg1 != null ? this.dayCountConventionLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountConventionLeg2 != null ? this.dayCountConventionLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodLeg1 != null ? this.paymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodLeg2 != null ? this.paymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodMultiplierLeg1 != null ? this.paymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequencyPeriodMultiplierLeg2 != null ? this.paymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg1 != null ? this.settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg2 != null ? this.settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentification != null ? this.underlyingIdentification.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateLeg2 != null ? this.indicatorOfTheFloatingRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2TimePeriod != null ? this.floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2Multiplier != null ? this.floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.priorUtiProprietary != null ? this.priorUtiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.newDerivativeTradeRepository != null ? this.newDerivativeTradeRepository.hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeInitialMargin != null ? this.collateralPortfolioCodeInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeVariationMargin != null ? this.collateralPortfolioCodeVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty2DTCC != null ? this.executionAgentOfCounterparty2DTCC.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICTransactionReport {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", utiProprietaryID=" + this.utiProprietaryID + ", secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", assetClass=" + this.assetClass + ", contractType=" + this.contractType + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", countryOfTheCounterParty2=" + String.valueOf(this.countryOfTheCounterParty2) + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", broker=" + this.broker + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", direction=" + this.direction + ", direction2OfLeg1=" + this.direction2OfLeg1 + ", direction2OfLeg2=" + this.direction2OfLeg2 + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", clearingTimestamp=" + String.valueOf(this.clearingTimestamp) + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", platformIdentifier=" + this.platformIdentifier + ", notionalLeg1=" + String.valueOf(this.notionalLeg1) + ", notionalLeg2=" + String.valueOf(this.notionalLeg2) + ", totalNotionalQuantityLeg1=" + String.valueOf(this.totalNotionalQuantityLeg1) + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", notionalQuantityLeg1=" + String.valueOf(this.notionalQuantityLeg1) + ", notionalQuantityLeg2=" + String.valueOf(this.notionalQuantityLeg2) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalCurrencyLeg1=" + String.valueOf(this.notionalCurrencyLeg1) + ", notionalCurrencyLeg2=" + String.valueOf(this.notionalCurrencyLeg2) + ", quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", notionalAmountScheduleLeg1=" + String.valueOf(this.notionalAmountScheduleLeg1) + ", notionalAmountScheduleLeg2=" + String.valueOf(this.notionalAmountScheduleLeg2) + ", price=" + String.valueOf(this.price) + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", fixedRateLeg1=" + String.valueOf(this.fixedRateLeg1) + ", fixedRateLeg2=" + String.valueOf(this.fixedRateLeg2) + ", spreadNotationLeg1=" + this.spreadNotationLeg1 + ", spreadLeg1=" + String.valueOf(this.spreadLeg1) + ", spreadNotationLeg2=" + this.spreadNotationLeg2 + ", spreadLeg2=" + String.valueOf(this.spreadLeg2) + ", spreadCurrencyLeg1=" + String.valueOf(this.spreadCurrencyLeg1) + ", spreadCurrencyLeg2=" + String.valueOf(this.spreadCurrencyLeg2) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", barrier=" + String.valueOf(this.barrier) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", dayCountConventionLeg1=" + String.valueOf(this.dayCountConventionLeg1) + ", dayCountConventionLeg2=" + String.valueOf(this.dayCountConventionLeg2) + ", paymentFrequencyPeriodLeg1=" + this.paymentFrequencyPeriodLeg1 + ", paymentFrequencyPeriodLeg2=" + this.paymentFrequencyPeriodLeg2 + ", paymentFrequencyPeriodMultiplierLeg1=" + this.paymentFrequencyPeriodMultiplierLeg1 + ", paymentFrequencyPeriodMultiplierLeg2=" + this.paymentFrequencyPeriodMultiplierLeg2 + ", settlementCurrencyLeg1=" + String.valueOf(this.settlementCurrencyLeg1) + ", settlementCurrencyLeg2=" + String.valueOf(this.settlementCurrencyLeg2) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", customBasketCode=" + String.valueOf(this.customBasketCode) + ", basket=" + String.valueOf(this.basket) + ", underlyingIdentification=" + this.underlyingIdentification + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + String.valueOf(this.underlyingIdOtherSource) + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", indicatorOfTheFloatingRateLeg2=" + this.indicatorOfTheFloatingRateLeg2 + ", floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", indexFactor=" + String.valueOf(this.indexFactor) + ", packageIdentifier=" + this.packageIdentifier + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", priorUTI=" + this.priorUTI + ", priorUtiProprietary=" + this.priorUtiProprietary + ", eventIdentifier=" + this.eventIdentifier + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", newDerivativeTradeRepository=" + this.newDerivativeTradeRepository + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", nextFloatingReferenceResetDateLeg1=" + (String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", technicalRecordId=" + this.technicalRecordId + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", collateralPortfolioCodeInitialMargin=" + this.collateralPortfolioCodeInitialMargin + ", collateralPortfolioCodeVariationMargin=" + this.collateralPortfolioCodeVariationMargin + ", executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", nonReportable=" + String.valueOf(this.nonReportable) + "}");
        }
    }
}

