/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.Notional;
import drr.regulation.common.functions.PayoutLeg2;
import drr.regulation.common.functions.TradableProductForEvent;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyLeg2RuleDefault.class)
public abstract class NotionalCurrencyLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected Notional notional;
    @Inject
    protected PayoutLeg2 payoutLeg2;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrencyLeg2RuleDefault
    extends NotionalCurrencyLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(reportableEvent -> {
                Boolean _boolean = this.isActionTypeTERM.evaluate((ReportableEvent)thenArg0.get());
                MapperS _thenArg0 = _boolean != null && _boolean != false ? MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)thenArg0.get())).map("getTradableProduct", trade -> trade.getTradableProduct()) : MapperS.of((Object)this.tradableProductForEvent.evaluate((ReportableEvent)thenArg0.get()));
                MapperS _thenArg1 = _thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.payoutLeg2.evaluate((Product)item.map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), (TradeLot)item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ReportableInformation)reportableEvent.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
                return _thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.notional.evaluate((PayoutLegWithAuxiliary)item.get())).map("getUnit", measure -> measure.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

