/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.standards.iosco.cde.reports.CDESpreadLeg1CurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadCurrencyLeg1RuleDefault.class)
public abstract class SpreadCurrencyLeg1Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CDESpreadLeg1CurrencyRule cDESpreadLeg1CurrencyRule;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadCurrencyLeg1RuleDefault
    extends SpreadCurrencyLeg1Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                String string = this.cDESpreadLeg1CurrencyRule.evaluate((TransactionReportInstruction)item.get());
                return string == null ? MapperS.ofNull() : MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build());
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

