/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.reports;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.reports.CDEDayCountConventionRule;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateDayCountConventionLeg2RuleDefault.class)
public abstract class FloatingRateDayCountConventionLeg2Rule
implements ReportFunction<TransactionReportInstruction, InterestComputationMethod4Code> {
    @Inject
    protected CDEDayCountConventionRule cDEDayCountConventionRule;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;

    public InterestComputationMethod4Code evaluate(TransactionReportInstruction input) {
        InterestComputationMethod4Code output = this.doEvaluate(input);
        return output;
    }

    protected abstract InterestComputationMethod4Code doEvaluate(TransactionReportInstruction var1);

    public static class FloatingRateDayCountConventionLeg2RuleDefault
    extends FloatingRateDayCountConventionLeg2Rule {
        @Override
        protected InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input) {
            InterestComputationMethod4Code output = null;
            return this.assignOutput(output, input);
        }

        protected InterestComputationMethod4Code assignOutput(InterestComputationMethod4Code output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.interestRateLeg2.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.filterSingleNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
            output = (InterestComputationMethod4Code)thenArg3.mapSingleToItem(item -> MapperS.of((Object)this.cDEDayCountConventionRule.evaluate((InterestRatePayout)item.get()))).get();
            return output;
        }
    }
}

