/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FinancialSectorEnum")
public enum FinancialSectorEnum {
    INVF("INVF", null),
    CDTI("CDTI", null),
    INUN("INUN", null),
    UCIT("UCIT", null),
    ORPI("ORPI", null),
    AIFD("AIFD", null),
    CSDS("CSDS", null);

    private static Map<String, FinancialSectorEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FinancialSectorEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FinancialSectorEnum fromDisplayName(String name) {
        FinancialSectorEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FinancialSectorEnum> map = new ConcurrentHashMap<String, FinancialSectorEnum>();
        for (FinancialSectorEnum instance : FinancialSectorEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

