/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.RegimeReportingSide;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportableValuation;
import drr.regulation.common.ValuationDetails;
import drr.regulation.common.meta.RegimeReportableValuationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegimeReportableValuation", builder=RegimeReportableValuationBuilderImpl.class, version="5.58.0")
@RuneDataType(value="RegimeReportableValuation", model="drr", builder=RegimeReportableValuationBuilderImpl.class, version="5.58.0")
public interface RegimeReportableValuation
extends ReportableValuation {
    public static final RegimeReportableValuationMeta metaData = new RegimeReportableValuationMeta();

    public List<? extends RegimeReportingSide> getRegimeReportingSide();

    @Override
    public RegimeReportableValuation build();

    @Override
    public RegimeReportableValuationBuilder toBuilder();

    public static RegimeReportableValuationBuilder builder() {
        return new RegimeReportableValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends RegimeReportableValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegimeReportableValuation> getType() {
        return RegimeReportableValuation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.class, this.getValuationDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
    }

    public static class RegimeReportableValuationBuilderImpl
    extends ReportableValuation.ReportableValuationBuilderImpl
    implements RegimeReportableValuationBuilder {
        protected List<RegimeReportingSide.RegimeReportingSideBuilder> regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int index) {
            if (this.regimeReportingSide == null) {
                this.regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();
            }
            return (RegimeReportingSide.RegimeReportingSideBuilder)this.getIndex(this.regimeReportingSide, index, () -> {
                RegimeReportingSide.RegimeReportingSideBuilder newRegimeReportingSide = RegimeReportingSide.builder();
                return newRegimeReportingSide;
            });
        }

        @Override
        @RosettaAttribute(value="valuationDetails")
        @RuneAttribute(value="valuationDetails")
        public RegimeReportableValuationBuilder setValuationDetails(ValuationDetails _valuationDetails) {
            this.valuationDetails = _valuationDetails == null ? null : _valuationDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public RegimeReportableValuationBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableValuationBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide) {
            if (_regimeReportingSide != null) {
                this.regimeReportingSide.add(_regimeReportingSide.toBuilder());
            }
            return this;
        }

        @Override
        public RegimeReportableValuationBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide, int idx) {
            this.getIndex(this.regimeReportingSide, idx, () -> _regimeReportingSide.toBuilder());
            return this;
        }

        @Override
        public RegimeReportableValuationBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            if (regimeReportingSides != null) {
                for (RegimeReportingSide regimeReportingSide : regimeReportingSides) {
                    this.regimeReportingSide.add(regimeReportingSide.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableValuationBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            this.regimeReportingSide = regimeReportingSides == null ? new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>() : (List)regimeReportingSides.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegimeReportableValuation build() {
            return new RegimeReportableValuationImpl(this);
        }

        @Override
        public RegimeReportableValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimeReportableValuationBuilder prune() {
            super.prune();
            this.regimeReportingSide = this.regimeReportingSide.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRegimeReportingSide() != null && this.getRegimeReportingSide().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegimeReportableValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegimeReportableValuationBuilder o = (RegimeReportableValuationBuilder)other;
            merger.mergeRosetta(this.getRegimeReportingSide(), o.getRegimeReportingSide(), this::getOrCreateRegimeReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableValuation _that = (RegimeReportableValuation)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableValuationBuilder {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }

    public static interface RegimeReportableValuationBuilder
    extends RegimeReportableValuation,
    ReportableValuation.ReportableValuationBuilder {
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int var1);

        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide();

        @Override
        public RegimeReportableValuationBuilder setValuationDetails(ValuationDetails var1);

        @Override
        public RegimeReportableValuationBuilder setReportableInformation(ReportableInformation var1);

        public RegimeReportableValuationBuilder addRegimeReportingSide(RegimeReportingSide var1);

        public RegimeReportableValuationBuilder addRegimeReportingSide(RegimeReportingSide var1, int var2);

        public RegimeReportableValuationBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        public RegimeReportableValuationBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.ValuationDetailsBuilder.class, (RosettaModelObjectBuilder)this.getValuationDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.RegimeReportingSideBuilder.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public RegimeReportableValuationBuilder prune();
    }

    public static class RegimeReportableValuationImpl
    extends ReportableValuation.ReportableValuationImpl
    implements RegimeReportableValuation {
        private final List<? extends RegimeReportingSide> regimeReportingSide;

        protected RegimeReportableValuationImpl(RegimeReportableValuationBuilder builder) {
            super(builder);
            this.regimeReportingSide = Optional.ofNullable(builder.getRegimeReportingSide()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportableValuation build() {
            return this;
        }

        @Override
        public RegimeReportableValuationBuilder toBuilder() {
            RegimeReportableValuationBuilder builder = RegimeReportableValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimeReportableValuationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRegimeReportingSide()).ifPresent(builder::setRegimeReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableValuation _that = (RegimeReportableValuation)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableValuation {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }
}

