/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquityForward;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsCommodityForward;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsEquitySwap;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Contract_Price_MonetaryDefault.class)
public abstract class Contract_Price_Monetary
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected IsCommodityForward isCommodityForward;
    @Inject
    protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
    @Inject
    protected IsEquitySwap isEquitySwap;
    @Inject
    protected IsProductETD isProductETD;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_BaseProduct_EquityForward qualify_BaseProduct_EquityForward;
    @Inject
    protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public List<? extends PriceSchedule> evaluate(ReportableEvent reportableEvent) {
        List prices;
        List<PriceSchedule.PriceScheduleBuilder> pricesBuilder = this.doEvaluate(reportableEvent);
        if (pricesBuilder == null) {
            prices = null;
        } else {
            prices = pricesBuilder.stream().map(PriceSchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceSchedule.class, prices);
        }
        return prices;
    }

    protected abstract List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends TradableProduct> tradableProduct(ReportableEvent var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent var1);

    public static class Contract_Price_MonetaryDefault
    extends Contract_Price_Monetary {
        @Override
        protected List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEvent reportableEvent) {
            ArrayList<PriceSchedule.PriceScheduleBuilder> prices = new ArrayList<PriceSchedule.PriceScheduleBuilder>();
            return this.assignOutput(prices, reportableEvent);
        }

        protected List<PriceSchedule.PriceScheduleBuilder> assignOutput(List<PriceSchedule.PriceScheduleBuilder> prices, ReportableEvent reportableEvent) {
            Boolean boolean0 = this.isEquitySwap.evaluate((TradableProduct)this.tradableProduct(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((PerformancePayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    prices.addAll(this.toBuilder(MapperS.of((Object)((PerformancePayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial()).getMulti()));
                } else {
                    prices.addAll(this.toBuilder(this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                }
            } else if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_BaseProduct_EquityForward.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isTotalReturnSwapDebtUnderlier.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_InterestRate_Forward_Debt.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                prices.addAll(this.toBuilder(this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((ProductTaxonomy)MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getIndex", product -> product.getIndex()).mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).get())).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum0 -> fieldWithMetaAssetClassEnum0 == null ? null : fieldWithMetaAssetClassEnum0.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((ProductTaxonomy)MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getSecurity", product -> product.getSecurity()).mapC("getProductTaxonomy", security -> security.getProductTaxonomy()).get())).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum1 -> fieldWithMetaAssetClassEnum1 == null ? null : fieldWithMetaAssetClassEnum1.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((ProductTaxonomy)MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getBasket", product -> product.getBasket()).mapC("getProductTaxonomy", basket -> basket.getProductTaxonomy()).get())).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum2 -> fieldWithMetaAssetClassEnum2 == null ? null : fieldWithMetaAssetClassEnum2.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                prices.addAll(this.toBuilder(MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.onlyExists((Mapper)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout")).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isProductETD.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                prices.addAll(this.toBuilder(this.tradableProduct(reportableEvent).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
            } else {
                Boolean boolean1 = this.isCommoditySwapFixedFloat.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    prices.addAll(this.toBuilder(MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()).getMulti()));
                } else {
                    Boolean boolean2 = this.isCommodityForward.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
                    if (boolean2 != null && boolean2.booleanValue()) {
                        prices.addAll(this.toBuilder(MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).getMulti()));
                    } else {
                        prices.addAll(this.toBuilder(Collections.emptyList()));
                    }
                }
            }
            return Optional.ofNullable(prices).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends TradableProduct> tradableProduct(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.tradableProductForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.tradableProduct(reportableEvent).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()));
        }
    }
}

