/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeEROR;
import drr.regulation.common.functions.IsActionTypeMODI;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsActionTypePOSC;
import drr.regulation.common.functions.IsActionTypePositionMODI;
import drr.regulation.common.functions.IsActionTypeREVI;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsActionTypeVALU;
import javax.inject.Inject;

@ImplementedBy(value=GetActionTypeDefault.class)
public abstract class GetActionType
implements RosettaFunction {
    @Inject
    protected IsActionTypeCORR isActionTypeCORR;
    @Inject
    protected IsActionTypeEROR isActionTypeEROR;
    @Inject
    protected IsActionTypeMODI isActionTypeMODI;
    @Inject
    protected IsActionTypeNEWT isActionTypeNEWT;
    @Inject
    protected IsActionTypePOSC isActionTypePOSC;
    @Inject
    protected IsActionTypePositionMODI isActionTypePositionMODI;
    @Inject
    protected IsActionTypeREVI isActionTypeREVI;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsActionTypeVALU isActionTypeVALU;

    public String evaluate(ReportableEvent reportableEvent) {
        String action = this.doEvaluate(reportableEvent);
        return action;
    }

    protected abstract String doEvaluate(ReportableEvent var1);

    public static class GetActionTypeDefault
    extends GetActionType {
        @Override
        protected String doEvaluate(ReportableEvent reportableEvent) {
            String action = null;
            return this.assignOutput(action, reportableEvent);
        }

        protected String assignOutput(String action, ReportableEvent reportableEvent) {
            Boolean boolean8;
            Boolean boolean7;
            Boolean boolean6;
            Boolean boolean5;
            Boolean boolean4;
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0 = this.isActionTypeCORR.evaluate(reportableEvent);
            action = boolean0 != null && boolean0 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.CORR)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean1 = this.isActionTypeEROR.evaluate(reportableEvent)) != null && boolean1 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.EROR)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean2 = this.isActionTypeREVI.evaluate(reportableEvent)) != null && boolean2 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.REVI)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean3 = this.isActionTypeVALU.evaluate(reportableEvent)) != null && boolean3 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.VALU)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean4 = this.isActionTypeTERM.evaluate(reportableEvent)) != null && boolean4 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.TERM)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean5 = this.isActionTypeMODI.evaluate(reportableEvent)) != null && boolean5 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.MODI)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean6 = this.isActionTypePositionMODI.evaluate(reportableEvent)) != null && boolean6 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.MODI)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean7 = this.isActionTypePOSC.evaluate(reportableEvent)) != null && boolean7 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.POSC)).map("to-string", ActionTypeEnum::toDisplayString).get() : ((boolean8 = this.isActionTypeNEWT.evaluate(reportableEvent)) != null && boolean8 != false ? (String)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)).map("to-string", ActionTypeEnum::toDisplayString).get() : "ToDo"))))))));
            return action;
        }
    }
}

