/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=GetRegimeSpecificIdentifiersDefault.class)
public abstract class GetRegimeSpecificIdentifiers
implements RosettaFunction {
    public List<String> evaluate(ReportableInformation reportableInformation, SupervisoryBodyEnum supervisoryBody, TradeIdentifierTypeEnum tradeIdentifierType) {
        List<String> regimeSpecificIdentifiers = this.doEvaluate(reportableInformation, supervisoryBody, tradeIdentifierType);
        return regimeSpecificIdentifiers;
    }

    protected abstract List<String> doEvaluate(ReportableInformation var1, SupervisoryBodyEnum var2, TradeIdentifierTypeEnum var3);

    protected abstract MapperC<? extends TradeIdentifier> regimeTransactionIds(ReportableInformation var1, SupervisoryBodyEnum var2, TradeIdentifierTypeEnum var3);

    public static class GetRegimeSpecificIdentifiersDefault
    extends GetRegimeSpecificIdentifiers {
        @Override
        protected List<String> doEvaluate(ReportableInformation reportableInformation, SupervisoryBodyEnum supervisoryBody, TradeIdentifierTypeEnum tradeIdentifierType) {
            ArrayList<String> regimeSpecificIdentifiers = new ArrayList<String>();
            return this.assignOutput(regimeSpecificIdentifiers, reportableInformation, supervisoryBody, tradeIdentifierType);
        }

        protected List<String> assignOutput(List<String> regimeSpecificIdentifiers, ReportableInformation reportableInformation, SupervisoryBodyEnum supervisoryBody, TradeIdentifierTypeEnum tradeIdentifierType) {
            if (ExpressionOperatorsNullSafe.exists(this.regimeTransactionIds(reportableInformation, supervisoryBody, tradeIdentifierType)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                regimeSpecificIdentifiers.addAll(this.regimeTransactionIds(reportableInformation, supervisoryBody, tradeIdentifierType).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else {
                regimeSpecificIdentifiers.addAll(Collections.emptyList());
            }
            return regimeSpecificIdentifiers;
        }

        @Override
        protected MapperC<? extends TradeIdentifier> regimeTransactionIds(ReportableInformation reportableInformation, SupervisoryBodyEnum supervisoryBody, TradeIdentifierTypeEnum tradeIdentifierType) {
            MapperC thenArg0 = MapperS.of((Object)reportableInformation).mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSupervisoryBody", transactionInformation -> transactionInformation.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), (Mapper)MapperS.of((Object)((Object)supervisoryBody)), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg1.map("getTransactionIdentifier", transactionInformation -> transactionInformation.getTransactionIdentifier()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)tradeIdentifierType), (CardinalityOperator)CardinalityOperator.All).get());
        }
    }
}

