/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetLeg2ResolvablePriceQuantity;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableQuantityPeriodLeg2Default.class)
public abstract class GetReportableQuantityPeriodLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;

    public List<? extends QuantityReportablePeriod> evaluate(Trade trade) {
        List reportablePeriod;
        List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(trade);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantityReportablePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade var1);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(Trade var1);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade var1);

    public static class GetReportableQuantityPeriodLeg2Default
    extends GetReportableQuantityPeriodLeg2 {
        @Override
        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade trade) {
            ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod = new ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder>();
            return this.assignOutput(reportablePeriod, trade);
        }

        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod, Trade trade) {
            if (ExpressionOperatorsNullSafe.exists(this.customizedSchedule(trade)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                reportablePeriod.addAll(this.toBuilder(this.quantitySchedule(trade).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).mapItem(quantityPeriod -> {
                    MapperC thenArg0 = this.customizedSchedule(trade).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).filterItemNullSafe(customPeriod -> ExpressionOperatorsNullSafe.areEqual((Mapper)quantityPeriod.map("getDate", datedValue -> datedValue.getDate()), (Mapper)customPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                    MapperS thenArg1 = MapperS.of((Object)((SchedulePeriod)thenArg0.get()));
                    return thenArg1.mapSingleToItem(matchingCustomPeriod -> MapperS.of((Object)QuantityReportablePeriod.builder().setPeriodValue((BigDecimal)quantityPeriod.map("getValue", datedValue -> datedValue.getValue()).get()).setPeriodEffectiveDate((Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).get()).setPeriodEndDate((Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).get()).build()));
                }).getMulti()));
            } else {
                reportablePeriod.addAll(this.toBuilder(this.quantitySchedule(trade).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).mapItem(quantityPeriod -> MapperS.of((Object)QuantityReportablePeriod.builder().setPeriodValue((BigDecimal)quantityPeriod.map("getValue", datedValue -> datedValue.getValue()).get()).setPeriodEffectiveDate((Date)quantityPeriod.map("getDate", datedValue -> datedValue.getDate()).get()).setPeriodEndDate(null).build())).getMulti()));
            }
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade) {
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.commodityLeg2.evaluate(this.productForTrade.evaluate(trade))).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            Boolean boolean0 = this.isSingleCommodityPayoutProduct.evaluate(this.productForTrade.evaluate(trade));
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            Boolean boolean1 = this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)));
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade) {
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.getLeg2ResolvablePriceQuantity.evaluate(trade)).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            }
            return MapperS.ofNull();
        }
    }
}

