/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.functions.GetVenueOfExecution;
import drr.regulation.common.functions.IsESMAThirdCountryEquivalentMarket;
import drr.regulation.common.functions.IsFCAThirdCountryEquivalentMarket;
import drr.standards.iso.MicData;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.functions.GetOrFetchMicData;
import javax.inject.Inject;

@ImplementedBy(value=IsRegulatedMarketOrThirdCountryEquivalentMarketDefault.class)
public abstract class IsRegulatedMarketOrThirdCountryEquivalentMarket
implements RosettaFunction {
    @Inject
    protected GetOrFetchMicData getOrFetchMicData;
    @Inject
    protected GetVenueOfExecution getVenueOfExecution;
    @Inject
    protected IsESMAThirdCountryEquivalentMarket isESMAThirdCountryEquivalentMarket;
    @Inject
    protected IsFCAThirdCountryEquivalentMarket isFCAThirdCountryEquivalentMarket;

    public Boolean evaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
        Boolean result = this.doEvaluate(reportableInformation, regime);
        return result;
    }

    protected abstract Boolean doEvaluate(ReportableInformation var1, RegimeNameEnum var2);

    protected abstract MapperS<? extends MicData> getMic(ReportableInformation var1, RegimeNameEnum var2);

    public static class IsRegulatedMarketOrThirdCountryEquivalentMarketDefault
    extends IsRegulatedMarketOrThirdCountryEquivalentMarket {
        @Override
        protected Boolean doEvaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
            Boolean result = null;
            return this.assignOutput(result, reportableInformation, regime);
        }

        protected Boolean assignOutput(Boolean result, ReportableInformation reportableInformation, RegimeNameEnum regime) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.EMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)this.getMic(reportableInformation, regime).map("getMarketCategoryEsma", micData -> micData.getMarketCategoryEsma()), (Mapper)MapperS.of((Object)((Object)MicMarketCategoryEnum.RMKT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isESMAThirdCountryEquivalentMarket.evaluate((String)this.getMic(reportableInformation, regime).map("getMic", micData -> micData.getMic()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).get() : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)this.getMic(reportableInformation, regime).map("getMarketCategoryFca", micData -> micData.getMarketCategoryFca()), (Mapper)MapperS.of((Object)((Object)MicMarketCategoryEnum.RMKT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isFCAThirdCountryEquivalentMarket.evaluate((String)this.getMic(reportableInformation, regime).map("getMic", micData -> micData.getMic()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).get() : null);
            return result;
        }

        @Override
        protected MapperS<? extends MicData> getMic(ReportableInformation reportableInformation, RegimeNameEnum regime) {
            return MapperS.of((Object)this.getOrFetchMicData.evaluate(MapperS.of((Object)reportableInformation).map("getEnrichment", _reportableInformation -> _reportableInformation.getEnrichment()).mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), this.getVenueOfExecution.evaluate(reportableInformation)));
        }
    }
}

