/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=OtherPaymentAmountRuleDefault.class)
public abstract class OtherPaymentAmountRule
implements ReportFunction<TransferState, BigDecimal> {
    @Inject
    protected CDEOtherPaymentAmountRule cDEOtherPaymentAmountRule;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected IsOtherPayment isOtherPayment;
    @Inject
    protected RoundToPrecision roundToPrecision;

    public BigDecimal evaluate(TransferState input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransferState var1);

    public static class OtherPaymentAmountRuleDefault
    extends OtherPaymentAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransferState input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransferState input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isOtherPayment.evaluate((TransferState)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.cDEOtherPaymentAmountRule.evaluate((TransferState)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.roundToPrecision.evaluate((BigDecimal)item.get(), Integer.valueOf(5), RoundingDirectionEnum.NEAREST)));
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

