/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsPriceMonetary;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.reports.CDESpread_CommodityRule;
import drr.standards.iosco.cde.reports.CDESpread_InterestRateRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadCurrencyOfLeg2RuleDefault.class)
public abstract class SpreadCurrencyOfLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CDESpread_CommodityRule cDESpread_CommodityRule;
    @Inject
    protected CDESpread_InterestRateRule cDESpread_InterestRateRule;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected IsPriceMonetary isPriceMonetary;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadCurrencyOfLeg2RuleDefault
    extends SpreadCurrencyOfLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.isIRSwaption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.cDESpread_InterestRateRule.evaluate(this.interestRateLeg2.evaluate(this.underlierForProduct.evaluate((Product)item.get()))));
                }
                Boolean boolean1 = this.isCommoditySwap.evaluate((Product)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)this.cDESpread_CommodityRule.evaluate(this.commodityLeg2.evaluate((Product)item.get())));
                }
                return MapperS.of((Object)this.cDESpread_InterestRateRule.evaluate(this.interestRateLeg2.evaluate((Product)item.get())));
            });
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> item.map("getPrice", spreadSchedule -> spreadSchedule.getPrice()));
            MapperS thenArg4 = thenArg3.filterSingleNullSafe(item -> {
                ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)item.get();
                return this.isPriceMonetary.evaluate(referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue());
            });
            MapperS thenArg5 = thenArg4.mapSingleToItem(item -> item.map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            output = (ISOCurrencyCodeEnum)thenArg5.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

