/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportablePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=UKEMIRReportablePricePeriodDefault.class)
public abstract class UKEMIRReportablePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContinuousPriceSchedule create_ContinuousPriceSchedule;
    @Inject
    protected GetExpirationDate getExpirationDate;
    @Inject
    protected GetReportablePricePeriod getReportablePricePeriod;

    public List<? extends PriceReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
        List emirReportablePricePeriods;
        List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriodsBuilder = this.doEvaluate(transactionReportInstruction);
        if (emirReportablePricePeriodsBuilder == null) {
            emirReportablePricePeriods = null;
        } else {
            emirReportablePricePeriods = emirReportablePricePeriodsBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceReportablePeriod.class, emirReportablePricePeriods);
        }
        return emirReportablePricePeriods;
    }

    protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Date> expirationDate(TransactionReportInstruction var1);

    protected abstract MapperC<? extends PriceReportablePeriod> genericReportablePriceSchedule(TransactionReportInstruction var1);

    public static class UKEMIRReportablePricePeriodDefault
    extends UKEMIRReportablePricePeriod {
        @Override
        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriods = new ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder>();
            return this.assignOutput(emirReportablePricePeriods, transactionReportInstruction);
        }

        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> emirReportablePricePeriods, TransactionReportInstruction transactionReportInstruction) {
            emirReportablePricePeriods = this.toBuilder(this.create_ContinuousPriceSchedule.evaluate(this.genericReportablePriceSchedule(transactionReportInstruction).getMulti(), (Date)this.expirationDate(transactionReportInstruction).get()));
            return Optional.ofNullable(emirReportablePricePeriods).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.getExpirationDate.evaluate(transactionReportInstruction));
        }

        @Override
        protected MapperC<? extends PriceReportablePeriod> genericReportablePriceSchedule(TransactionReportInstruction transactionReportInstruction) {
            return MapperC.of(this.getReportablePricePeriod.evaluate(transactionReportInstruction));
        }
    }
}

