/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.margin.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CollateralReportTypeFormatValidator
implements Validator<CollateralReport> {
    private List<ComparisonResult> getComparisonResults(CollateralReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"uti", (String)o.getUti(), (int)0, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), ExpressionOperatorsNullSafe.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginCollectedByReportingCounterpartyPreHaircut", (BigDecimal)o.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginCollectedByReportingCounterpartyPostHaircut", (BigDecimal)o.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal)o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal)o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginCollectedByTheReportingCounterpartyPreHaircut", (BigDecimal)o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginCollectedByTheReportingCounterpartyPostHaircut", (BigDecimal)o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"excessCollateralPostedByTheReportingCounterparty", (BigDecimal)o.getExcessCollateralPostedByTheReportingCounterparty(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"excessCollateralCollectedByTheReportingCounterparty", (BigDecimal)o.getExcessCollateralCollectedByTheReportingCounterparty(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CollateralReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CollateralReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CollateralReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CollateralReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

