/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.BasketConstituentsReport;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.jfsa.rewrite.trade.OtherPaymentReport;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionSpread;
import drr.regulation.jfsa.rewrite.trade.PriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.PriceScheduleReport;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg1;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import drr.regulation.jfsa.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.StrikePriceScheduleReport;
import drr.regulation.jfsa.rewrite.trade.meta.JFSATransactionReportMeta;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import iso20022.auth030.jfsa.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="JFSATransactionReport", builder=JFSATransactionReportBuilderImpl.class, version="5.58.0")
@RuneDataType(value="JFSATransactionReport", model="drr", builder=JFSATransactionReportBuilderImpl.class, version="5.58.0")
public interface JFSATransactionReport
extends RosettaModelObject {
    public static final JFSATransactionReportMeta metaData = new JFSATransactionReportMeta();

    public Date getEffectiveDate();

    public Date getExpirationDate();

    public Date getEarlyTerminationDate();

    public ZonedDateTime getReportingTimestamp();

    public ZonedDateTime getExecutionTimestamp();

    public String getEntityResponsibleForReporting();

    public String getCounterparty1();

    public String getCounterparty2();

    public Boolean getCounterparty2IdentifierType();

    public String getDirection1();

    public String getDirection2Leg1();

    public String getDirection2Leg2();

    public String getSubmitterIdentifier();

    public String getNewSDRIdentifier();

    public String getOriginalSwapSDRIdentifier();

    public String getCleared();

    public String getCentralCounterparty();

    public String getClearingMember();

    public String getPlatformIdentifier();

    public String getConfirmed();

    public Date getFinalContractualSettlementDate();

    public ZonedDateTime getConfirmationTimestamp();

    public ISOCurrencyCodeEnum getSettlementCurrencyLeg1();

    public ISOCurrencyCodeEnum getSettlementCurrencyLeg2();

    public String getClearingAccountOrigin();

    public String getOriginalSwapUTI();

    public String getOriginalSwapUTIProprietary();

    public ZonedDateTime getClearingReceiptTimestamp();

    public String getUti();

    public String getUtiProprietary();

    public String getPriorUti();

    public String getPriorUtiProprietary();

    public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1();

    public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();

    public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2();

    public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();

    public String getFixedRatePaymentFrequencyPeriodLeg1();

    public String getFixedRatePaymentFrequencyPeriodLeg2();

    public String getFloatingRatePaymentFrequencyPeriodLeg1();

    public String getFloatingRatePaymentFrequencyPeriodLeg2();

    public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1();

    public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2();

    public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();

    public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();

    public ZonedDateTime getFixingDateLeg1();

    public ZonedDateTime getFixingDateLeg2();

    public String getFloatingRateResetFrequencyPeriodLeg1();

    public String getFloatingRateResetFrequencyPeriodOfLeg2();

    public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1();

    public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2();

    public List<? extends OtherPaymentReport> getOtherPayment();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public ZonedDateTime getValuationTimestamp();

    public Boolean getCollateralPortfolioIndicator();

    public String getInitialMarginCollateralPortfolioCode();

    public String getVariationMarginCollateralPortfolioCode();

    public PriceAndNotation getPrice();

    public String getPriceNotation();

    public String getPriceUnitOfMeasure();

    public List<? extends PriceScheduleReport> getPriceSchedule();

    public BigDecimal getFixedRateLeg1();

    public BigDecimal getFixedRateLeg2();

    public SpreadOfLeg1 getSpreadOfLeg1();

    public String getSpreadNotationOfLeg1();

    public SpreadOfLeg2 getSpreadOfLeg2();

    public String getSpreadNotationOfLeg2();

    public StrikePriceAndNotation getStrikePrice();

    public String getStrikePriceNotation();

    public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule();

    public BigDecimal getOptionPremiumAmount();

    public ISOCurrencyCodeEnum getOptionPremiumCurrency();

    public Date getOptionPremiumPaymentDate();

    public Date getFirstExerciseDate();

    public BigDecimal getExchangeRate();

    public String getExchangeRateBasis();

    public BigDecimal getNotionalLeg1();

    public BigDecimal getNotionalLeg2();

    public BigDecimal getCallAmount();

    public BigDecimal getPutAmount();

    public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1();

    public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2();

    public ISOCurrencyCodeEnum getCallCurrency();

    public ISOCurrencyCodeEnum getPutCurrency();

    public String getQuantityUnitOfMeasureLeg1();

    public String getQuantityUnitOfMeasureLeg2();

    public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();

    public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();

    public BigDecimal getTotalNotionalQuantityLeg1();

    public BigDecimal getTotalNotionalQuantityLeg2();

    public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1();

    public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2();

    public String getActionType();

    public String getEventType();

    public ZonedDateTime getEventTimestamp();

    public String getEventIdentifier();

    public BigDecimal getIndexFactor();

    public String getEmbeddedOptionType();

    public String getUpi();

    public String getDeliveryType();

    public String getAssetClass();

    public String getUnderlyingIdentificationType();

    public String getUnderlyingIdentification();

    public String getUnderlyingIndexIndicator();

    public String getNameOfTheUnderlyingIndex();

    public String getReferenceEntity();

    public String getIndicatorOfTheFloatingRateOfLeg1();

    public String getIndicatorOfTheFloatingRateOfLeg2();

    public String getNameOfTheFloatingRateOfLeg1();

    public String getNameOfTheFloatingRateOfLeg2();

    public String getFloatingRateReferencePeriodOfLeg1TimePeriod();

    public String getFloatingRateReferencePeriodOfLeg2TimePeriod();

    public Integer getFloatingRateReferencePeriodOfLeg1Multiplier();

    public Integer getFloatingRateReferencePeriodOfLeg2Multiplier();

    public Boolean getIsCrypto();

    public Date getMaturityDateOfTheUnderlying();

    public String getSeniority();

    public Integer getSeries();

    public Integer getVersion();

    public BigDecimal getCdSIndexAttachmentPoint();

    public BigDecimal getCdSIndexDetachmentPoint();

    public String getCustomBasketCode();

    public List<? extends BasketConstituentsReport> getBasketConstituents();

    public String getContractType();

    public String getOptionStyle();

    public String getOptionType();

    public String getPackageIdentifier();

    public PackageTransactionPrice getPackageTransactionPrice();

    public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency();

    public String getPackageTransactionPriceNotation();

    public PackageTransactionSpread getPackageTransactionSpread();

    public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency();

    public String getPackageTransactionSpreadNotation();

    public BigDecimal getDelta();

    public String getTechnicalRecordId();

    public BarrierAndNotation getBarrier();

    public JFSANonReportable getNonReportable();

    public JFSATransactionReport build();

    public JFSATransactionReportBuilder toBuilder();

    public static JFSATransactionReportBuilder builder() {
        return new JFSATransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends JFSATransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends JFSATransactionReport> getType() {
        return JFSATransactionReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), String.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2Leg1"), String.class, (Object)this.getDirection2Leg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2Leg2"), String.class, (Object)this.getDirection2Leg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), String.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, (Object)this.getOriginalSwapUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiProprietary"), String.class, (Object)this.getUtiProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUti"), String.class, (Object)this.getPriorUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, (Object)this.getPriorUtiProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, (Object)this.getFixedRatePaymentFrequencyPeriodLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, (Object)this.getFixedRatePaymentFrequencyPeriodLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, (Object)this.getFloatingRatePaymentFrequencyPeriodLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, (Object)this.getFloatingRatePaymentFrequencyPeriodLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDateLeg1"), ZonedDateTime.class, (Object)this.getFixingDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDateLeg2"), ZonedDateTime.class, (Object)this.getFixingDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, this.getOtherPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), String.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.class, this.getPriceSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, (Object)this.getFixedRateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, (Object)this.getFixedRateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.class, this.getSpreadOfLeg1(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotationOfLeg1"), String.class, (Object)this.getSpreadNotationOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.class, this.getSpreadOfLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), String.class, (Object)this.getSpreadNotationOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, (Object)this.getNotionalLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, (Object)this.getNotionalLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, this.getNotionalAmountScheduleLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, this.getNotionalAmountScheduleLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.class, this.getNotionalQuantityScheduleLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.class, this.getNotionalQuantityScheduleLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("upi"), String.class, (Object)this.getUpi(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), String.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, (Object)this.getUnderlyingIndexIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, (Object)this.getIndicatorOfTheFloatingRateOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, (Object)this.getIndicatorOfTheFloatingRateOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg1TimePeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg1Multiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, (Object)this.getIsCrypto(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), String.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), Integer.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), String.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
    }

    public static class JFSATransactionReportBuilderImpl
    implements JFSATransactionReportBuilder {
        protected Date effectiveDate;
        protected Date expirationDate;
        protected Date earlyTerminationDate;
        protected ZonedDateTime reportingTimestamp;
        protected ZonedDateTime executionTimestamp;
        protected String entityResponsibleForReporting;
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected String direction1;
        protected String direction2Leg1;
        protected String direction2Leg2;
        protected String submitterIdentifier;
        protected String newSDRIdentifier;
        protected String originalSwapSDRIdentifier;
        protected String cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected String platformIdentifier;
        protected String confirmed;
        protected Date finalContractualSettlementDate;
        protected ZonedDateTime confirmationTimestamp;
        protected ISOCurrencyCodeEnum settlementCurrencyLeg1;
        protected ISOCurrencyCodeEnum settlementCurrencyLeg2;
        protected String clearingAccountOrigin;
        protected String originalSwapUTI;
        protected String originalSwapUTIProprietary;
        protected ZonedDateTime clearingReceiptTimestamp;
        protected String uti;
        protected String utiProprietary;
        protected String priorUti;
        protected String priorUtiProprietary;
        protected InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
        protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
        protected InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
        protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
        protected String fixedRatePaymentFrequencyPeriodLeg1;
        protected String fixedRatePaymentFrequencyPeriodLeg2;
        protected String floatingRatePaymentFrequencyPeriodLeg1;
        protected String floatingRatePaymentFrequencyPeriodLeg2;
        protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
        protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
        protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
        protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
        protected ZonedDateTime fixingDateLeg1;
        protected ZonedDateTime fixingDateLeg2;
        protected String floatingRateResetFrequencyPeriodLeg1;
        protected String floatingRateResetFrequencyPeriodOfLeg2;
        protected Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
        protected Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
        protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected Boolean collateralPortfolioIndicator;
        protected String initialMarginCollateralPortfolioCode;
        protected String variationMarginCollateralPortfolioCode;
        protected PriceAndNotation.PriceAndNotationBuilder price;
        protected String priceNotation;
        protected String priceUnitOfMeasure;
        protected List<PriceScheduleReport.PriceScheduleReportBuilder> priceSchedule = new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>();
        protected BigDecimal fixedRateLeg1;
        protected BigDecimal fixedRateLeg2;
        protected SpreadOfLeg1.SpreadOfLeg1Builder spreadOfLeg1;
        protected String spreadNotationOfLeg1;
        protected SpreadOfLeg2.SpreadOfLeg2Builder spreadOfLeg2;
        protected String spreadNotationOfLeg2;
        protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
        protected String strikePriceNotation;
        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> strikePriceSchedule = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected Date optionPremiumPaymentDate;
        protected Date firstExerciseDate;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected BigDecimal notionalLeg1;
        protected BigDecimal notionalLeg2;
        protected BigDecimal callAmount;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum notionalCurrencyOfLeg1;
        protected ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
        protected ISOCurrencyCodeEnum callCurrency;
        protected ISOCurrencyCodeEnum putCurrency;
        protected String quantityUnitOfMeasureLeg1;
        protected String quantityUnitOfMeasureLeg2;
        protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
        protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
        protected BigDecimal totalNotionalQuantityLeg1;
        protected BigDecimal totalNotionalQuantityLeg2;
        protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1 = new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>();
        protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2 = new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>();
        protected String actionType;
        protected String eventType;
        protected ZonedDateTime eventTimestamp;
        protected String eventIdentifier;
        protected BigDecimal indexFactor;
        protected String embeddedOptionType;
        protected String upi;
        protected String deliveryType;
        protected String assetClass;
        protected String underlyingIdentificationType;
        protected String underlyingIdentification;
        protected String underlyingIndexIndicator;
        protected String nameOfTheUnderlyingIndex;
        protected String referenceEntity;
        protected String indicatorOfTheFloatingRateOfLeg1;
        protected String indicatorOfTheFloatingRateOfLeg2;
        protected String nameOfTheFloatingRateOfLeg1;
        protected String nameOfTheFloatingRateOfLeg2;
        protected String floatingRateReferencePeriodOfLeg1TimePeriod;
        protected String floatingRateReferencePeriodOfLeg2TimePeriod;
        protected Integer floatingRateReferencePeriodOfLeg1Multiplier;
        protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
        protected Boolean isCrypto;
        protected Date maturityDateOfTheUnderlying;
        protected String seniority;
        protected Integer series;
        protected Integer version;
        protected BigDecimal cdSIndexAttachmentPoint;
        protected BigDecimal cdSIndexDetachmentPoint;
        protected String customBasketCode;
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
        protected String contractType;
        protected String optionStyle;
        protected String optionType;
        protected String packageIdentifier;
        protected PackageTransactionPrice.PackageTransactionPriceBuilder packageTransactionPrice;
        protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        protected String packageTransactionPriceNotation;
        protected PackageTransactionSpread.PackageTransactionSpreadBuilder packageTransactionSpread;
        protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        protected String packageTransactionSpreadNotation;
        protected BigDecimal delta;
        protected String technicalRecordId;
        protected BarrierAndNotation.BarrierAndNotationBuilder barrier;
        protected JFSANonReportable.JFSANonReportableBuilder nonReportable;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public String getDirection1() {
            return this.direction1;
        }

        @Override
        @RosettaAttribute(value="direction2Leg1")
        @RuneAttribute(value="direction2Leg1")
        public String getDirection2Leg1() {
            return this.direction2Leg1;
        }

        @Override
        @RosettaAttribute(value="direction2Leg2")
        @RuneAttribute(value="direction2Leg2")
        public String getDirection2Leg2() {
            return this.direction2Leg2;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public String getNewSDRIdentifier() {
            return this.newSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public String getOriginalSwapSDRIdentifier() {
            return this.originalSwapSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public String getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ZonedDateTime getConfirmationTimestamp() {
            return this.confirmationTimestamp;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
            return this.settlementCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
            return this.settlementCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public String getClearingAccountOrigin() {
            return this.clearingAccountOrigin;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public String getOriginalSwapUTI() {
            return this.originalSwapUTI;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTIProprietary")
        @RuneAttribute(value="originalSwapUTIProprietary")
        public String getOriginalSwapUTIProprietary() {
            return this.originalSwapUTIProprietary;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public ZonedDateTime getClearingReceiptTimestamp() {
            return this.clearingReceiptTimestamp;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public String getUti() {
            return this.uti;
        }

        @Override
        @RosettaAttribute(value="utiProprietary")
        @RuneAttribute(value="utiProprietary")
        public String getUtiProprietary() {
            return this.utiProprietary;
        }

        @Override
        @RosettaAttribute(value="priorUti")
        @RuneAttribute(value="priorUti")
        public String getPriorUti() {
            return this.priorUti;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public String getPriorUtiProprietary() {
            return this.priorUtiProprietary;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionLeg1")
        public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
            return this.fixedRateDayCountConventionLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
            return this.floatingRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionLeg2")
        public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
            return this.fixedRateDayCountConventionLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
            return this.floatingRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        public String getFixedRatePaymentFrequencyPeriodLeg1() {
            return this.fixedRatePaymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        public String getFixedRatePaymentFrequencyPeriodLeg2() {
            return this.fixedRatePaymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        public String getFloatingRatePaymentFrequencyPeriodLeg1() {
            return this.floatingRatePaymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        public String getFloatingRatePaymentFrequencyPeriodLeg2() {
            return this.floatingRatePaymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg1")
        @RuneAttribute(value="fixingDateLeg1")
        public ZonedDateTime getFixingDateLeg1() {
            return this.fixingDateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg2")
        @RuneAttribute(value="fixingDateLeg2")
        public ZonedDateTime getFixingDateLeg2() {
            return this.fixingDateLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        public String getFloatingRateResetFrequencyPeriodLeg1() {
            return this.floatingRateResetFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public String getFloatingRateResetFrequencyPeriodOfLeg2() {
            return this.floatingRateResetFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
            return this.floatingRateResetFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
            return this.floatingRateResetFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>();
            }
            return (OtherPaymentReport.OtherPaymentReportBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation.PriceAndNotationBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
            PriceAndNotation.PriceAndNotationBuilder result = this.price != null ? this.price : (this.price = PriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public String getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index) {
            if (this.priceSchedule == null) {
                this.priceSchedule = new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>();
            }
            return (PriceScheduleReport.PriceScheduleReportBuilder)this.getIndex(this.priceSchedule, index, () -> {
                PriceScheduleReport.PriceScheduleReportBuilder newPriceSchedule = PriceScheduleReport.builder();
                return newPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public BigDecimal getFixedRateLeg1() {
            return this.fixedRateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public BigDecimal getFixedRateLeg2() {
            return this.fixedRateLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1() {
            return this.spreadOfLeg1;
        }

        @Override
        public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1() {
            SpreadOfLeg1.SpreadOfLeg1Builder result = this.spreadOfLeg1 != null ? this.spreadOfLeg1 : (this.spreadOfLeg1 = SpreadOfLeg1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg1")
        @RuneAttribute(value="spreadNotationOfLeg1")
        public String getSpreadNotationOfLeg1() {
            return this.spreadNotationOfLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2() {
            return this.spreadOfLeg2;
        }

        @Override
        public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2() {
            SpreadOfLeg2.SpreadOfLeg2Builder result = this.spreadOfLeg2 != null ? this.spreadOfLeg2 : (this.spreadOfLeg2 = SpreadOfLeg2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg2")
        @RuneAttribute(value="spreadNotationOfLeg2")
        public String getSpreadNotationOfLeg2() {
            return this.spreadNotationOfLeg2;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
            StrikePriceAndNotation.StrikePriceAndNotationBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = StrikePriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public String getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
            }
            return (StrikePriceScheduleReport.StrikePriceScheduleReportBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                StrikePriceScheduleReport.StrikePriceScheduleReportBuilder newStrikePriceSchedule = StrikePriceScheduleReport.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public BigDecimal getNotionalLeg1() {
            return this.notionalLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public BigDecimal getNotionalLeg2() {
            return this.notionalLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg1")
        @RuneAttribute(value="notionalCurrencyOfLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1() {
            return this.notionalCurrencyOfLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
            return this.notionalCurrencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public String getQuantityUnitOfMeasureLeg1() {
            return this.quantityUnitOfMeasureLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
            return this.notionalAmountScheduleLeg1;
        }

        @Override
        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
            if (this.notionalAmountScheduleLeg1 == null) {
                this.notionalAmountScheduleLeg1 = new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg1, index, () -> {
                NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
                return newNotionalAmountScheduleLeg1;
            });
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
            return this.notionalAmountScheduleLeg2;
        }

        @Override
        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
            if (this.notionalAmountScheduleLeg2 == null) {
                this.notionalAmountScheduleLeg2 = new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>();
            }
            return (NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder)this.getIndex(this.notionalAmountScheduleLeg2, index, () -> {
                NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
                return newNotionalAmountScheduleLeg2;
            });
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public BigDecimal getTotalNotionalQuantityLeg1() {
            return this.totalNotionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1")
        @RuneAttribute(value="notionalQuantityScheduleLeg1")
        public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1() {
            return this.notionalQuantityScheduleLeg1;
        }

        @Override
        public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int index) {
            if (this.notionalQuantityScheduleLeg1 == null) {
                this.notionalQuantityScheduleLeg1 = new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>();
            }
            return (NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder)this.getIndex(this.notionalQuantityScheduleLeg1, index, () -> {
                NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1 = NotionalQuantityScheduleLeg1Report.builder();
                return newNotionalQuantityScheduleLeg1;
            });
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2")
        @RuneAttribute(value="notionalQuantityScheduleLeg2")
        public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2() {
            return this.notionalQuantityScheduleLeg2;
        }

        @Override
        public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int index) {
            if (this.notionalQuantityScheduleLeg2 == null) {
                this.notionalQuantityScheduleLeg2 = new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>();
            }
            return (NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder)this.getIndex(this.notionalQuantityScheduleLeg2, index, () -> {
                NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2 = NotionalQuantityScheduleLeg2Report.builder();
                return newNotionalQuantityScheduleLeg2;
            });
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public String getEmbeddedOptionType() {
            return this.embeddedOptionType;
        }

        @Override
        @RosettaAttribute(value="upi")
        @RuneAttribute(value="upi")
        public String getUpi() {
            return this.upi;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public String getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public String getUnderlyingIdentification() {
            return this.underlyingIdentification;
        }

        @Override
        @RosettaAttribute(value="underlyingIndexIndicator")
        @RuneAttribute(value="underlyingIndexIndicator")
        public String getUnderlyingIndexIndicator() {
            return this.underlyingIndexIndicator;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public String getNameOfTheUnderlyingIndex() {
            return this.nameOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public String getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        public String getIndicatorOfTheFloatingRateOfLeg1() {
            return this.indicatorOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        public String getIndicatorOfTheFloatingRateOfLeg2() {
            return this.indicatorOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public String getNameOfTheFloatingRateOfLeg1() {
            return this.nameOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public String getNameOfTheFloatingRateOfLeg2() {
            return this.nameOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg1TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg2TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
            return this.floatingRateReferencePeriodOfLeg1Multiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
            return this.floatingRateReferencePeriodOfLeg2Multiplier;
        }

        @Override
        @RosettaAttribute(value="isCrypto", isRequired=true)
        @RuneAttribute(value="isCrypto", isRequired=true)
        public Boolean getIsCrypto() {
            return this.isCrypto;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public String getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public Integer getSeries() {
            return this.series;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public Integer getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public String getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice() {
            PackageTransactionPrice.PackageTransactionPriceBuilder result = this.packageTransactionPrice != null ? this.packageTransactionPrice : (this.packageTransactionPrice = PackageTransactionPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public String getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread() {
            PackageTransactionSpread.PackageTransactionSpreadBuilder result = this.packageTransactionSpread != null ? this.packageTransactionSpread : (this.packageTransactionSpread = PackageTransactionSpread.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public String getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public BarrierAndNotation.BarrierAndNotationBuilder getBarrier() {
            return this.barrier;
        }

        @Override
        public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier() {
            BarrierAndNotation.BarrierAndNotationBuilder result = this.barrier != null ? this.barrier : (this.barrier = BarrierAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public JFSANonReportable.JFSANonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable() {
            JFSANonReportable.JFSANonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = JFSANonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public JFSATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public JFSATransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public JFSATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public JFSATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public JFSATransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public JFSATransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public JFSATransactionReportBuilder setDirection1(String _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2Leg1")
        @RuneAttribute(value="direction2Leg1")
        public JFSATransactionReportBuilder setDirection2Leg1(String _direction2Leg1) {
            this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2Leg2")
        @RuneAttribute(value="direction2Leg2")
        public JFSATransactionReportBuilder setDirection2Leg2(String _direction2Leg2) {
            this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public JFSATransactionReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
            this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public JFSATransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public JFSATransactionReportBuilder setCleared(String _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public JFSATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public JFSATransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public JFSATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public JFSATransactionReportBuilder setConfirmed(String _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public JFSATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public JFSATransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum _settlementCurrencyLeg1) {
            this.settlementCurrencyLeg1 = _settlementCurrencyLeg1 == null ? null : _settlementCurrencyLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public JFSATransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum _settlementCurrencyLeg2) {
            this.settlementCurrencyLeg2 = _settlementCurrencyLeg2 == null ? null : _settlementCurrencyLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public JFSATransactionReportBuilder setClearingAccountOrigin(String _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public JFSATransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTIProprietary")
        @RuneAttribute(value="originalSwapUTIProprietary")
        public JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String _originalSwapUTIProprietary) {
            this.originalSwapUTIProprietary = _originalSwapUTIProprietary == null ? null : _originalSwapUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public JFSATransactionReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiProprietary")
        @RuneAttribute(value="utiProprietary")
        public JFSATransactionReportBuilder setUtiProprietary(String _utiProprietary) {
            this.utiProprietary = _utiProprietary == null ? null : _utiProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUti")
        @RuneAttribute(value="priorUti")
        public JFSATransactionReportBuilder setPriorUti(String _priorUti) {
            this.priorUti = _priorUti == null ? null : _priorUti;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public JFSATransactionReportBuilder setPriorUtiProprietary(String _priorUtiProprietary) {
            this.priorUtiProprietary = _priorUtiProprietary == null ? null : _priorUtiProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionLeg1")
        public JFSATransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionLeg1) {
            this.fixedRateDayCountConventionLeg1 = _fixedRateDayCountConventionLeg1 == null ? null : _fixedRateDayCountConventionLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
            this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionLeg2")
        public JFSATransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionLeg2) {
            this.fixedRateDayCountConventionLeg2 = _fixedRateDayCountConventionLeg2 == null ? null : _fixedRateDayCountConventionLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
            this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String _fixedRatePaymentFrequencyPeriodLeg1) {
            this.fixedRatePaymentFrequencyPeriodLeg1 = _fixedRatePaymentFrequencyPeriodLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String _fixedRatePaymentFrequencyPeriodLeg2) {
            this.fixedRatePaymentFrequencyPeriodLeg2 = _fixedRatePaymentFrequencyPeriodLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String _floatingRatePaymentFrequencyPeriodLeg1) {
            this.floatingRatePaymentFrequencyPeriodLeg1 = _floatingRatePaymentFrequencyPeriodLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String _floatingRatePaymentFrequencyPeriodLeg2) {
            this.floatingRatePaymentFrequencyPeriodLeg2 = _floatingRatePaymentFrequencyPeriodLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg1) {
            this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg2) {
            this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg1) {
            this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg2) {
            this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg1")
        @RuneAttribute(value="fixingDateLeg1")
        public JFSATransactionReportBuilder setFixingDateLeg1(ZonedDateTime _fixingDateLeg1) {
            this.fixingDateLeg1 = _fixingDateLeg1 == null ? null : _fixingDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg2")
        @RuneAttribute(value="fixingDateLeg2")
        public JFSATransactionReportBuilder setFixingDateLeg2(ZonedDateTime _fixingDateLeg2) {
            this.fixingDateLeg2 = _fixingDateLeg2 == null ? null : _fixingDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String _floatingRateResetFrequencyPeriodLeg1) {
            this.floatingRateResetFrequencyPeriodLeg1 = _floatingRateResetFrequencyPeriodLeg1 == null ? null : _floatingRateResetFrequencyPeriodLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
            this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierLeg1) {
            this.floatingRateResetFrequencyPeriodMultiplierLeg1 = _floatingRateResetFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierLeg2) {
            this.floatingRateResetFrequencyPeriodMultiplierLeg2 = _floatingRateResetFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            if (otherPayments != null) {
                for (OtherPaymentReport otherPaymentReport : otherPayments) {
                    this.otherPayment.add(otherPaymentReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPaymentReport.OtherPaymentReportBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public JFSATransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public JFSATransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public JFSATransactionReportBuilder setPrice(PriceAndNotation _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public JFSATransactionReportBuilder setPriceNotation(String _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public JFSATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
            if (priceSchedules != null) {
                for (PriceScheduleReport priceScheduleReport : priceSchedules) {
                    this.priceSchedule.add(priceScheduleReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public JFSATransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList<PriceScheduleReport.PriceScheduleReportBuilder>() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public JFSATransactionReportBuilder setFixedRateLeg1(BigDecimal _fixedRateLeg1) {
            this.fixedRateLeg1 = _fixedRateLeg1 == null ? null : _fixedRateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public JFSATransactionReportBuilder setFixedRateLeg2(BigDecimal _fixedRateLeg2) {
            this.fixedRateLeg2 = _fixedRateLeg2 == null ? null : _fixedRateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public JFSATransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 _spreadOfLeg1) {
            this.spreadOfLeg1 = _spreadOfLeg1 == null ? null : _spreadOfLeg1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg1")
        @RuneAttribute(value="spreadNotationOfLeg1")
        public JFSATransactionReportBuilder setSpreadNotationOfLeg1(String _spreadNotationOfLeg1) {
            this.spreadNotationOfLeg1 = _spreadNotationOfLeg1 == null ? null : _spreadNotationOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public JFSATransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 _spreadOfLeg2) {
            this.spreadOfLeg2 = _spreadOfLeg2 == null ? null : _spreadOfLeg2.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg2")
        @RuneAttribute(value="spreadNotationOfLeg2")
        public JFSATransactionReportBuilder setSpreadNotationOfLeg2(String _spreadNotationOfLeg2) {
            this.spreadNotationOfLeg2 = _spreadNotationOfLeg2 == null ? null : _spreadNotationOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public JFSATransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public JFSATransactionReportBuilder setStrikePriceNotation(String _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (StrikePriceScheduleReport strikePriceScheduleReport : strikePriceSchedules) {
                    this.strikePriceSchedule.add(strikePriceScheduleReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public JFSATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public JFSATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public JFSATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public JFSATransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
            this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public JFSATransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
            this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public JFSATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public JFSATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg1")
        @RuneAttribute(value="notionalCurrencyOfLeg1")
        public JFSATransactionReportBuilder setNotionalCurrencyOfLeg1(ISOCurrencyCodeEnum _notionalCurrencyOfLeg1) {
            this.notionalCurrencyOfLeg1 = _notionalCurrencyOfLeg1 == null ? null : _notionalCurrencyOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public JFSATransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum _notionalCurrencyOfLeg2) {
            this.notionalCurrencyOfLeg2 = _notionalCurrencyOfLeg2 == null ? null : _notionalCurrencyOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
            this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
            this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
            if (_notionalAmountScheduleLeg1 != null) {
                this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
            if (notionalAmountScheduleLeg1s != null) {
                for (NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1Report : notionalAmountScheduleLeg1s) {
                    this.notionalAmountScheduleLeg1.add(notionalAmountScheduleLeg1Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public JFSATransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
            this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s == null ? new ArrayList<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>() : (List)notionalAmountScheduleLeg1s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
            if (_notionalAmountScheduleLeg2 != null) {
                this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
            this.getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
            if (notionalAmountScheduleLeg2s != null) {
                for (NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2Report : notionalAmountScheduleLeg2s) {
                    this.notionalAmountScheduleLeg2.add(notionalAmountScheduleLeg2Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public JFSATransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
            this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s == null ? new ArrayList<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>() : (List)notionalAmountScheduleLeg2s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public JFSATransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
            this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public JFSATransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
            this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1")
        @RuneAttribute(value="notionalQuantityScheduleLeg1")
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1) {
            if (_notionalQuantityScheduleLeg1 != null) {
                this.notionalQuantityScheduleLeg1.add(_notionalQuantityScheduleLeg1.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1, int idx) {
            this.getIndex(this.notionalQuantityScheduleLeg1, idx, () -> _notionalQuantityScheduleLeg1.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
            if (notionalQuantityScheduleLeg1s != null) {
                for (NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1Report : notionalQuantityScheduleLeg1s) {
                    this.notionalQuantityScheduleLeg1.add(notionalQuantityScheduleLeg1Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantityScheduleLeg1")
        public JFSATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
            this.notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1s == null ? new ArrayList<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>() : (List)notionalQuantityScheduleLeg1s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2")
        @RuneAttribute(value="notionalQuantityScheduleLeg2")
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2) {
            if (_notionalQuantityScheduleLeg2 != null) {
                this.notionalQuantityScheduleLeg2.add(_notionalQuantityScheduleLeg2.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2, int idx) {
            this.getIndex(this.notionalQuantityScheduleLeg2, idx, () -> _notionalQuantityScheduleLeg2.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
            if (notionalQuantityScheduleLeg2s != null) {
                for (NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2Report : notionalQuantityScheduleLeg2s) {
                    this.notionalQuantityScheduleLeg2.add(notionalQuantityScheduleLeg2Report.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantityScheduleLeg2")
        public JFSATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
            this.notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2s == null ? new ArrayList<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>() : (List)notionalQuantityScheduleLeg2s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public JFSATransactionReportBuilder setActionType(String _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public JFSATransactionReportBuilder setEventType(String _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public JFSATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public JFSATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public JFSATransactionReportBuilder setEmbeddedOptionType(String _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="upi")
        @RuneAttribute(value="upi")
        public JFSATransactionReportBuilder setUpi(String _upi) {
            this.upi = _upi == null ? null : _upi;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public JFSATransactionReportBuilder setDeliveryType(String _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public JFSATransactionReportBuilder setAssetClass(String _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public JFSATransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public JFSATransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIndexIndicator")
        @RuneAttribute(value="underlyingIndexIndicator")
        public JFSATransactionReportBuilder setUnderlyingIndexIndicator(String _underlyingIndexIndicator) {
            this.underlyingIndexIndicator = _underlyingIndexIndicator == null ? null : _underlyingIndexIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public JFSATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        public JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String _indicatorOfTheFloatingRateOfLeg1) {
            this.indicatorOfTheFloatingRateOfLeg1 = _indicatorOfTheFloatingRateOfLeg1 == null ? null : _indicatorOfTheFloatingRateOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        public JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String _indicatorOfTheFloatingRateOfLeg2) {
            this.indicatorOfTheFloatingRateOfLeg2 = _indicatorOfTheFloatingRateOfLeg2 == null ? null : _indicatorOfTheFloatingRateOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
            this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
            this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String _floatingRateReferencePeriodOfLeg1TimePeriod) {
            this.floatingRateReferencePeriodOfLeg1TimePeriod = _floatingRateReferencePeriodOfLeg1TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg1TimePeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
            this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer _floatingRateReferencePeriodOfLeg1Multiplier) {
            this.floatingRateReferencePeriodOfLeg1Multiplier = _floatingRateReferencePeriodOfLeg1Multiplier == null ? null : _floatingRateReferencePeriodOfLeg1Multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
            this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="isCrypto", isRequired=true)
        @RuneAttribute(value="isCrypto", isRequired=true)
        public JFSATransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
            this.isCrypto = _isCrypto == null ? null : _isCrypto;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public JFSATransactionReportBuilder setSeniority(String _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public JFSATransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public JFSATransactionReportBuilder setVersion(Integer _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public JFSATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public JFSATransactionReportBuilder setContractType(String _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public JFSATransactionReportBuilder setOptionStyle(String _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public JFSATransactionReportBuilder setOptionType(String _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public JFSATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public JFSATransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public JFSATransactionReportBuilder setPackageTransactionPriceNotation(String _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public JFSATransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public JFSATransactionReportBuilder setPackageTransactionSpreadNotation(String _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public JFSATransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public JFSATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public JFSATransactionReportBuilder setBarrier(BarrierAndNotation _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public JFSATransactionReportBuilder setNonReportable(JFSANonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        public JFSATransactionReport build() {
            return new JFSATransactionReportImpl(this);
        }

        @Override
        public JFSATransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public JFSATransactionReportBuilder prune() {
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            this.priceSchedule = this.priceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.spreadOfLeg1 != null && !this.spreadOfLeg1.prune().hasData()) {
                this.spreadOfLeg1 = null;
            }
            if (this.spreadOfLeg2 != null && !this.spreadOfLeg2.prune().hasData()) {
                this.spreadOfLeg2 = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalAmountScheduleLeg1 = this.notionalAmountScheduleLeg1.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalAmountScheduleLeg2 = this.notionalAmountScheduleLeg2.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantityScheduleLeg1 = this.notionalQuantityScheduleLeg1.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantityScheduleLeg2 = this.notionalQuantityScheduleLeg2.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.packageTransactionPrice != null && !this.packageTransactionPrice.prune().hasData()) {
                this.packageTransactionPrice = null;
            }
            if (this.packageTransactionSpread != null && !this.packageTransactionSpread.prune().hasData()) {
                this.packageTransactionSpread = null;
            }
            if (this.barrier != null && !this.barrier.prune().hasData()) {
                this.barrier = null;
            }
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getEarlyTerminationDate() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getDirection1() != null) {
                return true;
            }
            if (this.getDirection2Leg1() != null) {
                return true;
            }
            if (this.getDirection2Leg2() != null) {
                return true;
            }
            if (this.getSubmitterIdentifier() != null) {
                return true;
            }
            if (this.getNewSDRIdentifier() != null) {
                return true;
            }
            if (this.getOriginalSwapSDRIdentifier() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getPlatformIdentifier() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            if (this.getConfirmationTimestamp() != null) {
                return true;
            }
            if (this.getSettlementCurrencyLeg1() != null) {
                return true;
            }
            if (this.getSettlementCurrencyLeg2() != null) {
                return true;
            }
            if (this.getClearingAccountOrigin() != null) {
                return true;
            }
            if (this.getOriginalSwapUTI() != null) {
                return true;
            }
            if (this.getOriginalSwapUTIProprietary() != null) {
                return true;
            }
            if (this.getClearingReceiptTimestamp() != null) {
                return true;
            }
            if (this.getUti() != null) {
                return true;
            }
            if (this.getUtiProprietary() != null) {
                return true;
            }
            if (this.getPriorUti() != null) {
                return true;
            }
            if (this.getPriorUtiProprietary() != null) {
                return true;
            }
            if (this.getFixedRateDayCountConventionLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateDayCountConventionOfLeg1() != null) {
                return true;
            }
            if (this.getFixedRateDayCountConventionLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateDayCountConventionOfLeg2() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodLeg1() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodLeg2() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodLeg1() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodLeg2() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() != null) {
                return true;
            }
            if (this.getFixingDateLeg1() != null) {
                return true;
            }
            if (this.getFixingDateLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodMultiplierLeg1() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriodMultiplierLeg2() != null) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceNotation() != null) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getPriceSchedule() != null && this.getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFixedRateLeg1() != null) {
                return true;
            }
            if (this.getFixedRateLeg2() != null) {
                return true;
            }
            if (this.getSpreadOfLeg1() != null && this.getSpreadOfLeg1().hasData()) {
                return true;
            }
            if (this.getSpreadNotationOfLeg1() != null) {
                return true;
            }
            if (this.getSpreadOfLeg2() != null && this.getSpreadOfLeg2().hasData()) {
                return true;
            }
            if (this.getSpreadNotationOfLeg2() != null) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikePriceNotation() != null) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getOptionPremiumPaymentDate() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getNotionalLeg1() != null) {
                return true;
            }
            if (this.getNotionalLeg2() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getNotionalCurrencyOfLeg1() != null) {
                return true;
            }
            if (this.getNotionalCurrencyOfLeg2() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureLeg1() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasureLeg2() != null) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg1() != null && this.getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalAmountScheduleLeg2() != null && this.getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTotalNotionalQuantityLeg1() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantityLeg2() != null) {
                return true;
            }
            if (this.getNotionalQuantityScheduleLeg1() != null && this.getNotionalQuantityScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalQuantityScheduleLeg2() != null && this.getNotionalQuantityScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getEventIdentifier() != null) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            if (this.getEmbeddedOptionType() != null) {
                return true;
            }
            if (this.getUpi() != null) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getUnderlyingIdentificationType() != null) {
                return true;
            }
            if (this.getUnderlyingIdentification() != null) {
                return true;
            }
            if (this.getUnderlyingIndexIndicator() != null) {
                return true;
            }
            if (this.getNameOfTheUnderlyingIndex() != null) {
                return true;
            }
            if (this.getReferenceEntity() != null) {
                return true;
            }
            if (this.getIndicatorOfTheFloatingRateOfLeg1() != null) {
                return true;
            }
            if (this.getIndicatorOfTheFloatingRateOfLeg2() != null) {
                return true;
            }
            if (this.getNameOfTheFloatingRateOfLeg1() != null) {
                return true;
            }
            if (this.getNameOfTheFloatingRateOfLeg2() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg1TimePeriod() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg2TimePeriod() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg1Multiplier() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodOfLeg2Multiplier() != null) {
                return true;
            }
            if (this.getIsCrypto() != null) {
                return true;
            }
            if (this.getMaturityDateOfTheUnderlying() != null) {
                return true;
            }
            if (this.getSeniority() != null) {
                return true;
            }
            if (this.getSeries() != null) {
                return true;
            }
            if (this.getVersion() != null) {
                return true;
            }
            if (this.getCdSIndexAttachmentPoint() != null) {
                return true;
            }
            if (this.getCdSIndexDetachmentPoint() != null) {
                return true;
            }
            if (this.getCustomBasketCode() != null) {
                return true;
            }
            if (this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getOptionStyle() != null) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getPackageTransactionPrice() != null && this.getPackageTransactionPrice().hasData()) {
                return true;
            }
            if (this.getPackageTransactionPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionPriceNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionSpread() != null && this.getPackageTransactionSpread().hasData()) {
                return true;
            }
            if (this.getPackageTransactionSpreadCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionSpreadNotation() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().hasData()) {
                return true;
            }
            return this.getNonReportable() != null && this.getNonReportable().hasData();
        }

        public JFSATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            JFSATransactionReportBuilder o = (JFSATransactionReportBuilder)other;
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta(this.getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadOfLeg1(), (RosettaModelObjectBuilder)o.getSpreadOfLeg1(), this::setSpreadOfLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadOfLeg2(), (RosettaModelObjectBuilder)o.getSpreadOfLeg2(), this::setSpreadOfLeg2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
            merger.mergeRosetta(this.getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
            merger.mergeRosetta(this.getNotionalQuantityScheduleLeg1(), o.getNotionalQuantityScheduleLeg1(), this::getOrCreateNotionalQuantityScheduleLeg1);
            merger.mergeRosetta(this.getNotionalQuantityScheduleLeg2(), o.getNotionalQuantityScheduleLeg2(), this::getOrCreateNotionalQuantityScheduleLeg2);
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionPrice(), (RosettaModelObjectBuilder)o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionSpread(), (RosettaModelObjectBuilder)o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrier(), (RosettaModelObjectBuilder)o.getBarrier(), this::setBarrier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEarlyTerminationDate(), (Object)o.getEarlyTerminationDate(), this::setEarlyTerminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection1(), (Object)o.getDirection1(), this::setDirection1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2Leg1(), (Object)o.getDirection2Leg1(), this::setDirection2Leg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2Leg2(), (Object)o.getDirection2Leg2(), this::setDirection2Leg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmitterIdentifier(), (Object)o.getSubmitterIdentifier(), this::setSubmitterIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNewSDRIdentifier(), (Object)o.getNewSDRIdentifier(), this::setNewSDRIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapSDRIdentifier(), (Object)o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPlatformIdentifier(), (Object)o.getPlatformIdentifier(), this::setPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmationTimestamp(), (Object)o.getConfirmationTimestamp(), this::setConfirmationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrencyLeg1(), (Object)o.getSettlementCurrencyLeg1(), this::setSettlementCurrencyLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrencyLeg2(), (Object)o.getSettlementCurrencyLeg2(), this::setSettlementCurrencyLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingAccountOrigin(), (Object)o.getClearingAccountOrigin(), this::setClearingAccountOrigin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapUTI(), (Object)o.getOriginalSwapUTI(), this::setOriginalSwapUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapUTIProprietary(), (Object)o.getOriginalSwapUTIProprietary(), this::setOriginalSwapUTIProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingReceiptTimestamp(), (Object)o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUti(), (Object)o.getUti(), this::setUti, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiProprietary(), (Object)o.getUtiProprietary(), this::setUtiProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUti(), (Object)o.getPriorUti(), this::setPriorUti, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUtiProprietary(), (Object)o.getPriorUtiProprietary(), this::setPriorUtiProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateDayCountConventionLeg1(), (Object)o.getFixedRateDayCountConventionLeg1(), this::setFixedRateDayCountConventionLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateDayCountConventionOfLeg1(), (Object)o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateDayCountConventionLeg2(), (Object)o.getFixedRateDayCountConventionLeg2(), this::setFixedRateDayCountConventionLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateDayCountConventionOfLeg2(), (Object)o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodLeg1(), (Object)o.getFixedRatePaymentFrequencyPeriodLeg1(), this::setFixedRatePaymentFrequencyPeriodLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodLeg2(), (Object)o.getFixedRatePaymentFrequencyPeriodLeg2(), this::setFixedRatePaymentFrequencyPeriodLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodLeg1(), (Object)o.getFloatingRatePaymentFrequencyPeriodLeg1(), this::setFloatingRatePaymentFrequencyPeriodLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodLeg2(), (Object)o.getFloatingRatePaymentFrequencyPeriodLeg2(), this::setFloatingRatePaymentFrequencyPeriodLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), (Object)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), (Object)o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), (Object)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), (Object)o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixingDateLeg1(), (Object)o.getFixingDateLeg1(), this::setFixingDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixingDateLeg2(), (Object)o.getFixingDateLeg2(), this::setFixingDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodLeg1(), (Object)o.getFloatingRateResetFrequencyPeriodLeg1(), this::setFloatingRateResetFrequencyPeriodLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (Object)o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), (Object)o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), (Object)o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceNotation(), (Object)o.getPriceNotation(), this::setPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateLeg1(), (Object)o.getFixedRateLeg1(), this::setFixedRateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRateLeg2(), (Object)o.getFixedRateLeg2(), this::setFixedRateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotationOfLeg1(), (Object)o.getSpreadNotationOfLeg1(), this::setSpreadNotationOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotationOfLeg2(), (Object)o.getSpreadNotationOfLeg2(), this::setSpreadNotationOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceNotation(), (Object)o.getStrikePriceNotation(), this::setStrikePriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumPaymentDate(), (Object)o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstExerciseDate(), (Object)o.getFirstExerciseDate(), this::setFirstExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalLeg1(), (Object)o.getNotionalLeg1(), this::setNotionalLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalLeg2(), (Object)o.getNotionalLeg2(), this::setNotionalLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyOfLeg1(), (Object)o.getNotionalCurrencyOfLeg1(), this::setNotionalCurrencyOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrencyOfLeg2(), (Object)o.getNotionalCurrencyOfLeg2(), this::setNotionalCurrencyOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureLeg1(), (Object)o.getQuantityUnitOfMeasureLeg1(), this::setQuantityUnitOfMeasureLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasureLeg2(), (Object)o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityLeg1(), (Object)o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantityLeg2(), (Object)o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventIdentifier(), (Object)o.getEventIdentifier(), this::setEventIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEmbeddedOptionType(), (Object)o.getEmbeddedOptionType(), this::setEmbeddedOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUpi(), (Object)o.getUpi(), this::setUpi, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentificationType(), (Object)o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentification(), (Object)o.getUnderlyingIdentification(), this::setUnderlyingIdentification, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIndexIndicator(), (Object)o.getUnderlyingIndexIndicator(), this::setUnderlyingIndexIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheUnderlyingIndex(), (Object)o.getNameOfTheUnderlyingIndex(), this::setNameOfTheUnderlyingIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceEntity(), (Object)o.getReferenceEntity(), this::setReferenceEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndicatorOfTheFloatingRateOfLeg1(), (Object)o.getIndicatorOfTheFloatingRateOfLeg1(), this::setIndicatorOfTheFloatingRateOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndicatorOfTheFloatingRateOfLeg2(), (Object)o.getIndicatorOfTheFloatingRateOfLeg2(), this::setIndicatorOfTheFloatingRateOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheFloatingRateOfLeg1(), (Object)o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheFloatingRateOfLeg2(), (Object)o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg1TimePeriod(), (Object)o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), this::setFloatingRateReferencePeriodOfLeg1TimePeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (Object)o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg1Multiplier(), (Object)o.getFloatingRateReferencePeriodOfLeg1Multiplier(), this::setFloatingRateReferencePeriodOfLeg1Multiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (Object)o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsCrypto(), (Object)o.getIsCrypto(), this::setIsCrypto, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDateOfTheUnderlying(), (Object)o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeniority(), (Object)o.getSeniority(), this::setSeniority, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeries(), (Object)o.getSeries(), this::setSeries, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexAttachmentPoint(), (Object)o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexDetachmentPoint(), (Object)o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketCode(), (Object)o.getCustomBasketCode(), this::setCustomBasketCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionStyle(), (Object)o.getOptionStyle(), this::setOptionStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceCurrency(), (Object)o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceNotation(), (Object)o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadCurrency(), (Object)o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadNotation(), (Object)o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            JFSATransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.direction1, _that.getDirection1())) {
                return false;
            }
            if (!Objects.equals(this.direction2Leg1, _that.getDirection2Leg1())) {
                return false;
            }
            if (!Objects.equals(this.direction2Leg2, _that.getDirection2Leg2())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.newSDRIdentifier, _that.getNewSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.confirmationTimestamp, _that.getConfirmationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.clearingAccountOrigin, _that.getClearingAccountOrigin())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUTI, _that.getOriginalSwapUTI())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) {
                return false;
            }
            if (!Objects.equals(this.clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uti, _that.getUti())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietary, _that.getUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.priorUti, _that.getPriorUti())) {
                return false;
            }
            if (!Objects.equals(this.priorUtiProprietary, _that.getPriorUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateLeg1, _that.getFixingDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateLeg2, _that.getFixingDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceNotation, _that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg1, _that.getFixedRateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg2, _that.getFixedRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg1, _that.getSpreadOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationOfLeg1, _that.getSpreadNotationOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg2, _that.getSpreadOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceNotation, _that.getStrikePriceNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg1, _that.getNotionalLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg2, _that.getNotionalLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg1, _that.getNotionalCurrencyOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals(this.embeddedOptionType, _that.getEmbeddedOptionType())) {
                return false;
            }
            if (!Objects.equals(this.upi, _that.getUpi())) {
                return false;
            }
            if (!Objects.equals(this.deliveryType, _that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentification, _that.getUnderlyingIdentification())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.isCrypto, _that.getIsCrypto())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.series, _that.getSeries())) {
                return false;
            }
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.optionStyle, _that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.direction1 != null ? this.direction1.hashCode() : 0);
            _result = 31 * _result + (this.direction2Leg1 != null ? this.direction2Leg1.hashCode() : 0);
            _result = 31 * _result + (this.direction2Leg2 != null ? this.direction2Leg2.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.newSDRIdentifier != null ? this.newSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapSDRIdentifier != null ? this.originalSwapSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.confirmationTimestamp != null ? this.confirmationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg1 != null ? this.settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg2 != null ? this.settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingAccountOrigin != null ? this.clearingAccountOrigin.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUTI != null ? this.originalSwapUTI.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUTIProprietary != null ? this.originalSwapUTIProprietary.hashCode() : 0);
            _result = 31 * _result + (this.clearingReceiptTimestamp != null ? this.clearingReceiptTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uti != null ? this.uti.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietary != null ? this.utiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.priorUti != null ? this.priorUti.hashCode() : 0);
            _result = 31 * _result + (this.priorUtiProprietary != null ? this.priorUtiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionLeg1 != null ? this.fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg1 != null ? this.floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionLeg2 != null ? this.fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg2 != null ? this.floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodLeg1 != null ? this.fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodLeg2 != null ? this.fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodLeg1 != null ? this.floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodLeg2 != null ? this.floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateLeg1 != null ? this.fixingDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateLeg2 != null ? this.fixingDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodLeg1 != null ? this.floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg2 != null ? this.floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? this.floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? this.floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? this.priceNotation.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg1 != null ? this.fixedRateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg2 != null ? this.fixedRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg1 != null ? this.spreadOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationOfLeg1 != null ? this.spreadNotationOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg2 != null ? this.spreadOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationOfLeg2 != null ? this.spreadNotationOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? this.strikePriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg1 != null ? this.notionalLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg2 != null ? this.notionalLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg1 != null ? this.notionalCurrencyOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg2 != null ? this.notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg1 != null ? this.quantityUnitOfMeasureLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1 != null ? this.notionalAmountScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2 != null ? this.notionalAmountScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg1 != null ? this.totalNotionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg1 != null ? this.notionalQuantityScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg2 != null ? this.notionalQuantityScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.embeddedOptionType != null ? this.embeddedOptionType.hashCode() : 0);
            _result = 31 * _result + (this.upi != null ? this.upi.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? this.deliveryType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentification != null ? this.underlyingIdentification.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIndexIndicator != null ? this.underlyingIndexIndicator.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheUnderlyingIndex != null ? this.nameOfTheUnderlyingIndex.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateOfLeg1 != null ? this.indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateOfLeg2 != null ? this.indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg1 != null ? this.nameOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg2 != null ? this.nameOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg1TimePeriod != null ? this.floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2TimePeriod != null ? this.floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg1Multiplier != null ? this.floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2Multiplier != null ? this.floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.isCrypto != null ? this.isCrypto.hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.series != null ? this.series.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? this.optionStyle.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? this.packageTransactionPriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? this.packageTransactionSpreadNotation.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "JFSATransactionReportBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", direction1=" + this.direction1 + ", direction2Leg1=" + this.direction2Leg1 + ", direction2Leg2=" + this.direction2Leg2 + ", submitterIdentifier=" + this.submitterIdentifier + ", newSDRIdentifier=" + this.newSDRIdentifier + ", originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", platformIdentifier=" + this.platformIdentifier + ", confirmed=" + this.confirmed + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", confirmationTimestamp=" + String.valueOf(this.confirmationTimestamp) + ", settlementCurrencyLeg1=" + String.valueOf(this.settlementCurrencyLeg1) + ", settlementCurrencyLeg2=" + String.valueOf(this.settlementCurrencyLeg2) + ", clearingAccountOrigin=" + this.clearingAccountOrigin + ", originalSwapUTI=" + this.originalSwapUTI + ", originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", clearingReceiptTimestamp=" + String.valueOf(this.clearingReceiptTimestamp) + ", uti=" + this.uti + ", utiProprietary=" + this.utiProprietary + ", priorUti=" + this.priorUti + ", priorUtiProprietary=" + this.priorUtiProprietary + ", fixedRateDayCountConventionLeg1=" + String.valueOf(this.fixedRateDayCountConventionLeg1) + ", floatingRateDayCountConventionOfLeg1=" + String.valueOf(this.floatingRateDayCountConventionOfLeg1) + ", fixedRateDayCountConventionLeg2=" + String.valueOf(this.fixedRateDayCountConventionLeg2) + ", floatingRateDayCountConventionOfLeg2=" + String.valueOf(this.floatingRateDayCountConventionOfLeg2) + ", fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", fixingDateLeg1=" + String.valueOf(this.fixingDateLeg1) + ", fixingDateLeg2=" + String.valueOf(this.fixingDateLeg2) + ", floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", otherPayment=" + String.valueOf(this.otherPayment) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", price=" + String.valueOf(this.price) + ", priceNotation=" + this.priceNotation + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", fixedRateLeg1=" + String.valueOf(this.fixedRateLeg1) + ", fixedRateLeg2=" + String.valueOf(this.fixedRateLeg2) + ", spreadOfLeg1=" + String.valueOf(this.spreadOfLeg1) + ", spreadNotationOfLeg1=" + this.spreadNotationOfLeg1 + ", spreadOfLeg2=" + String.valueOf(this.spreadOfLeg2) + ", spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + this.strikePriceNotation + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", notionalLeg1=" + String.valueOf(this.notionalLeg1) + ", notionalLeg2=" + String.valueOf(this.notionalLeg2) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalCurrencyOfLeg1=" + String.valueOf(this.notionalCurrencyOfLeg1) + ", notionalCurrencyOfLeg2=" + String.valueOf(this.notionalCurrencyOfLeg2) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", notionalAmountScheduleLeg1=" + String.valueOf(this.notionalAmountScheduleLeg1) + ", notionalAmountScheduleLeg2=" + String.valueOf(this.notionalAmountScheduleLeg2) + ", totalNotionalQuantityLeg1=" + String.valueOf(this.totalNotionalQuantityLeg1) + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", notionalQuantityScheduleLeg1=" + String.valueOf(this.notionalQuantityScheduleLeg1) + ", notionalQuantityScheduleLeg2=" + String.valueOf(this.notionalQuantityScheduleLeg2) + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", eventIdentifier=" + this.eventIdentifier + ", indexFactor=" + String.valueOf(this.indexFactor) + ", embeddedOptionType=" + this.embeddedOptionType + ", upi=" + (this.upi + ", deliveryType=" + this.deliveryType + ", assetClass=" + this.assetClass + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdentification=" + this.underlyingIdentification + ", underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", referenceEntity=" + this.referenceEntity + ", indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", isCrypto=" + this.isCrypto + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", seniority=" + this.seniority + ", series=" + this.series + ", version=" + this.version + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", contractType=" + this.contractType + ", optionStyle=" + this.optionStyle + ", optionType=" + this.optionType + ", packageIdentifier=" + this.packageIdentifier + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", delta=" + String.valueOf(this.delta) + ", technicalRecordId=" + this.technicalRecordId + ", barrier=" + String.valueOf(this.barrier) + ", nonReportable=" + String.valueOf(this.nonReportable) + "}");
        }
    }

    public static interface JFSATransactionReportBuilder
    extends JFSATransactionReport,
    RosettaModelObjectBuilder {
        public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int var1);

        public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();

        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getPrice();

        public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int var1);

        public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule();

        public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1();

        @Override
        public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1();

        public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2();

        @Override
        public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2();

        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();

        @Override
        public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();

        public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int var1);

        public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule();

        public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int var1);

        public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();

        public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int var1);

        public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();

        public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int var1);

        public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1();

        public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int var1);

        public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2();

        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int var1);

        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();

        public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice();

        @Override
        public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice();

        public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread();

        @Override
        public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread();

        public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier();

        @Override
        public BarrierAndNotation.BarrierAndNotationBuilder getBarrier();

        public JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable();

        @Override
        public JFSANonReportable.JFSANonReportableBuilder getNonReportable();

        public JFSATransactionReportBuilder setEffectiveDate(Date var1);

        public JFSATransactionReportBuilder setExpirationDate(Date var1);

        public JFSATransactionReportBuilder setEarlyTerminationDate(Date var1);

        public JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setEntityResponsibleForReporting(String var1);

        public JFSATransactionReportBuilder setCounterparty1(String var1);

        public JFSATransactionReportBuilder setCounterparty2(String var1);

        public JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        public JFSATransactionReportBuilder setDirection1(String var1);

        public JFSATransactionReportBuilder setDirection2Leg1(String var1);

        public JFSATransactionReportBuilder setDirection2Leg2(String var1);

        public JFSATransactionReportBuilder setSubmitterIdentifier(String var1);

        public JFSATransactionReportBuilder setNewSDRIdentifier(String var1);

        public JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        public JFSATransactionReportBuilder setCleared(String var1);

        public JFSATransactionReportBuilder setCentralCounterparty(String var1);

        public JFSATransactionReportBuilder setClearingMember(String var1);

        public JFSATransactionReportBuilder setPlatformIdentifier(String var1);

        public JFSATransactionReportBuilder setConfirmed(String var1);

        public JFSATransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        public JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setClearingAccountOrigin(String var1);

        public JFSATransactionReportBuilder setOriginalSwapUTI(String var1);

        public JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String var1);

        public JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setUti(String var1);

        public JFSATransactionReportBuilder setUtiProprietary(String var1);

        public JFSATransactionReportBuilder setPriorUti(String var1);

        public JFSATransactionReportBuilder setPriorUtiProprietary(String var1);

        public JFSATransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code var1);

        public JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code var1);

        public JFSATransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code var1);

        public JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code var1);

        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String var1);

        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String var1);

        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String var1);

        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String var1);

        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer var1);

        public JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer var1);

        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer var1);

        public JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer var1);

        public JFSATransactionReportBuilder setFixingDateLeg1(ZonedDateTime var1);

        public JFSATransactionReportBuilder setFixingDateLeg2(ZonedDateTime var1);

        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String var1);

        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String var1);

        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer var1);

        public JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer var1);

        public JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport var1);

        public JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport var1, int var2);

        public JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> var1);

        public JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> var1);

        public JFSATransactionReportBuilder setValuationAmount(BigDecimal var1);

        public JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        public JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        public JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public JFSATransactionReportBuilder setPrice(PriceAndNotation var1);

        public JFSATransactionReportBuilder setPriceNotation(String var1);

        public JFSATransactionReportBuilder setPriceUnitOfMeasure(String var1);

        public JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport var1);

        public JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport var1, int var2);

        public JFSATransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> var1);

        public JFSATransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> var1);

        public JFSATransactionReportBuilder setFixedRateLeg1(BigDecimal var1);

        public JFSATransactionReportBuilder setFixedRateLeg2(BigDecimal var1);

        public JFSATransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 var1);

        public JFSATransactionReportBuilder setSpreadNotationOfLeg1(String var1);

        public JFSATransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 var1);

        public JFSATransactionReportBuilder setSpreadNotationOfLeg2(String var1);

        public JFSATransactionReportBuilder setStrikePrice(StrikePriceAndNotation var1);

        public JFSATransactionReportBuilder setStrikePriceNotation(String var1);

        public JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport var1);

        public JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport var1, int var2);

        public JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> var1);

        public JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> var1);

        public JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        public JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        public JFSATransactionReportBuilder setFirstExerciseDate(Date var1);

        public JFSATransactionReportBuilder setExchangeRate(BigDecimal var1);

        public JFSATransactionReportBuilder setExchangeRateBasis(String var1);

        public JFSATransactionReportBuilder setNotionalLeg1(BigDecimal var1);

        public JFSATransactionReportBuilder setNotionalLeg2(BigDecimal var1);

        public JFSATransactionReportBuilder setCallAmount(BigDecimal var1);

        public JFSATransactionReportBuilder setPutAmount(BigDecimal var1);

        public JFSATransactionReportBuilder setNotionalCurrencyOfLeg1(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String var1);

        public JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String var1);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report var1);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report var1, int var2);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public JFSATransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> var1);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report var1);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report var1, int var2);

        public JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public JFSATransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> var1);

        public JFSATransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal var1);

        public JFSATransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal var1);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report var1);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report var1, int var2);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> var1);

        public JFSATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> var1);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report var1);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report var1, int var2);

        public JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> var1);

        public JFSATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> var1);

        public JFSATransactionReportBuilder setActionType(String var1);

        public JFSATransactionReportBuilder setEventType(String var1);

        public JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        public JFSATransactionReportBuilder setEventIdentifier(String var1);

        public JFSATransactionReportBuilder setIndexFactor(BigDecimal var1);

        public JFSATransactionReportBuilder setEmbeddedOptionType(String var1);

        public JFSATransactionReportBuilder setUpi(String var1);

        public JFSATransactionReportBuilder setDeliveryType(String var1);

        public JFSATransactionReportBuilder setAssetClass(String var1);

        public JFSATransactionReportBuilder setUnderlyingIdentificationType(String var1);

        public JFSATransactionReportBuilder setUnderlyingIdentification(String var1);

        public JFSATransactionReportBuilder setUnderlyingIndexIndicator(String var1);

        public JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        public JFSATransactionReportBuilder setReferenceEntity(String var1);

        public JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String var1);

        public JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String var1);

        public JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String var1);

        public JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String var1);

        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String var1);

        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String var1);

        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer var1);

        public JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer var1);

        public JFSATransactionReportBuilder setIsCrypto(Boolean var1);

        public JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        public JFSATransactionReportBuilder setSeniority(String var1);

        public JFSATransactionReportBuilder setSeries(Integer var1);

        public JFSATransactionReportBuilder setVersion(Integer var1);

        public JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        public JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        public JFSATransactionReportBuilder setCustomBasketCode(String var1);

        public JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        public JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        public JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public JFSATransactionReportBuilder setContractType(String var1);

        public JFSATransactionReportBuilder setOptionStyle(String var1);

        public JFSATransactionReportBuilder setOptionType(String var1);

        public JFSATransactionReportBuilder setPackageIdentifier(String var1);

        public JFSATransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice var1);

        public JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setPackageTransactionPriceNotation(String var1);

        public JFSATransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread var1);

        public JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        public JFSATransactionReportBuilder setPackageTransactionSpreadNotation(String var1);

        public JFSATransactionReportBuilder setDelta(BigDecimal var1);

        public JFSATransactionReportBuilder setTechnicalRecordId(String var1);

        public JFSATransactionReportBuilder setBarrier(BarrierAndNotation var1);

        public JFSATransactionReportBuilder setNonReportable(JFSANonReportable var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), String.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2Leg1"), String.class, (Object)this.getDirection2Leg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2Leg2"), String.class, (Object)this.getDirection2Leg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), String.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrencyLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, (Object)this.getOriginalSwapUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiProprietary"), String.class, (Object)this.getUtiProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUti"), String.class, (Object)this.getPriorUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, (Object)this.getPriorUtiProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConventionLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConventionOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, (Object)this.getFixedRatePaymentFrequencyPeriodLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, (Object)this.getFixedRatePaymentFrequencyPeriodLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, (Object)this.getFloatingRatePaymentFrequencyPeriodLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, (Object)this.getFloatingRatePaymentFrequencyPeriodLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDateLeg1"), ZonedDateTime.class, (Object)this.getFixingDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDateLeg2"), ZonedDateTime.class, (Object)this.getFixingDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, (Object)this.getFloatingRateResetFrequencyPeriodOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, (Object)this.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), String.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.PriceScheduleReportBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, (Object)this.getFixedRateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, (Object)this.getFixedRateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.SpreadOfLeg1Builder.class, this.getSpreadOfLeg1(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotationOfLeg1"), String.class, (Object)this.getSpreadNotationOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.SpreadOfLeg2Builder.class, this.getSpreadOfLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), String.class, (Object)this.getSpreadNotationOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.StrikePriceScheduleReportBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, (Object)this.getNotionalLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, (Object)this.getNotionalLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrencyOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, (Object)this.getQuantityUnitOfMeasureLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, (Object)this.getQuantityUnitOfMeasureLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, this.getNotionalAmountScheduleLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, this.getNotionalAmountScheduleLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, (Object)this.getTotalNotionalQuantityLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, this.getNotionalQuantityScheduleLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, this.getNotionalQuantityScheduleLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("upi"), String.class, (Object)this.getUpi(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), String.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), String.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, (Object)this.getUnderlyingIndexIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, (Object)this.getIndicatorOfTheFloatingRateOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, (Object)this.getIndicatorOfTheFloatingRateOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, (Object)this.getNameOfTheFloatingRateOfLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg1TimePeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, (Object)this.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg1Multiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodOfLeg2Multiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, (Object)this.getIsCrypto(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), String.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), Integer.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), String.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), String.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.PackageTransactionPriceBuilder.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.PackageTransactionSpreadBuilder.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.BarrierAndNotationBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.JFSANonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
        }

        public JFSATransactionReportBuilder prune();
    }

    public static class JFSATransactionReportImpl
    implements JFSATransactionReport {
        private final Date effectiveDate;
        private final Date expirationDate;
        private final Date earlyTerminationDate;
        private final ZonedDateTime reportingTimestamp;
        private final ZonedDateTime executionTimestamp;
        private final String entityResponsibleForReporting;
        private final String counterparty1;
        private final String counterparty2;
        private final Boolean counterparty2IdentifierType;
        private final String direction1;
        private final String direction2Leg1;
        private final String direction2Leg2;
        private final String submitterIdentifier;
        private final String newSDRIdentifier;
        private final String originalSwapSDRIdentifier;
        private final String cleared;
        private final String centralCounterparty;
        private final String clearingMember;
        private final String platformIdentifier;
        private final String confirmed;
        private final Date finalContractualSettlementDate;
        private final ZonedDateTime confirmationTimestamp;
        private final ISOCurrencyCodeEnum settlementCurrencyLeg1;
        private final ISOCurrencyCodeEnum settlementCurrencyLeg2;
        private final String clearingAccountOrigin;
        private final String originalSwapUTI;
        private final String originalSwapUTIProprietary;
        private final ZonedDateTime clearingReceiptTimestamp;
        private final String uti;
        private final String utiProprietary;
        private final String priorUti;
        private final String priorUtiProprietary;
        private final InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
        private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
        private final InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
        private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
        private final String fixedRatePaymentFrequencyPeriodLeg1;
        private final String fixedRatePaymentFrequencyPeriodLeg2;
        private final String floatingRatePaymentFrequencyPeriodLeg1;
        private final String floatingRatePaymentFrequencyPeriodLeg2;
        private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
        private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
        private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
        private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
        private final ZonedDateTime fixingDateLeg1;
        private final ZonedDateTime fixingDateLeg2;
        private final String floatingRateResetFrequencyPeriodLeg1;
        private final String floatingRateResetFrequencyPeriodOfLeg2;
        private final Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
        private final Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
        private final List<? extends OtherPaymentReport> otherPayment;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final ZonedDateTime valuationTimestamp;
        private final Boolean collateralPortfolioIndicator;
        private final String initialMarginCollateralPortfolioCode;
        private final String variationMarginCollateralPortfolioCode;
        private final PriceAndNotation price;
        private final String priceNotation;
        private final String priceUnitOfMeasure;
        private final List<? extends PriceScheduleReport> priceSchedule;
        private final BigDecimal fixedRateLeg1;
        private final BigDecimal fixedRateLeg2;
        private final SpreadOfLeg1 spreadOfLeg1;
        private final String spreadNotationOfLeg1;
        private final SpreadOfLeg2 spreadOfLeg2;
        private final String spreadNotationOfLeg2;
        private final StrikePriceAndNotation strikePrice;
        private final String strikePriceNotation;
        private final List<? extends StrikePriceScheduleReport> strikePriceSchedule;
        private final BigDecimal optionPremiumAmount;
        private final ISOCurrencyCodeEnum optionPremiumCurrency;
        private final Date optionPremiumPaymentDate;
        private final Date firstExerciseDate;
        private final BigDecimal exchangeRate;
        private final String exchangeRateBasis;
        private final BigDecimal notionalLeg1;
        private final BigDecimal notionalLeg2;
        private final BigDecimal callAmount;
        private final BigDecimal putAmount;
        private final ISOCurrencyCodeEnum notionalCurrencyOfLeg1;
        private final ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
        private final ISOCurrencyCodeEnum callCurrency;
        private final ISOCurrencyCodeEnum putCurrency;
        private final String quantityUnitOfMeasureLeg1;
        private final String quantityUnitOfMeasureLeg2;
        private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
        private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
        private final BigDecimal totalNotionalQuantityLeg1;
        private final BigDecimal totalNotionalQuantityLeg2;
        private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1;
        private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2;
        private final String actionType;
        private final String eventType;
        private final ZonedDateTime eventTimestamp;
        private final String eventIdentifier;
        private final BigDecimal indexFactor;
        private final String embeddedOptionType;
        private final String upi;
        private final String deliveryType;
        private final String assetClass;
        private final String underlyingIdentificationType;
        private final String underlyingIdentification;
        private final String underlyingIndexIndicator;
        private final String nameOfTheUnderlyingIndex;
        private final String referenceEntity;
        private final String indicatorOfTheFloatingRateOfLeg1;
        private final String indicatorOfTheFloatingRateOfLeg2;
        private final String nameOfTheFloatingRateOfLeg1;
        private final String nameOfTheFloatingRateOfLeg2;
        private final String floatingRateReferencePeriodOfLeg1TimePeriod;
        private final String floatingRateReferencePeriodOfLeg2TimePeriod;
        private final Integer floatingRateReferencePeriodOfLeg1Multiplier;
        private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
        private final Boolean isCrypto;
        private final Date maturityDateOfTheUnderlying;
        private final String seniority;
        private final Integer series;
        private final Integer version;
        private final BigDecimal cdSIndexAttachmentPoint;
        private final BigDecimal cdSIndexDetachmentPoint;
        private final String customBasketCode;
        private final List<? extends BasketConstituentsReport> basketConstituents;
        private final String contractType;
        private final String optionStyle;
        private final String optionType;
        private final String packageIdentifier;
        private final PackageTransactionPrice packageTransactionPrice;
        private final ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        private final String packageTransactionPriceNotation;
        private final PackageTransactionSpread packageTransactionSpread;
        private final ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        private final String packageTransactionSpreadNotation;
        private final BigDecimal delta;
        private final String technicalRecordId;
        private final BarrierAndNotation barrier;
        private final JFSANonReportable nonReportable;

        protected JFSATransactionReportImpl(JFSATransactionReportBuilder builder) {
            this.effectiveDate = builder.getEffectiveDate();
            this.expirationDate = builder.getExpirationDate();
            this.earlyTerminationDate = builder.getEarlyTerminationDate();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.direction1 = builder.getDirection1();
            this.direction2Leg1 = builder.getDirection2Leg1();
            this.direction2Leg2 = builder.getDirection2Leg2();
            this.submitterIdentifier = builder.getSubmitterIdentifier();
            this.newSDRIdentifier = builder.getNewSDRIdentifier();
            this.originalSwapSDRIdentifier = builder.getOriginalSwapSDRIdentifier();
            this.cleared = builder.getCleared();
            this.centralCounterparty = builder.getCentralCounterparty();
            this.clearingMember = builder.getClearingMember();
            this.platformIdentifier = builder.getPlatformIdentifier();
            this.confirmed = builder.getConfirmed();
            this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
            this.confirmationTimestamp = builder.getConfirmationTimestamp();
            this.settlementCurrencyLeg1 = builder.getSettlementCurrencyLeg1();
            this.settlementCurrencyLeg2 = builder.getSettlementCurrencyLeg2();
            this.clearingAccountOrigin = builder.getClearingAccountOrigin();
            this.originalSwapUTI = builder.getOriginalSwapUTI();
            this.originalSwapUTIProprietary = builder.getOriginalSwapUTIProprietary();
            this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
            this.uti = builder.getUti();
            this.utiProprietary = builder.getUtiProprietary();
            this.priorUti = builder.getPriorUti();
            this.priorUtiProprietary = builder.getPriorUtiProprietary();
            this.fixedRateDayCountConventionLeg1 = builder.getFixedRateDayCountConventionLeg1();
            this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
            this.fixedRateDayCountConventionLeg2 = builder.getFixedRateDayCountConventionLeg2();
            this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
            this.fixedRatePaymentFrequencyPeriodLeg1 = builder.getFixedRatePaymentFrequencyPeriodLeg1();
            this.fixedRatePaymentFrequencyPeriodLeg2 = builder.getFixedRatePaymentFrequencyPeriodLeg2();
            this.floatingRatePaymentFrequencyPeriodLeg1 = builder.getFloatingRatePaymentFrequencyPeriodLeg1();
            this.floatingRatePaymentFrequencyPeriodLeg2 = builder.getFloatingRatePaymentFrequencyPeriodLeg2();
            this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
            this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
            this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
            this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
            this.fixingDateLeg1 = builder.getFixingDateLeg1();
            this.fixingDateLeg2 = builder.getFixingDateLeg2();
            this.floatingRateResetFrequencyPeriodLeg1 = builder.getFloatingRateResetFrequencyPeriodLeg1();
            this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
            this.floatingRateResetFrequencyPeriodMultiplierLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg1();
            this.floatingRateResetFrequencyPeriodMultiplierLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg2();
            this.otherPayment = Optional.ofNullable(builder.getOtherPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.priceNotation = builder.getPriceNotation();
            this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
            this.priceSchedule = Optional.ofNullable(builder.getPriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fixedRateLeg1 = builder.getFixedRateLeg1();
            this.fixedRateLeg2 = builder.getFixedRateLeg2();
            this.spreadOfLeg1 = Optional.ofNullable(builder.getSpreadOfLeg1()).map(f -> f.build()).orElse(null);
            this.spreadNotationOfLeg1 = builder.getSpreadNotationOfLeg1();
            this.spreadOfLeg2 = Optional.ofNullable(builder.getSpreadOfLeg2()).map(f -> f.build()).orElse(null);
            this.spreadNotationOfLeg2 = builder.getSpreadNotationOfLeg2();
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.strikePriceNotation = builder.getStrikePriceNotation();
            this.strikePriceSchedule = Optional.ofNullable(builder.getStrikePriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionPremiumAmount = builder.getOptionPremiumAmount();
            this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
            this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
            this.firstExerciseDate = builder.getFirstExerciseDate();
            this.exchangeRate = builder.getExchangeRate();
            this.exchangeRateBasis = builder.getExchangeRateBasis();
            this.notionalLeg1 = builder.getNotionalLeg1();
            this.notionalLeg2 = builder.getNotionalLeg2();
            this.callAmount = builder.getCallAmount();
            this.putAmount = builder.getPutAmount();
            this.notionalCurrencyOfLeg1 = builder.getNotionalCurrencyOfLeg1();
            this.notionalCurrencyOfLeg2 = builder.getNotionalCurrencyOfLeg2();
            this.callCurrency = builder.getCallCurrency();
            this.putCurrency = builder.getPutCurrency();
            this.quantityUnitOfMeasureLeg1 = builder.getQuantityUnitOfMeasureLeg1();
            this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
            this.notionalAmountScheduleLeg1 = Optional.ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalAmountScheduleLeg2 = Optional.ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
            this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
            this.notionalQuantityScheduleLeg1 = Optional.ofNullable(builder.getNotionalQuantityScheduleLeg1()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalQuantityScheduleLeg2 = Optional.ofNullable(builder.getNotionalQuantityScheduleLeg2()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.actionType = builder.getActionType();
            this.eventType = builder.getEventType();
            this.eventTimestamp = builder.getEventTimestamp();
            this.eventIdentifier = builder.getEventIdentifier();
            this.indexFactor = builder.getIndexFactor();
            this.embeddedOptionType = builder.getEmbeddedOptionType();
            this.upi = builder.getUpi();
            this.deliveryType = builder.getDeliveryType();
            this.assetClass = builder.getAssetClass();
            this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
            this.underlyingIdentification = builder.getUnderlyingIdentification();
            this.underlyingIndexIndicator = builder.getUnderlyingIndexIndicator();
            this.nameOfTheUnderlyingIndex = builder.getNameOfTheUnderlyingIndex();
            this.referenceEntity = builder.getReferenceEntity();
            this.indicatorOfTheFloatingRateOfLeg1 = builder.getIndicatorOfTheFloatingRateOfLeg1();
            this.indicatorOfTheFloatingRateOfLeg2 = builder.getIndicatorOfTheFloatingRateOfLeg2();
            this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
            this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
            this.floatingRateReferencePeriodOfLeg1TimePeriod = builder.getFloatingRateReferencePeriodOfLeg1TimePeriod();
            this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
            this.floatingRateReferencePeriodOfLeg1Multiplier = builder.getFloatingRateReferencePeriodOfLeg1Multiplier();
            this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
            this.isCrypto = builder.getIsCrypto();
            this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
            this.seniority = builder.getSeniority();
            this.series = builder.getSeries();
            this.version = builder.getVersion();
            this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
            this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
            this.customBasketCode = builder.getCustomBasketCode();
            this.basketConstituents = Optional.ofNullable(builder.getBasketConstituents()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.contractType = builder.getContractType();
            this.optionStyle = builder.getOptionStyle();
            this.optionType = builder.getOptionType();
            this.packageIdentifier = builder.getPackageIdentifier();
            this.packageTransactionPrice = Optional.ofNullable(builder.getPackageTransactionPrice()).map(f -> f.build()).orElse(null);
            this.packageTransactionPriceCurrency = builder.getPackageTransactionPriceCurrency();
            this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
            this.packageTransactionSpread = Optional.ofNullable(builder.getPackageTransactionSpread()).map(f -> f.build()).orElse(null);
            this.packageTransactionSpreadCurrency = builder.getPackageTransactionSpreadCurrency();
            this.packageTransactionSpreadNotation = builder.getPackageTransactionSpreadNotation();
            this.delta = builder.getDelta();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.barrier = Optional.ofNullable(builder.getBarrier()).map(f -> f.build()).orElse(null);
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public String getDirection1() {
            return this.direction1;
        }

        @Override
        @RosettaAttribute(value="direction2Leg1")
        @RuneAttribute(value="direction2Leg1")
        public String getDirection2Leg1() {
            return this.direction2Leg1;
        }

        @Override
        @RosettaAttribute(value="direction2Leg2")
        @RuneAttribute(value="direction2Leg2")
        public String getDirection2Leg2() {
            return this.direction2Leg2;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public String getNewSDRIdentifier() {
            return this.newSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public String getOriginalSwapSDRIdentifier() {
            return this.originalSwapSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public String getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ZonedDateTime getConfirmationTimestamp() {
            return this.confirmationTimestamp;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg1")
        @RuneAttribute(value="settlementCurrencyLeg1")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
            return this.settlementCurrencyLeg1;
        }

        @Override
        @RosettaAttribute(value="settlementCurrencyLeg2")
        @RuneAttribute(value="settlementCurrencyLeg2")
        public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
            return this.settlementCurrencyLeg2;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public String getClearingAccountOrigin() {
            return this.clearingAccountOrigin;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public String getOriginalSwapUTI() {
            return this.originalSwapUTI;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTIProprietary")
        @RuneAttribute(value="originalSwapUTIProprietary")
        public String getOriginalSwapUTIProprietary() {
            return this.originalSwapUTIProprietary;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public ZonedDateTime getClearingReceiptTimestamp() {
            return this.clearingReceiptTimestamp;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public String getUti() {
            return this.uti;
        }

        @Override
        @RosettaAttribute(value="utiProprietary")
        @RuneAttribute(value="utiProprietary")
        public String getUtiProprietary() {
            return this.utiProprietary;
        }

        @Override
        @RosettaAttribute(value="priorUti")
        @RuneAttribute(value="priorUti")
        public String getPriorUti() {
            return this.priorUti;
        }

        @Override
        @RosettaAttribute(value="priorUtiProprietary")
        @RuneAttribute(value="priorUtiProprietary")
        public String getPriorUtiProprietary() {
            return this.priorUtiProprietary;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg1")
        @RuneAttribute(value="fixedRateDayCountConventionLeg1")
        public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
            return this.fixedRateDayCountConventionLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg1")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg1")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
            return this.floatingRateDayCountConventionOfLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConventionLeg2")
        @RuneAttribute(value="fixedRateDayCountConventionLeg2")
        public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
            return this.fixedRateDayCountConventionLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConventionOfLeg2")
        @RuneAttribute(value="floatingRateDayCountConventionOfLeg2")
        public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
            return this.floatingRateDayCountConventionOfLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg1")
        public String getFixedRatePaymentFrequencyPeriodLeg1() {
            return this.fixedRatePaymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodLeg2")
        public String getFixedRatePaymentFrequencyPeriodLeg2() {
            return this.fixedRatePaymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg1")
        public String getFloatingRatePaymentFrequencyPeriodLeg1() {
            return this.floatingRatePaymentFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodLeg2")
        public String getFloatingRatePaymentFrequencyPeriodLeg2() {
            return this.floatingRatePaymentFrequencyPeriodLeg2;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg1")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplierLeg2")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
            return this.fixedRatePaymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg1")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplierLeg2")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
            return this.floatingRatePaymentFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg1")
        @RuneAttribute(value="fixingDateLeg1")
        public ZonedDateTime getFixingDateLeg1() {
            return this.fixingDateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixingDateLeg2")
        @RuneAttribute(value="fixingDateLeg2")
        public ZonedDateTime getFixingDateLeg2() {
            return this.fixingDateLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodLeg1")
        public String getFloatingRateResetFrequencyPeriodLeg1() {
            return this.floatingRateResetFrequencyPeriodLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodOfLeg2")
        public String getFloatingRateResetFrequencyPeriodOfLeg2() {
            return this.floatingRateResetFrequencyPeriodOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg1")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
            return this.floatingRateResetFrequencyPeriodMultiplierLeg1;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        @RuneAttribute(value="floatingRateResetFrequencyPeriodMultiplierLeg2")
        public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
            return this.floatingRateResetFrequencyPeriodMultiplierLeg2;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPaymentReport> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceAndNotation getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public String getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PriceScheduleReport> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg1")
        @RuneAttribute(value="fixedRateLeg1")
        public BigDecimal getFixedRateLeg1() {
            return this.fixedRateLeg1;
        }

        @Override
        @RosettaAttribute(value="fixedRateLeg2")
        @RuneAttribute(value="fixedRateLeg2")
        public BigDecimal getFixedRateLeg2() {
            return this.fixedRateLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg1")
        @RuneAttribute(value="spreadOfLeg1")
        public SpreadOfLeg1 getSpreadOfLeg1() {
            return this.spreadOfLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg1")
        @RuneAttribute(value="spreadNotationOfLeg1")
        public String getSpreadNotationOfLeg1() {
            return this.spreadNotationOfLeg1;
        }

        @Override
        @RosettaAttribute(value="spreadOfLeg2")
        @RuneAttribute(value="spreadOfLeg2")
        public SpreadOfLeg2 getSpreadOfLeg2() {
            return this.spreadOfLeg2;
        }

        @Override
        @RosettaAttribute(value="spreadNotationOfLeg2")
        @RuneAttribute(value="spreadNotationOfLeg2")
        public String getSpreadNotationOfLeg2() {
            return this.spreadNotationOfLeg2;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public StrikePriceAndNotation getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public String getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="notionalLeg1")
        @RuneAttribute(value="notionalLeg1")
        public BigDecimal getNotionalLeg1() {
            return this.notionalLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalLeg2")
        @RuneAttribute(value="notionalLeg2")
        public BigDecimal getNotionalLeg2() {
            return this.notionalLeg2;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg1")
        @RuneAttribute(value="notionalCurrencyOfLeg1")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1() {
            return this.notionalCurrencyOfLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalCurrencyOfLeg2")
        @RuneAttribute(value="notionalCurrencyOfLeg2")
        public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
            return this.notionalCurrencyOfLeg2;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg1")
        @RuneAttribute(value="quantityUnitOfMeasureLeg1")
        public String getQuantityUnitOfMeasureLeg1() {
            return this.quantityUnitOfMeasureLeg1;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasureLeg2")
        @RuneAttribute(value="quantityUnitOfMeasureLeg2")
        public String getQuantityUnitOfMeasureLeg2() {
            return this.quantityUnitOfMeasureLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg1")
        @RuneAttribute(value="notionalAmountScheduleLeg1")
        public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
            return this.notionalAmountScheduleLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalAmountScheduleLeg2")
        @RuneAttribute(value="notionalAmountScheduleLeg2")
        public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
            return this.notionalAmountScheduleLeg2;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg1")
        @RuneAttribute(value="totalNotionalQuantityLeg1")
        public BigDecimal getTotalNotionalQuantityLeg1() {
            return this.totalNotionalQuantityLeg1;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantityLeg2")
        @RuneAttribute(value="totalNotionalQuantityLeg2")
        public BigDecimal getTotalNotionalQuantityLeg2() {
            return this.totalNotionalQuantityLeg2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg1")
        @RuneAttribute(value="notionalQuantityScheduleLeg1")
        public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1() {
            return this.notionalQuantityScheduleLeg1;
        }

        @Override
        @RosettaAttribute(value="notionalQuantityScheduleLeg2")
        @RuneAttribute(value="notionalQuantityScheduleLeg2")
        public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2() {
            return this.notionalQuantityScheduleLeg2;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public String getEmbeddedOptionType() {
            return this.embeddedOptionType;
        }

        @Override
        @RosettaAttribute(value="upi")
        @RuneAttribute(value="upi")
        public String getUpi() {
            return this.upi;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public String getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public String getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public String getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public String getUnderlyingIdentification() {
            return this.underlyingIdentification;
        }

        @Override
        @RosettaAttribute(value="underlyingIndexIndicator")
        @RuneAttribute(value="underlyingIndexIndicator")
        public String getUnderlyingIndexIndicator() {
            return this.underlyingIndexIndicator;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public String getNameOfTheUnderlyingIndex() {
            return this.nameOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public String getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg1")
        public String getIndicatorOfTheFloatingRateOfLeg1() {
            return this.indicatorOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="indicatorOfTheFloatingRateOfLeg2")
        public String getIndicatorOfTheFloatingRateOfLeg2() {
            return this.indicatorOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg1")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg1")
        public String getNameOfTheFloatingRateOfLeg1() {
            return this.nameOfTheFloatingRateOfLeg1;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRateOfLeg2")
        @RuneAttribute(value="nameOfTheFloatingRateOfLeg2")
        public String getNameOfTheFloatingRateOfLeg2() {
            return this.nameOfTheFloatingRateOfLeg2;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg1TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2TimePeriod")
        public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
            return this.floatingRateReferencePeriodOfLeg2TimePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg1Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
            return this.floatingRateReferencePeriodOfLeg1Multiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        @RuneAttribute(value="floatingRateReferencePeriodOfLeg2Multiplier")
        public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
            return this.floatingRateReferencePeriodOfLeg2Multiplier;
        }

        @Override
        @RosettaAttribute(value="isCrypto", isRequired=true)
        @RuneAttribute(value="isCrypto", isRequired=true)
        public Boolean getIsCrypto() {
            return this.isCrypto;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public String getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public Integer getSeries() {
            return this.series;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public Integer getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public String getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public String getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PackageTransactionPrice getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public String getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PackageTransactionSpread getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public String getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public BarrierAndNotation getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public JFSANonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public JFSATransactionReport build() {
            return this;
        }

        @Override
        public JFSATransactionReportBuilder toBuilder() {
            JFSATransactionReportBuilder builder = JFSATransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(JFSATransactionReportBuilder builder) {
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getEarlyTerminationDate()).ifPresent(builder::setEarlyTerminationDate);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
            Optional.ofNullable(this.getDirection1()).ifPresent(builder::setDirection1);
            Optional.ofNullable(this.getDirection2Leg1()).ifPresent(builder::setDirection2Leg1);
            Optional.ofNullable(this.getDirection2Leg2()).ifPresent(builder::setDirection2Leg2);
            Optional.ofNullable(this.getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
            Optional.ofNullable(this.getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
            Optional.ofNullable(this.getOriginalSwapSDRIdentifier()).ifPresent(builder::setOriginalSwapSDRIdentifier);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
            Optional.ofNullable(this.getClearingMember()).ifPresent(builder::setClearingMember);
            Optional.ofNullable(this.getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
            Optional.ofNullable(this.getConfirmed()).ifPresent(builder::setConfirmed);
            Optional.ofNullable(this.getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
            Optional.ofNullable(this.getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
            Optional.ofNullable(this.getSettlementCurrencyLeg1()).ifPresent(builder::setSettlementCurrencyLeg1);
            Optional.ofNullable(this.getSettlementCurrencyLeg2()).ifPresent(builder::setSettlementCurrencyLeg2);
            Optional.ofNullable(this.getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
            Optional.ofNullable(this.getOriginalSwapUTI()).ifPresent(builder::setOriginalSwapUTI);
            Optional.ofNullable(this.getOriginalSwapUTIProprietary()).ifPresent(builder::setOriginalSwapUTIProprietary);
            Optional.ofNullable(this.getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
            Optional.ofNullable(this.getUti()).ifPresent(builder::setUti);
            Optional.ofNullable(this.getUtiProprietary()).ifPresent(builder::setUtiProprietary);
            Optional.ofNullable(this.getPriorUti()).ifPresent(builder::setPriorUti);
            Optional.ofNullable(this.getPriorUtiProprietary()).ifPresent(builder::setPriorUtiProprietary);
            Optional.ofNullable(this.getFixedRateDayCountConventionLeg1()).ifPresent(builder::setFixedRateDayCountConventionLeg1);
            Optional.ofNullable(this.getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
            Optional.ofNullable(this.getFixedRateDayCountConventionLeg2()).ifPresent(builder::setFixedRateDayCountConventionLeg2);
            Optional.ofNullable(this.getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg1);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg2);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg1);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg2);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
            Optional.ofNullable(this.getFixingDateLeg1()).ifPresent(builder::setFixingDateLeg1);
            Optional.ofNullable(this.getFixingDateLeg2()).ifPresent(builder::setFixingDateLeg2);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodLeg1);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
            Optional.ofNullable(this.getOtherPayment()).ifPresent(builder::setOtherPayment);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getPriceNotation()).ifPresent(builder::setPriceNotation);
            Optional.ofNullable(this.getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
            Optional.ofNullable(this.getPriceSchedule()).ifPresent(builder::setPriceSchedule);
            Optional.ofNullable(this.getFixedRateLeg1()).ifPresent(builder::setFixedRateLeg1);
            Optional.ofNullable(this.getFixedRateLeg2()).ifPresent(builder::setFixedRateLeg2);
            Optional.ofNullable(this.getSpreadOfLeg1()).ifPresent(builder::setSpreadOfLeg1);
            Optional.ofNullable(this.getSpreadNotationOfLeg1()).ifPresent(builder::setSpreadNotationOfLeg1);
            Optional.ofNullable(this.getSpreadOfLeg2()).ifPresent(builder::setSpreadOfLeg2);
            Optional.ofNullable(this.getSpreadNotationOfLeg2()).ifPresent(builder::setSpreadNotationOfLeg2);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
            Optional.ofNullable(this.getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
            Optional.ofNullable(this.getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
            Optional.ofNullable(this.getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
            Optional.ofNullable(this.getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
            Optional.ofNullable(this.getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
            Optional.ofNullable(this.getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
            Optional.ofNullable(this.getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
            Optional.ofNullable(this.getCallAmount()).ifPresent(builder::setCallAmount);
            Optional.ofNullable(this.getPutAmount()).ifPresent(builder::setPutAmount);
            Optional.ofNullable(this.getNotionalCurrencyOfLeg1()).ifPresent(builder::setNotionalCurrencyOfLeg1);
            Optional.ofNullable(this.getNotionalCurrencyOfLeg2()).ifPresent(builder::setNotionalCurrencyOfLeg2);
            Optional.ofNullable(this.getCallCurrency()).ifPresent(builder::setCallCurrency);
            Optional.ofNullable(this.getPutCurrency()).ifPresent(builder::setPutCurrency);
            Optional.ofNullable(this.getQuantityUnitOfMeasureLeg1()).ifPresent(builder::setQuantityUnitOfMeasureLeg1);
            Optional.ofNullable(this.getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
            Optional.ofNullable(this.getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
            Optional.ofNullable(this.getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
            Optional.ofNullable(this.getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
            Optional.ofNullable(this.getNotionalQuantityScheduleLeg1()).ifPresent(builder::setNotionalQuantityScheduleLeg1);
            Optional.ofNullable(this.getNotionalQuantityScheduleLeg2()).ifPresent(builder::setNotionalQuantityScheduleLeg2);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
            Optional.ofNullable(this.getEmbeddedOptionType()).ifPresent(builder::setEmbeddedOptionType);
            Optional.ofNullable(this.getUpi()).ifPresent(builder::setUpi);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
            Optional.ofNullable(this.getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
            Optional.ofNullable(this.getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
            Optional.ofNullable(this.getUnderlyingIndexIndicator()).ifPresent(builder::setUnderlyingIndexIndicator);
            Optional.ofNullable(this.getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
            Optional.ofNullable(this.getReferenceEntity()).ifPresent(builder::setReferenceEntity);
            Optional.ofNullable(this.getIndicatorOfTheFloatingRateOfLeg1()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg1);
            Optional.ofNullable(this.getIndicatorOfTheFloatingRateOfLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg2);
            Optional.ofNullable(this.getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
            Optional.ofNullable(this.getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg1TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1TimePeriod);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg1Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1Multiplier);
            Optional.ofNullable(this.getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
            Optional.ofNullable(this.getIsCrypto()).ifPresent(builder::setIsCrypto);
            Optional.ofNullable(this.getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getSeries()).ifPresent(builder::setSeries);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
            Optional.ofNullable(this.getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
            Optional.ofNullable(this.getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
            Optional.ofNullable(this.getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
            Optional.ofNullable(this.getBasketConstituents()).ifPresent(builder::setBasketConstituents);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractType);
            Optional.ofNullable(this.getOptionStyle()).ifPresent(builder::setOptionStyle);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
            Optional.ofNullable(this.getPackageTransactionPriceCurrency()).ifPresent(builder::setPackageTransactionPriceCurrency);
            Optional.ofNullable(this.getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
            Optional.ofNullable(this.getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
            Optional.ofNullable(this.getPackageTransactionSpreadCurrency()).ifPresent(builder::setPackageTransactionSpreadCurrency);
            Optional.ofNullable(this.getPackageTransactionSpreadNotation()).ifPresent(builder::setPackageTransactionSpreadNotation);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            JFSATransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.direction1, _that.getDirection1())) {
                return false;
            }
            if (!Objects.equals(this.direction2Leg1, _that.getDirection2Leg1())) {
                return false;
            }
            if (!Objects.equals(this.direction2Leg2, _that.getDirection2Leg2())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.newSDRIdentifier, _that.getNewSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.confirmationTimestamp, _that.getConfirmationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) {
                return false;
            }
            if (!Objects.equals(this.clearingAccountOrigin, _that.getClearingAccountOrigin())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUTI, _that.getOriginalSwapUTI())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) {
                return false;
            }
            if (!Objects.equals(this.clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uti, _that.getUti())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietary, _that.getUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.priorUti, _that.getPriorUti())) {
                return false;
            }
            if (!Objects.equals(this.priorUtiProprietary, _that.getPriorUtiProprietary())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateLeg1, _that.getFixingDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateLeg2, _that.getFixingDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.priceNotation, _that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg1, _that.getFixedRateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateLeg2, _that.getFixedRateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg1, _that.getSpreadOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationOfLeg1, _that.getSpreadNotationOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.spreadOfLeg2, _that.getSpreadOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceNotation, _that.getStrikePriceNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg1, _that.getNotionalLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalLeg2, _that.getNotionalLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg1, _that.getNotionalCurrencyOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals(this.embeddedOptionType, _that.getEmbeddedOptionType())) {
                return false;
            }
            if (!Objects.equals(this.upi, _that.getUpi())) {
                return false;
            }
            if (!Objects.equals(this.deliveryType, _that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.assetClass, _that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentificationType, _that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentification, _that.getUnderlyingIdentification())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) {
                return false;
            }
            if (!Objects.equals(this.isCrypto, _that.getIsCrypto())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.series, _that.getSeries())) {
                return false;
            }
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!Objects.equals(this.contractType, _that.getContractType())) {
                return false;
            }
            if (!Objects.equals(this.optionStyle, _that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.direction1 != null ? this.direction1.hashCode() : 0);
            _result = 31 * _result + (this.direction2Leg1 != null ? this.direction2Leg1.hashCode() : 0);
            _result = 31 * _result + (this.direction2Leg2 != null ? this.direction2Leg2.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.newSDRIdentifier != null ? this.newSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapSDRIdentifier != null ? this.originalSwapSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.confirmationTimestamp != null ? this.confirmationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg1 != null ? this.settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrencyLeg2 != null ? this.settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingAccountOrigin != null ? this.clearingAccountOrigin.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUTI != null ? this.originalSwapUTI.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUTIProprietary != null ? this.originalSwapUTIProprietary.hashCode() : 0);
            _result = 31 * _result + (this.clearingReceiptTimestamp != null ? this.clearingReceiptTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uti != null ? this.uti.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietary != null ? this.utiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.priorUti != null ? this.priorUti.hashCode() : 0);
            _result = 31 * _result + (this.priorUtiProprietary != null ? this.priorUtiProprietary.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionLeg1 != null ? this.fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg1 != null ? this.floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRateDayCountConventionLeg2 != null ? this.fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConventionOfLeg2 != null ? this.floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodLeg1 != null ? this.fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodLeg2 != null ? this.fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodLeg1 != null ? this.floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodLeg2 != null ? this.floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? this.fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? this.floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateLeg1 != null ? this.fixingDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateLeg2 != null ? this.fixingDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodLeg1 != null ? this.floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodOfLeg2 != null ? this.floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? this.floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? this.floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? this.priceNotation.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg1 != null ? this.fixedRateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateLeg2 != null ? this.fixedRateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg1 != null ? this.spreadOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationOfLeg1 != null ? this.spreadNotationOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.spreadOfLeg2 != null ? this.spreadOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotationOfLeg2 != null ? this.spreadNotationOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? this.strikePriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg1 != null ? this.notionalLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalLeg2 != null ? this.notionalLeg2.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg1 != null ? this.notionalCurrencyOfLeg1.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrencyOfLeg2 != null ? this.notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg1 != null ? this.quantityUnitOfMeasureLeg1.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasureLeg2 != null ? this.quantityUnitOfMeasureLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg1 != null ? this.notionalAmountScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountScheduleLeg2 != null ? this.notionalAmountScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg1 != null ? this.totalNotionalQuantityLeg1.hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantityLeg2 != null ? this.totalNotionalQuantityLeg2.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg1 != null ? this.notionalQuantityScheduleLeg1.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantityScheduleLeg2 != null ? this.notionalQuantityScheduleLeg2.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.embeddedOptionType != null ? this.embeddedOptionType.hashCode() : 0);
            _result = 31 * _result + (this.upi != null ? this.upi.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? this.deliveryType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? this.underlyingIdentificationType.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentification != null ? this.underlyingIdentification.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIndexIndicator != null ? this.underlyingIndexIndicator.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheUnderlyingIndex != null ? this.nameOfTheUnderlyingIndex.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateOfLeg1 != null ? this.indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheFloatingRateOfLeg2 != null ? this.indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg1 != null ? this.nameOfTheFloatingRateOfLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRateOfLeg2 != null ? this.nameOfTheFloatingRateOfLeg2.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg1TimePeriod != null ? this.floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2TimePeriod != null ? this.floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg1Multiplier != null ? this.floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodOfLeg2Multiplier != null ? this.floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
            _result = 31 * _result + (this.isCrypto != null ? this.isCrypto.hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.series != null ? this.series.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? this.contractType.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? this.optionStyle.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? this.packageTransactionPriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? this.packageTransactionSpreadNotation.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "JFSATransactionReport {effectiveDate=" + String.valueOf(this.effectiveDate) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", direction1=" + this.direction1 + ", direction2Leg1=" + this.direction2Leg1 + ", direction2Leg2=" + this.direction2Leg2 + ", submitterIdentifier=" + this.submitterIdentifier + ", newSDRIdentifier=" + this.newSDRIdentifier + ", originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", cleared=" + this.cleared + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", platformIdentifier=" + this.platformIdentifier + ", confirmed=" + this.confirmed + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", confirmationTimestamp=" + String.valueOf(this.confirmationTimestamp) + ", settlementCurrencyLeg1=" + String.valueOf(this.settlementCurrencyLeg1) + ", settlementCurrencyLeg2=" + String.valueOf(this.settlementCurrencyLeg2) + ", clearingAccountOrigin=" + this.clearingAccountOrigin + ", originalSwapUTI=" + this.originalSwapUTI + ", originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", clearingReceiptTimestamp=" + String.valueOf(this.clearingReceiptTimestamp) + ", uti=" + this.uti + ", utiProprietary=" + this.utiProprietary + ", priorUti=" + this.priorUti + ", priorUtiProprietary=" + this.priorUtiProprietary + ", fixedRateDayCountConventionLeg1=" + String.valueOf(this.fixedRateDayCountConventionLeg1) + ", floatingRateDayCountConventionOfLeg1=" + String.valueOf(this.floatingRateDayCountConventionOfLeg1) + ", fixedRateDayCountConventionLeg2=" + String.valueOf(this.fixedRateDayCountConventionLeg2) + ", floatingRateDayCountConventionOfLeg2=" + String.valueOf(this.floatingRateDayCountConventionOfLeg2) + ", fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", fixingDateLeg1=" + String.valueOf(this.fixingDateLeg1) + ", fixingDateLeg2=" + String.valueOf(this.fixingDateLeg2) + ", floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", otherPayment=" + String.valueOf(this.otherPayment) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", price=" + String.valueOf(this.price) + ", priceNotation=" + this.priceNotation + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", fixedRateLeg1=" + String.valueOf(this.fixedRateLeg1) + ", fixedRateLeg2=" + String.valueOf(this.fixedRateLeg2) + ", spreadOfLeg1=" + String.valueOf(this.spreadOfLeg1) + ", spreadNotationOfLeg1=" + this.spreadNotationOfLeg1 + ", spreadOfLeg2=" + String.valueOf(this.spreadOfLeg2) + ", spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + this.strikePriceNotation + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", notionalLeg1=" + String.valueOf(this.notionalLeg1) + ", notionalLeg2=" + String.valueOf(this.notionalLeg2) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalCurrencyOfLeg1=" + String.valueOf(this.notionalCurrencyOfLeg1) + ", notionalCurrencyOfLeg2=" + String.valueOf(this.notionalCurrencyOfLeg2) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", notionalAmountScheduleLeg1=" + String.valueOf(this.notionalAmountScheduleLeg1) + ", notionalAmountScheduleLeg2=" + String.valueOf(this.notionalAmountScheduleLeg2) + ", totalNotionalQuantityLeg1=" + String.valueOf(this.totalNotionalQuantityLeg1) + ", totalNotionalQuantityLeg2=" + String.valueOf(this.totalNotionalQuantityLeg2) + ", notionalQuantityScheduleLeg1=" + String.valueOf(this.notionalQuantityScheduleLeg1) + ", notionalQuantityScheduleLeg2=" + String.valueOf(this.notionalQuantityScheduleLeg2) + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", eventIdentifier=" + this.eventIdentifier + ", indexFactor=" + String.valueOf(this.indexFactor) + ", embeddedOptionType=" + this.embeddedOptionType + ", upi=" + (this.upi + ", deliveryType=" + this.deliveryType + ", assetClass=" + this.assetClass + ", underlyingIdentificationType=" + this.underlyingIdentificationType + ", underlyingIdentification=" + this.underlyingIdentification + ", underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", referenceEntity=" + this.referenceEntity + ", indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", isCrypto=" + this.isCrypto + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", seniority=" + this.seniority + ", series=" + this.series + ", version=" + this.version + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", contractType=" + this.contractType + ", optionStyle=" + this.optionStyle + ", optionType=" + this.optionType + ", packageIdentifier=" + this.packageIdentifier + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", delta=" + String.valueOf(this.delta) + ", technicalRecordId=" + this.technicalRecordId + ", barrier=" + String.valueOf(this.barrier) + ", nonReportable=" + String.valueOf(this.nonReportable) + "}");
        }
    }
}

