/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import javax.inject.Inject;

@ImplementedBy(value=AssetClassRuleDefault.class)
public abstract class AssetClassRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class AssetClassRuleDefault
    extends AssetClassRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()));
            output = (String)thenArg2.mapSingleToItem(item -> {
                Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate((EconomicTerms)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)"INTR");
                }
                Boolean boolean1 = this.qualify_AssetClass_Credit.evaluate((EconomicTerms)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)"CRDT");
                }
                Boolean boolean2 = this.qualify_AssetClass_Equity.evaluate((EconomicTerms)item.get());
                if (boolean2 != null && boolean2.booleanValue()) {
                    return MapperS.of((Object)"EQUI");
                }
                Boolean boolean3 = this.qualify_AssetClass_ForeignExchange.evaluate((EconomicTerms)item.get());
                if (boolean3 != null && boolean3.booleanValue()) {
                    return MapperS.of((Object)"CURR");
                }
                return MapperS.of((Object)"OTHR");
            }).get();
            return output;
        }
    }
}

