/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="JFSATransactionReportDTCC_JFSA_BR_0023_01")
@ImplementedBy(value=Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0023_01
extends Validator<JFSATransactionReport> {
    public static final String NAME = "JFSATransactionReportDTCC_JFSA_BR_0023_01";
    public static final String DEFINITION = "if cleared = \"Y\" and actionType = ActionTypeEnum -> NEWT to-string and [EventTypeEnum -> CLRG to-string, EventTypeEnum -> CLAL to-string] any = eventType then originalSwapUTI exists";

    public static class NoOp
    implements JFSATransactionReportDTCC_JFSA_BR_0023_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements JFSATransactionReportDTCC_JFSA_BR_0023_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            ComparisonResult result = this.executeDataRule(jFSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)JFSATransactionReportDTCC_JFSA_BR_0023_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0023_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)JFSATransactionReportDTCC_JFSA_BR_0023_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0023_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getCleared", _jFSATransactionReport -> _jFSATransactionReport.getCleared()), (Mapper)MapperS.of((Object)"Y"), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)).map("to-string", ActionTypeEnum::toDisplayString), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.CLRG)).map("to-string", EventTypeEnum::toDisplayString), MapperS.of((Object)((Object)EventTypeEnum.CLAL)).map("to-string", EventTypeEnum::toDisplayString)}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getEventType", _jFSATransactionReport -> _jFSATransactionReport.getEventType()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)jFSATransactionReport).map("getOriginalSwapUTI", _jFSATransactionReport -> _jFSATransactionReport.getOriginalSwapUTI()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

