/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.SingleTradeLot;
import drr.regulation.techsprint.g20.mas.reports.ContractForEventRule;
import drr.regulation.techsprint.g20.mas.reports.IsFxPayoutRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=FXExchangeRateRuleDefault.class)
public abstract class FXExchangeRateRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected ContractForEventRule contractForEventRule;
    @Inject
    protected IsFxPayoutRule isFxPayoutRule;
    @Inject
    protected SingleTradeLot singleTradeLot;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class FXExchangeRateRuleDefault
    extends FXExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isFxPayoutRule.evaluate((TransactionReportInstruction)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.contractForEventRule.evaluate((TransactionReportInstruction)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.singleTradeLot.evaluate((Trade)item.get())));
            MapperC thenArg3 = thenArg2.mapSingleToList(item -> item.mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
            MapperC thenArg4 = thenArg3.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg5 = thenArg4.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
            output = (BigDecimal)thenArg5.last().get();
            return output;
        }
    }
}

