/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.functions.VectorOperation;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CDECommodityNotionalDefault.class)
public abstract class CDECommodityNotional
implements RosettaFunction {
    @Inject
    protected VectorOperation vectorOperation;

    public BigDecimal evaluate(NonNegativeQuantitySchedule quantitySchedule, PriceSchedule price) {
        BigDecimal amount = this.doEvaluate(quantitySchedule, price);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(NonNegativeQuantitySchedule var1, PriceSchedule var2);

    public static class CDECommodityNotionalDefault
    extends CDECommodityNotional {
        @Override
        protected BigDecimal doEvaluate(NonNegativeQuantitySchedule quantitySchedule, PriceSchedule price) {
            BigDecimal amount = null;
            return this.assignOutput(amount, quantitySchedule, price);
        }

        protected BigDecimal assignOutput(BigDecimal amount, NonNegativeQuantitySchedule quantitySchedule, PriceSchedule price) {
            amount = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)price).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperC.of((List)this.vectorOperation.evaluate(ArithmeticOperationEnum.MULTIPLY, MapperS.of((Object)price).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()).getMulti(), MapperS.of((Object)quantitySchedule).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()).getMulti())).sumBigDecimal().get() : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)quantitySchedule).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperMaths.multiply((Mapper)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue()), (Mapper)MapperS.of((Object)quantitySchedule).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).get() : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)quantitySchedule).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperMaths.multiply((Mapper)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue()), (Mapper)MapperS.of((Object)quantitySchedule).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()).sumBigDecimal()).get() : null)) : null);
            return amount;
        }
    }
}

