/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.GetPackageInformation;
import javax.inject.Inject;

@ImplementedBy(value=CDEPackageTransactionPriceCurrencyRuleDefault.class)
public abstract class CDEPackageTransactionPriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected GetPackageInformation getPackageInformation;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class CDEPackageTransactionPriceCurrencyRuleDefault
    extends CDEPackageTransactionPriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.getPackageInformation.evaluate(input)).map("getPrice", identifiedList -> identifiedList.getPrice());
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getArithmeticOperator", price -> price.getArithmeticOperator())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                }
                return MapperS.ofNull();
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

